"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class DetectorService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend POST Detectors API.
     */
    _defineProperty(this, "createDetector", async (context, request, response) => {
      try {
        const detector = request.body;
        const params = {
          body: detector
        };
        const client = this.getClient(request, context);
        const createDetectorResponse = await client(_constants.CLIENT_DETECTOR_METHODS.CREATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - createDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend GET Detector API.
     */
    _defineProperty(this, "getDetector", async (context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const client = this.getClient(request, context);
        const getDetectorResponse = await client(_constants.CLIENT_DETECTOR_METHODS.GET_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - getDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend Search Detector API.
     */
    _defineProperty(this, "searchDetectors", async (context, request, response) => {
      try {
        const {
          query
        } = request.body;
        const params = {
          body: {
            size: 10000,
            query
          }
        };
        const client = this.getClient(request, context);
        const searchDetectorResponse = await client(_constants.CLIENT_DETECTOR_METHODS.SEARCH_DETECTORS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - searchDetectors:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend DELETE Detector API.
     */
    _defineProperty(this, "deleteDetector", async (context, request, response) => {
      try {
        const {
          detectorId
        } = request.params;
        const params = {
          detectorId
        };
        const client = this.getClient(request, context);
        const deleteDetectorResponse = await client(_constants.CLIENT_DETECTOR_METHODS.DELETE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend PUT Detectors API.
     */
    _defineProperty(this, "updateDetector", async (context, request, response) => {
      try {
        const detector = request.body;
        const {
          detectorId
        } = request.params;
        const params = {
          body: detector,
          detectorId
        };
        const client = this.getClient(request, context);
        const updateDetectorResponse = await client(_constants.CLIENT_DETECTOR_METHODS.UPDATE_DETECTOR, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - updateDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = DetectorService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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