"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractUserMessageFromError = exports.DISABLED_BACKEND_PLUGIN_MESSAGE = void 0;
const DISABLED_BACKEND_PLUGIN_MESSAGE = exports.DISABLED_BACKEND_PLUGIN_MESSAGE = 'Search Relevance Workbench is disabled';
const extractUserMessageFromError = err => {
  if (err instanceof Error) {
    const errorWithBody = err;
    if (errorWithBody.body && errorWithBody.body.message === DISABLED_BACKEND_PLUGIN_MESSAGE) {
      return 'Search Relevance Workbench is disabled. Please activate the opensearch-search-relevance plugin.';
    }
  }
  return null;
};
exports.extractUserMessageFromError = extractUserMessageFromError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJESVNBQkxFRF9CQUNLRU5EX1BMVUdJTl9NRVNTQUdFIiwiZXhwb3J0cyIsImV4dHJhY3RVc2VyTWVzc2FnZUZyb21FcnJvciIsImVyciIsIkVycm9yIiwiZXJyb3JXaXRoQm9keSIsImJvZHkiLCJtZXNzYWdlIl0sInNvdXJjZXMiOlsiZXJyb3JfaGFuZGxpbmcudHMiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGNvbnN0IERJU0FCTEVEX0JBQ0tFTkRfUExVR0lOX01FU1NBR0UgPSAnU2VhcmNoIFJlbGV2YW5jZSBXb3JrYmVuY2ggaXMgZGlzYWJsZWQnO1xuXG5leHBvcnQgY29uc3QgZXh0cmFjdFVzZXJNZXNzYWdlRnJvbUVycm9yID0gKGVycjogYW55KSA9PiB7XG4gIGlmIChlcnIgaW5zdGFuY2VvZiBFcnJvcikge1xuICAgIGNvbnN0IGVycm9yV2l0aEJvZHkgPSBlcnIgYXMgYW55O1xuICAgIGlmIChlcnJvcldpdGhCb2R5LmJvZHkgJiYgZXJyb3JXaXRoQm9keS5ib2R5Lm1lc3NhZ2UgPT09IERJU0FCTEVEX0JBQ0tFTkRfUExVR0lOX01FU1NBR0UpIHtcbiAgICAgIHJldHVybiAnU2VhcmNoIFJlbGV2YW5jZSBXb3JrYmVuY2ggaXMgZGlzYWJsZWQuIFBsZWFzZSBhY3RpdmF0ZSB0aGUgb3BlbnNlYXJjaC1zZWFyY2gtcmVsZXZhbmNlIHBsdWdpbi4nO1xuICAgIH1cbiAgfVxuICByZXR1cm4gbnVsbDtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFPLE1BQU1BLCtCQUErQixHQUFBQyxPQUFBLENBQUFELCtCQUFBLEdBQUcsd0NBQXdDO0FBRWhGLE1BQU1FLDJCQUEyQixHQUFJQyxHQUFRLElBQUs7RUFDdkQsSUFBSUEsR0FBRyxZQUFZQyxLQUFLLEVBQUU7SUFDeEIsTUFBTUMsYUFBYSxHQUFHRixHQUFVO0lBQ2hDLElBQUlFLGFBQWEsQ0FBQ0MsSUFBSSxJQUFJRCxhQUFhLENBQUNDLElBQUksQ0FBQ0MsT0FBTyxLQUFLUCwrQkFBK0IsRUFBRTtNQUN4RixPQUFPLGlHQUFpRztJQUMxRztFQUNGO0VBQ0EsT0FBTyxJQUFJO0FBQ2IsQ0FBQztBQUFDQyxPQUFBLENBQUFDLDJCQUFBLEdBQUFBLDJCQUFBIn0=