"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;
var _constants = require("../utils/constants");
var _operators = require("rxjs/operators");
var _router = _interopRequireDefault(require("./router"));
var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));
var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));
var _forecastFeature = _interopRequireDefault(require("./cluster/ad/forecastFeature"));
var _ad = _interopRequireWildcard(require("./routes/ad"));
var _alerting = _interopRequireWildcard(require("./routes/alerting"));
var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));
var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));
var _constants2 = require("./utils/constants");
var _forecast = _interopRequireWildcard(require("./routes/forecast"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch;

    // Create OpenSearch client w/ relevant plugins and headers
    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      // forecastFeature is still inside adPlugin, but totally independent from adPlugin
      plugins: [_adPlugin.default, _alertingPlugin.default, _forecastFeature.default],
      customHeaders: {
        ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_adPlugin.default);
      dataSource.registerCustomApiSchema(_alertingPlugin.default);
      dataSource.registerCustomApiSchema(_forecastFeature.default);
    }

    // Create router
    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH);
    const forecastApiRouter = (0, _router.default)(core.http.createRouter(), _constants.FORECAST_BASE_NODE_API_PATH);

    // Create services & register with OpenSearch client
    const adService = new _ad.default(client, dataSourceEnabled);
    const alertingService = new _alerting.default(client, dataSourceEnabled);
    const opensearchService = new _opensearch.default(client, dataSourceEnabled);
    const sampleDataService = new _sampleData.default(client, dataSourceEnabled);
    const forecastService = new _forecast.default(client, dataSourceEnabled);

    // Register server routes with the service
    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    (0, _forecast.registerForecastRoutes)(forecastApiRouter, forecastService);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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