/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collection;
import java.util.LinkedList;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.entities.AuthenticationExecutionEntity;
import org.keycloak.models.jpa.entities.RealmEntity;

@Table(name="AUTHENTICATION_FLOW")
@Entity
public class AuthenticationFlowEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REALM_ID")
    protected RealmEntity realm;
    @Column(name="ALIAS")
    protected String alias;
    @Column(name="PROVIDER_ID")
    protected String providerId;
    @Nationalized
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="TOP_LEVEL")
    protected boolean topLevel;
    @Column(name="BUILT_IN")
    protected boolean builtIn;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="parentFlow")
    Collection<AuthenticationExecutionEntity> executions = new LinkedList<AuthenticationExecutionEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RealmEntity getRealm() {
        return this.realm;
    }

    public void setRealm(RealmEntity realm) {
        this.realm = realm;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<AuthenticationExecutionEntity> getExecutions() {
        if (this.executions == null) {
            this.executions = new LinkedList<AuthenticationExecutionEntity>();
        }
        return this.executions;
    }

    public void setExecutions(Collection<AuthenticationExecutionEntity> executions) {
        this.executions = executions;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AuthenticationFlowEntity)) {
            return false;
        }
        AuthenticationFlowEntity that = (AuthenticationFlowEntity)o;
        return this.id.equals(that.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

