/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.plugins.groovy.extensions.completion.ContextSpecificInsertHandler;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyDocMethodHandler
implements ContextSpecificInsertHandler {
    @Override
    public boolean isAcceptable(InsertionContext context, int startOffset, LookupElement item) {
        String text;
        PsiElement element;
        PsiFile file = context.getFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        for (element = file.findElementAt(startOffset); element != null && !(element instanceof PsiFile) && !(element instanceof GrDocComment); element = element.getParent()) {
        }
        if (!(element instanceof GrDocComment)) {
            return false;
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        return offset < (text = file.getText()).length() && item.getObject() instanceof PsiMethod;
    }

    @Override
    public void handleInsert(InsertionContext context, int startOffset, LookupElement item) {
        Editor editor = context.getEditor();
        Object o = item.getObject();
        assert (o instanceof PsiMethod);
        PsiMethod method = (PsiMethod)o;
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        PsiParameterList params = method.getParameterList();
        int count = params.getParametersCount();
        int i2 = 0;
        for (PsiParameter parameter : params.getParameters()) {
            PsiType type = parameter.getType();
            Object text = type.getCanonicalText();
            if (type instanceof PsiEllipsisType) {
                text = ((String)text).substring(0, ((String)text).length() - 3) + "[]";
            }
            buffer.append(PsiTypesUtil.unboxIfPossible((String)text));
            if (i2 < count - 1) {
                buffer.append(", ");
            }
            ++i2;
        }
        buffer.append(") ");
        CaretModel caretModel = editor.getCaretModel();
        int endOffset = GroovyDocMethodHandler.shortenParamterReferences(context, startOffset, method, buffer);
        caretModel.moveToOffset(endOffset);
    }

    private static int shortenParamterReferences(InsertionContext context, int startOffset, PsiMethod method, StringBuffer buffer) {
        Document document = context.getEditor().getDocument();
        int offset = startOffset + method.getName().length();
        String paramText = buffer.toString();
        document.insertString(offset, (CharSequence)paramText);
        int endOffset = offset + paramText.length();
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiReference ref2 = context.getFile().findReferenceAt(startOffset);
        if (ref2 instanceof GrDocMethodReference) {
            GrDocMethodReference methodReference = (GrDocMethodReference)ref2;
            GrDocMethodParams list = methodReference.getParameterList();
            for (GrDocMethodParameter parameter : list.getParameters()) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)parameter);
            }
            endOffset = methodReference.getTextRange().getEndOffset() + 1;
        }
        return endOffset;
    }
}

