/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

class ConvertIntegerToHexPredicate
implements PsiElementPredicate {
    ConvertIntegerToHexPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ConvertIntegerToHexPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrLiteral)) {
            return false;
        }
        GrLiteral expression = (GrLiteral)element;
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(PsiTypes.intType().equals((Object)type) || PsiTypes.longType().equals((Object)type) || type.equalsToText("java.lang.Integer") || type.equalsToText("java.lang.Long"))) {
            return false;
        }
        @NonNls String text = expression.getText();
        return !text.startsWith("0x") && !text.startsWith("0X");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToHexPredicate", "satisfiedBy"));
    }
}

