/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenEventHandler;
import org.jetbrains.idea.maven.buildtool.MavenLogEventHandler;
import org.jetbrains.idea.maven.buildtool.MessageEventUtilsKt;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u001a\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\b\b\u0001\u0010\u001f\u001a\u00020\tH\u0004J\u0012\u0010\u001d\u001a\u00020\u001c2\b\b\u0001\u0010\u001f\u001a\u00020\tH\u0004J\"\u0010 \u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\b\b\u0001\u0010\u001f\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0004J\u001a\u0010 \u001a\u00020\u001c2\b\b\u0001\u0010\u001f\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0004J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u001c2\b\b\u0001\u0010\f\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\u001cJ\u0016\u0010(\u001a\u00020\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u0016\u0010,\u001a\u00020\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*H\u0016J\"\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\t2\b\u00103\u001a\u0004\u0018\u00010%H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u00100\u001a\u000201H\u0002J\u001a\u00105\u001a\u00020\t2\u0006\u00100\u001a\u0002012\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\t2\u0006\u00100\u001a\u000201H\u0002J\u001a\u00107\u001a\u00020\u001c2\b\b\u0001\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:H\u0002J\u001c\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\t2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010%H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase;", "Lorg/jetbrains/idea/maven/buildtool/MavenEventHandler;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "title", "", "getTitle", "()Ljava/lang/String;", "message", "getMessage", "myTaskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lkotlin/collections/LinkedHashSet;", "progressListener", "Lcom/intellij/build/SyncViewManager;", "kotlin.jvm.PlatformType", "hasErrors", "", "createTaskId", "start", "", "startTask", "parentId", "taskName", "completeTask", "result", "Lcom/intellij/build/events/EventResult;", "addException", "e", "", "addError", "finish", "handleDownloadEvents", "downloadEvents", "", "Lorg/jetbrains/idea/maven/server/MavenArtifactEvent;", "handleConsoleEvents", "consoleEvents", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleEvent;", "printMessage", "level", "", "string", "throwable", "isSuppressed", "composeLine", "getPrefixByLevel", "doPrint", "text", "type", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase$Companion$OutputType;", "debugLog", "s", "exception", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenConsoles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenConsoles.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1869#2,2:215\n*S KotlinDebug\n*F\n+ 1 MavenConsoles.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase\n*L\n88#1:215,2\n*E\n"})
public abstract class MavenSyncConsoleBase
implements MavenEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @NotNull
    private final LinkedHashSet<Pair<ExternalSystemTaskId, String>> myStartedSet;
    private final SyncViewManager progressListener;
    private boolean hasErrors;
    @NotNull
    private static final String LINE_SEPARATOR;
    @NotNull
    private static final Map<Integer, String> LEVEL_TO_PREFIX;

    public MavenSyncConsoleBase(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myTaskId = this.createTaskId();
        this.myStartedSet = new LinkedHashSet();
        this.progressListener = (SyncViewManager)this.myProject.getService(SyncViewManager.class);
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected abstract String getTitle();

    @NotNull
    protected abstract String getMessage();

    @NotNull
    protected final ExternalSystemTaskId createTaskId() {
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"create(...)");
        return externalSystemTaskId;
    }

    public final void start() {
        String string = this.getTitle();
        String string2 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.myTaskId, string, string2, System.currentTimeMillis());
        descriptor2.setActivateToolWindowWhenFailed(true);
        descriptor2.setActivateToolWindowWhenAdded(false);
        this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, this.getMessage()));
    }

    protected final void startTask(@NotNull ExternalSystemTaskId parentId, @NlsSafe @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        MavenSyncConsoleBase.debugLog$default(this, "Maven task: start " + taskName, null, 2, null);
        if (this.myStartedSet.add((Pair<ExternalSystemTaskId, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
            this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new StartEventImpl((Object)taskName, (Object)parentId, System.currentTimeMillis(), taskName));
        }
    }

    protected final void startTask(@NlsSafe @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        this.startTask(this.myTaskId, taskName);
    }

    protected final void completeTask(@NotNull ExternalSystemTaskId parentId, @NlsSafe @NotNull String taskName, @NotNull EventResult result2) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.hasErrors = this.hasErrors || result2 instanceof FailureResultImpl;
        MavenSyncConsoleBase.debugLog$default(this, "Maven task: complete " + taskName + " with " + result2, null, 2, null);
        if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
            this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new FinishEventImpl((Object)taskName, (Object)parentId, System.currentTimeMillis(), taskName, result2));
        }
    }

    protected final void completeTask(@NlsSafe @NotNull String taskName, @NotNull EventResult result2) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.completeTask(this.myTaskId, taskName, result2);
    }

    @ApiStatus.Internal
    public final void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MavenLog.LOG.warn(e);
        this.hasErrors = true;
        this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)MessageEventUtilsKt.createMessageEvent(this.myProject, this.myTaskId, e));
    }

    public final void addError(@NlsSafe @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String group = SyncBundle.message("build.event.title.error", new Object[0]);
        this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new MessageEventImpl((Object)this.myTaskId, MessageEvent.Kind.ERROR, group, message, message));
    }

    public final void finish() {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        MavenSyncConsoleBase.debugLog$default(this, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask((ExternalSystemTaskId)it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
    }

    @Override
    public void handleDownloadEvents(@NotNull List<? extends MavenArtifactEvent> downloadEvents) {
        Intrinsics.checkNotNullParameter(downloadEvents, (String)"downloadEvents");
        MavenLogEventHandler.INSTANCE.handleDownloadEvents(downloadEvents);
    }

    @Override
    public void handleConsoleEvents(@NotNull List<? extends MavenServerConsoleEvent> consoleEvents) {
        Intrinsics.checkNotNullParameter(consoleEvents, (String)"consoleEvents");
        for (MavenServerConsoleEvent mavenServerConsoleEvent : consoleEvents) {
            int n = mavenServerConsoleEvent.getLevel();
            String string = mavenServerConsoleEvent.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            this.printMessage(n, string, mavenServerConsoleEvent.getThrowable());
        }
    }

    private final void printMessage(int level, String string, Throwable throwable) {
        if (this.isSuppressed(level)) {
            return;
        }
        Companion.OutputType type = Companion.OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type = Companion.OutputType.ERROR;
        }
        this.doPrint(this.composeLine(level, string), type);
        if (throwable != null) {
            String string2 = ExceptionUtil.getThrowableText((Throwable)throwable);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
            String throwableText = string2;
            if (Registry.Companion.is("maven.print.import.stacktraces") || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doPrint(LINE_SEPARATOR + this.composeLine(3, throwableText), type);
            } else {
                this.doPrint(LINE_SEPARATOR + this.composeLine(3, throwable.getMessage()), type);
            }
        }
    }

    private final boolean isSuppressed(int level) {
        return level < MavenProjectsManager.getInstance(this.myProject).getGeneralSettings().getOutputLevel().getLevel();
    }

    private final String composeLine(int level, String message) {
        Object[] objectArray = new Object[]{this.getPrefixByLevel(level), message};
        String string = MessageFormat.format("[{0}] {1}", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String getPrefixByLevel(int level) {
        return LEVEL_TO_PREFIX.get(level);
    }

    private final void doPrint(@NlsSafe String text, Companion.OutputType type) {
        boolean stdout;
        boolean bl = stdout = type == Companion.OutputType.NORMAL;
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        Object toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + "\n";
        this.progressListener.onEvent((Object)this.myTaskId, (BuildEvent)new OutputBuildEventImpl((Object)this.myTaskId, (String)toPrint, stdout));
    }

    private final void debugLog(String s, Throwable exception) {
        MavenLog.LOG.debug(s, exception);
    }

    static /* synthetic */ void debugLog$default(MavenSyncConsoleBase mavenSyncConsoleBase, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debugLog");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        mavenSyncConsoleBase.debugLog(string, throwable);
    }

    static {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        LINE_SEPARATOR = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)"DEBUG"), TuplesKt.to((Object)1, (Object)"INFO"), TuplesKt.to((Object)2, (Object)"WARNING"), TuplesKt.to((Object)3, (Object)"ERROR"), TuplesKt.to((Object)4, (Object)"FATAL_ERROR")};
        LEVEL_TO_PREFIX = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase$Companion;", "", "<init>", "()V", "LINE_SEPARATOR", "", "LEVEL_TO_PREFIX", "", "", "OutputType", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase$Companion$OutputType;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "ERROR", "intellij.maven"})
        private static final class OutputType
        extends Enum<OutputType> {
            public static final /* enum */ OutputType NORMAL = new OutputType();
            public static final /* enum */ OutputType ERROR = new OutputType();
            private static final /* synthetic */ OutputType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static OutputType[] values() {
                return (OutputType[])$VALUES.clone();
            }

            public static OutputType valueOf(String value) {
                return Enum.valueOf(OutputType.class, value);
            }

            @NotNull
            public static EnumEntries<OutputType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = outputTypeArray = new OutputType[]{OutputType.NORMAL, OutputType.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

