/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Stateful;
import org.graalvm.visualvm.core.model.Model;
import org.graalvm.visualvm.core.model.ModelFactory;

final class ModelCache<D extends DataSource, M extends Model> {
    private static final Logger LOGGER = Logger.getLogger(ModelFactory.class.getName());
    final ModelReference<M> NULL_MODEL;
    private final Map<DataSourceKey<D>, ModelReference<M>> modelCache = Collections.synchronizedMap(new HashMap());

    ModelCache() {
        this.NULL_MODEL = new ModelReference(null, 0);
    }

    Reference<M> get(DataSourceKey<D> key) {
        ModelReference<M> valueRef = this.modelCache.get(key);
        if (valueRef != null && ((ModelReference)valueRef).modCount < key.modCount) {
            Reference removed = this.modelCache.remove(key);
            LOGGER.finer("Invalid mod count " + key + " " + (removed != null ? "removed" : "not removed"));
            return null;
        }
        return valueRef;
    }

    Reference<M> put(DataSourceKey<D> key, M value) {
        DataSource ds = (DataSource)key.weakReference.get();
        if (ds instanceof Stateful && value != null) {
            ds.addPropertyChangeListener("prop_state", new StateListener(key));
            LOGGER.finer("Registered listener for " + key + " val " + value.getClass());
        }
        ModelReference<Object> ref = value == null ? this.NULL_MODEL : new ModelReference(value, key.modCount);
        return this.modelCache.put(key, ref);
    }

    void clear() {
        this.modelCache.clear();
    }

    private class StateListener
    implements PropertyChangeListener {
        DataSourceKey<D> key;

        StateListener(DataSourceKey<D> k) {
            this.key = k;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newState = (Integer)evt.getNewValue();
            if (newState == 1) {
                DataSource ds = (DataSource)this.key.weakReference.get();
                if (ds != null) {
                    ds.removePropertyChangeListener("prop_state", this);
                }
                if (ds == null || this.key.modCount < ((Stateful)((Object)ds)).getModCount()) {
                    Reference removed = (Reference)ModelCache.this.modelCache.remove(this.key);
                    LOGGER.finer(this.key + " " + (removed != null ? "removed" : "not removed"));
                } else {
                    LOGGER.finer(this.key + " newer model found");
                }
            }
        }
    }

    private static class ModelReference<T>
    extends SoftReference<T> {
        private int modCount;

        private ModelReference(T ref, int count) {
            super(ref);
            this.modCount = count;
        }
    }

    static class DataSourceKey<D extends DataSource> {
        Reference<D> weakReference;
        int modCount;

        DataSourceKey(D ds) {
            this.weakReference = new WeakReference<D>(ds);
            if (ds instanceof Stateful) {
                this.modCount = ((Stateful)ds).getModCount();
            }
        }

        public int hashCode() {
            DataSource ds = (DataSource)this.weakReference.get();
            if (ds != null) {
                return ds.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof DataSourceKey) {
                DataSource ds = (DataSource)this.weakReference.get();
                DataSource otherDs = (DataSource)((DataSourceKey)obj).weakReference.get();
                return ds != null && ds == otherDs;
            }
            throw new IllegalArgumentException(obj.getClass().getName());
        }

        public String toString() {
            DataSource ds = (DataSource)this.weakReference.get();
            return "DataSourceKey for " + System.identityHashCode(this) + " for " + ds == null ? "NULL" : ds.toString();
        }
    }
}

