/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.Iterator;
import java.util.List;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class TextDecorationProperty
extends ListProperty {
    public TextDecorationProperty(ListProperty listProp) throws PropertyException {
        List lst = listProp.getList();
        boolean none = false;
        boolean under = false;
        boolean over = false;
        boolean through = false;
        boolean blink = false;
        Iterator i = lst.iterator();
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            switch (prop.getEnum()) {
                case 95: {
                    if (under | over | through | blink) {
                        throw new PropertyException("Invalid combination of values");
                    }
                    none = true;
                    break;
                }
                case 92: 
                case 153: {
                    if (none) {
                        throw new PropertyException("'none' specified, no additional values allowed");
                    }
                    if (under) {
                        throw new PropertyException("Invalid combination of values");
                    }
                    under = true;
                    break;
                }
                case 91: 
                case 103: {
                    if (none) {
                        throw new PropertyException("'none' specified, no additional values allowed");
                    }
                    if (over) {
                        throw new PropertyException("Invalid combination of values");
                    }
                    over = true;
                    break;
                }
                case 77: 
                case 90: {
                    if (none) {
                        throw new PropertyException("'none' specified, no additional values allowed");
                    }
                    if (through) {
                        throw new PropertyException("Invalid combination of values");
                    }
                    through = true;
                    break;
                }
                case 17: 
                case 86: {
                    if (none) {
                        throw new PropertyException("'none' specified, no additional values allowed");
                    }
                    if (blink) {
                        throw new PropertyException("Invalid combination of values");
                    }
                    blink = true;
                    break;
                }
                default: {
                    throw new PropertyException("Invalid value specified: " + prop);
                }
            }
            this.addProperty(prop);
        }
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof TextDecorationProperty) {
                return p;
            }
            if (p instanceof ListProperty) {
                ListProperty lst = (ListProperty)p;
                lst = this.checkEnums(lst);
                return new TextDecorationProperty((ListProperty)p);
            }
            if (p instanceof EnumProperty) {
                ListProperty lst = new ListProperty(p);
                return new TextDecorationProperty(lst);
            }
            throw new PropertyException("Cannot convert anything other than a list property, got a " + p.getClass().getName());
        }

        private ListProperty checkEnums(ListProperty lst) throws PropertyException {
            List l = lst.getList();
            for (int i = 0; i < l.size(); ++i) {
                Property prop = (Property)l.get(i);
                if (prop instanceof EnumProperty) continue;
                if (prop instanceof NCnameProperty) {
                    Property prop_enum = this.checkEnumValues(((NCnameProperty)prop).getString());
                    if (prop_enum == null) {
                        throw new PropertyException("Illegal enum value: " + prop.getString());
                    }
                    l.set(i, prop_enum);
                    continue;
                }
                throw new PropertyException("Invalid content for text-decoration property: " + prop);
            }
            return lst;
        }
    }
}

