/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.Recurrence;
import tr.view.action.recurrence.modify.Modification;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelChoice1;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelChoiceN;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelModAction1;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelModAction2;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelModProject1;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelModRecur1;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelModRecur2;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizardPanelRemRecur1;

public final class ModifyRecurrenceWizardIterator
implements WizardDescriptor.Iterator,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("tr.view.action");
    private final Action action;
    private final Recurrence recurrenceOriginal;
    private final Recurrence recurrenceModSubsequent;
    private final Recurrence recurrenceModRegular;
    private final Recurrence recurrenceModAction;
    private final Recurrence recurrenceModProject;
    private int index;
    private WizardDescriptor.Panel[] currentPanels;
    private WizardDescriptor.Panel[] modifyChoicePanels;
    private WizardDescriptor.Panel[] modifyRecurPanels;
    private WizardDescriptor.Panel[] modifyActionPanels;
    private WizardDescriptor.Panel[] modifyProjectPanels;
    private WizardDescriptor.Panel[] removeRecurPanels;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ModifyRecurrenceWizardIterator(Action action, Recurrence recurrence) {
        this.action = action;
        this.recurrenceOriginal = this.copy(recurrence);
        this.recurrenceModSubsequent = this.copy(recurrence);
        this.recurrenceModSubsequent.setBasis(Recurrence.Basis.DONE_DATE);
        this.recurrenceModRegular = this.copy(recurrence);
        this.recurrenceModRegular.setBasis(Recurrence.Basis.START_DATE);
        this.recurrenceModAction = this.copy(recurrence);
        this.recurrenceModProject = this.copy(recurrence);
        this.initPanels();
    }

    private void putProperties(WizardDescriptor.Panel wdp, int index, String[] steps) {
        JComponent jc = (JComponent)wdp.getComponent();
        jc.addPropertyChangeListener(this);
        jc.putClientProperty("WizardPanel_contentSelectedIndex", index);
        jc.putClientProperty("WizardPanel_contentData", steps);
        jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
    }

    private void initPanels() {
        ModifyRecurrenceWizardPanelChoice1 p1 = new ModifyRecurrenceWizardPanelChoice1(this.recurrenceOriginal);
        ModifyRecurrenceWizardPanelChoiceN pN = new ModifyRecurrenceWizardPanelChoiceN();
        String[] stepsInitial = new String[]{p1.getComponent().getName(), pN.getComponent().getName()};
        this.putProperties(p1, 0, stepsInitial);
        this.putProperties(pN, 1, stepsInitial);
        this.modifyChoicePanels = new WizardDescriptor.Panel[]{p1, pN};
        ModifyRecurrenceWizardPanelModRecur1 pR1 = new ModifyRecurrenceWizardPanelModRecur1(this.recurrenceOriginal.getBasis());
        ModifyRecurrenceWizardPanelModRecur2 pR2 = new ModifyRecurrenceWizardPanelModRecur2(this.recurrenceModSubsequent, this.recurrenceModRegular, this.action);
        String[] stepsModRec = new String[]{p1.getComponent().getName(), pR1.getComponent().getName(), pR2.getComponent().getName()};
        this.putProperties(pR1, 1, stepsModRec);
        this.putProperties(pR2, 2, stepsModRec);
        this.modifyRecurPanels = new WizardDescriptor.Panel[]{p1, pR1, pR2};
        ModifyRecurrenceWizardPanelRemRecur1 pD1 = new ModifyRecurrenceWizardPanelRemRecur1();
        String[] stepsRemoval = new String[]{p1.getComponent().getName(), pD1.getComponent().getName()};
        this.putProperties(pD1, 1, stepsRemoval);
        this.removeRecurPanels = new WizardDescriptor.Panel[]{p1, pD1};
        ModifyRecurrenceWizardPanelModAction1 pA1 = new ModifyRecurrenceWizardPanelModAction1(this.recurrenceModAction);
        ModifyRecurrenceWizardPanelModAction2 pA2 = new ModifyRecurrenceWizardPanelModAction2(this.recurrenceModAction, this.action);
        String[] stepsModifyAction = new String[]{p1.getComponent().getName(), pA1.getComponent().getName(), pA2.getComponent().getName()};
        this.putProperties(pA1, 1, stepsModifyAction);
        this.putProperties(pA2, 2, stepsModifyAction);
        this.modifyActionPanels = new WizardDescriptor.Panel[]{p1, pA1, pA2};
        ModifyRecurrenceWizardPanelModProject1 pP1 = new ModifyRecurrenceWizardPanelModProject1(this.recurrenceModProject, this.action);
        String[] stepsModifyProject = new String[]{p1.getComponent().getName(), pP1.getComponent().getName()};
        this.putProperties(pP1, 1, stepsModifyProject);
        this.modifyProjectPanels = new WizardDescriptor.Panel[]{p1, pP1};
        this.currentPanels = this.modifyChoicePanels;
    }

    private WizardDescriptor.Panel[] getPanels() {
        return this.currentPanels;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". " + NbBundle.getMessage(ModifyRecurrenceWizardIterator.class, (String)"of") + " " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("modification")) {
            Modification modification = (Modification)((Object)evt.getNewValue());
            switch (modification) {
                case CHANGE_RECURRENCE: {
                    this.currentPanels = this.modifyRecurPanels;
                    break;
                }
                case REMOVE_RECURRENCE: {
                    this.currentPanels = this.removeRecurPanels;
                    break;
                }
                case CHANGE_ACTION: {
                    this.currentPanels = this.modifyActionPanels;
                    break;
                }
                case CHANGE_PROJECT: {
                    this.currentPanels = this.modifyProjectPanels;
                    break;
                }
                default: {
                    this.currentPanels = this.modifyChoicePanels;
                }
            }
            this.fireChangeEvent();
        }
    }

    private Recurrence copy(Recurrence r) {
        Recurrence copy = new Recurrence(r.getID());
        copy.setProject(r.getProject());
        copy.setDescription(r.getDescription());
        copy.setTopic(r.getTopic());
        copy.setContext(r.getContext());
        copy.setTime(r.getTime());
        copy.setEnergy(r.getEnergy());
        copy.setPriority(r.getPriority());
        copy.setScheduleHours(r.getScheduleHours());
        copy.setScheduleMins(r.getScheduleMins());
        copy.setDurationHours(r.getDurationHours());
        copy.setDurationMins(r.getDurationMins());
        copy.setBasis(r.getBasis());
        copy.setStartDate(r.getStartDate());
        copy.setPeriod(r.getPeriod().clone());
        copy.setFrequency(r.getFrequency());
        copy.setAdvanceNbr(r.getAdvanceNbr());
        copy.setEndNbr(r.getEndNbr());
        copy.setEndDate(r.getEndDate());
        copy.setGenToDate(r.getGenToDate());
        copy.setSuccess(r.getSuccess());
        copy.setNotes(r.getNotes());
        return copy;
    }
}

