/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMultiLock {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<DistributedLock> locks;
    private volatile boolean isReleased = false;

    public DistributedMultiLock(List<DistributedLock> locks) {
        this.locks = locks;
    }

    public void waitUntilAcquired() {
        if (this.isReleased) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Released lock can't be waited upon");
        }
        for (DistributedLock lock : this.locks) {
            log.debug("DistributedMultiLock.waitUntilAcquired. About to wait on lock {}", (Object)lock);
            lock.waitUntilAcquired();
            log.debug("DistributedMultiLock.waitUntilAcquired. Acquired lock {}", (Object)lock);
        }
    }

    public void release() {
        this.isReleased = true;
        for (DistributedLock lock : this.locks) {
            lock.release();
        }
    }

    public boolean isAcquired() {
        if (this.isReleased) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Released lock can't be tested");
        }
        for (DistributedLock lock : this.locks) {
            if (lock.isAcquired()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public int getCountInternalLocks() {
        return this.locks.size();
    }
}

