/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.LogicalOperatorName;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.geoapi.filter.TemporalOperatorName;

public abstract class Visitor<R, A> {
    private final Map<Enum<?>, BiConsumer<Filter<R>, A>> filters;
    private final Map<String, BiConsumer<Expression<R, ?>, A>> expressions;

    protected Visitor() {
        this.filters = new HashMap();
        this.expressions = new HashMap();
    }

    protected Visitor(boolean bl, boolean bl2) {
        this.filters = bl ? new HashMap() : Collections.emptyMap();
        this.expressions = bl2 ? new HashMap() : Collections.emptyMap();
    }

    protected Visitor(Visitor<R, A> visitor, boolean bl, boolean bl2) {
        this.filters = bl ? new HashMap(visitor.filters) : visitor.filters;
        this.expressions = bl2 ? new HashMap(visitor.expressions) : visitor.expressions;
    }

    protected final BiConsumer<Filter<R>, A> getFilterHandler(Enum<?> enum_) {
        return this.filters.get(enum_);
    }

    protected final BiConsumer<Expression<R, ?>, A> getExpressionHandler(String string) {
        return this.expressions.get(string);
    }

    protected final void setFilterHandler(Enum<?> enum_, BiConsumer<Filter<R>, A> biConsumer) {
        this.filters.put(enum_, biConsumer);
    }

    private void setFamilyHandlers(Enum<?> enum_, BiConsumer<Filter<R>, A> biConsumer) {
        for (Enum enum_2 : (Enum[])enum_.getClass().getEnumConstants()) {
            this.filters.put(enum_2, biConsumer);
            if (enum_2 == enum_) break;
        }
    }

    protected final void setExpressionHandler(String string, BiConsumer<Expression<R, ?>, A> biConsumer) {
        this.expressions.put(string, biConsumer);
    }

    private void setExpressionHandlers(BiConsumer<Expression<R, ?>, A> biConsumer, String ... stringArray) {
        for (String string : stringArray) {
            this.expressions.put(string, biConsumer);
        }
    }

    protected final void setLogicalHandlers(BiConsumer<Filter<R>, A> biConsumer) {
        this.setFamilyHandlers(LogicalOperatorName.NOT, biConsumer);
    }

    protected final void setNullAndNilHandlers(BiConsumer<Filter<R>, A> biConsumer) {
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_NULL, biConsumer);
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_NIL, biConsumer);
    }

    protected final void setBinaryComparisonHandlers(BiConsumer<Filter<R>, A> biConsumer) {
        this.setFamilyHandlers(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, biConsumer);
    }

    protected final void setBinaryTemporalHandlers(BiConsumer<Filter<R>, A> biConsumer) {
        this.setFamilyHandlers(TemporalOperatorName.ANY_INTERACTS, biConsumer);
    }

    protected final void setSpatialHandlers(BiConsumer<Filter<R>, A> biConsumer) {
        this.setFamilyHandlers(SpatialOperatorName.OVERLAPS, biConsumer);
        this.setFamilyHandlers(DistanceOperatorName.WITHIN, biConsumer);
    }

    protected final void setMathHandlers(BiConsumer<Expression<R, ?>, A> biConsumer) {
        this.setExpressionHandlers(biConsumer, "Add", "Subtract", "Multiply", "Divide");
    }

    protected final void removeFilterHandlers(Collection<? extends Enum<?>> collection) {
        this.filters.keySet().removeAll(collection);
    }

    public void visit(Filter<R> filter, A a) {
        Enum<?> enum_ = filter != null ? filter.getOperatorType() : null;
        BiConsumer<Filter<R>, A> biConsumer = this.filters.get(enum_);
        if (biConsumer != null) {
            biConsumer.accept(filter, a);
        } else {
            this.typeNotFound(enum_, filter, a);
        }
    }

    public void visit(Expression<R, ?> expression, A a) {
        String string = expression != null ? expression.getFunctionName().tip().toString() : null;
        BiConsumer<Expression<R, ?>, A> biConsumer = this.expressions.get(string);
        if (biConsumer != null) {
            biConsumer.accept(expression, a);
        } else {
            this.typeNotFound(string, expression, a);
        }
    }

    protected void typeNotFound(Enum<?> enum_, Filter<R> filter, A a) {
        throw new UnsupportedOperationException(Resources.format((short)77, 0, enum_));
    }

    protected void typeNotFound(String string, Expression<R, ?> expression, A a) {
        throw new UnsupportedOperationException(Resources.format((short)77, 1, string));
    }
}

