/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.util.CodeList;

public final class CodeLists
implements CodeList.Filter {
    public static final String RESOURCES = "org.opengis.metadata.CodeLists";
    private final String codename;
    private final boolean canCreate;

    private CodeLists(String string, boolean bl) {
        this.codename = string;
        this.canCreate = bl;
    }

    @Override
    public String codename() {
        return this.canCreate ? this.codename : null;
    }

    @Override
    public boolean accept(CodeList<?> codeList) {
        for (String string : codeList.names()) {
            if (!CodeLists.accept(string, this.codename)) continue;
            return true;
        }
        return false;
    }

    private static boolean accept(String string, String string2) {
        return CharSequences.equalsFiltered(string, string2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    public static <T extends CodeList<T>> T forName(Class<T> clazz, String string, boolean bl) {
        if ((string = CharSequences.trimWhitespaces(string)) == null || string.isEmpty()) {
            return null;
        }
        return CodeList.valueOf(clazz, new CodeLists(string, bl));
    }

    public static <T extends Enum<T>> T forName(Class<T> clazz, String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                if (enumArray == null) {
                    throw illegalArgumentException;
                }
                for (Enum enum_ : enumArray) {
                    if (!CodeLists.accept(enum_.name(), string)) continue;
                    return (T)((Enum)clazz.cast(enum_));
                }
            }
        }
        return null;
    }

    public static <T extends CodeList<?>> T[] values(Class<T> clazz) {
        Object object;
        try {
            object = clazz.getMethod("values", null).invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            object = Array.newInstance(clazz, 0);
        }
        return (CodeList[])object;
    }
}

