/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.sis.geometry.DirectPosition1D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Line;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Plane;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.builder.Linearizer;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LinearTransformBuilder
extends TransformBuilder {
    private final int[] gridSize;
    private double[][] sources;
    private double[][] targets;
    final int gridLength;
    private int numPoints;
    private List<ProjectedTransformTry> linearizers;
    private transient ProjectedTransformTry appliedLinearizer;
    private transient LinearTransform transform;
    private transient double[] correlations;

    private LinearTransformBuilder(LinearTransformBuilder linearTransformBuilder) {
        this.gridSize = linearTransformBuilder.gridSize;
        this.sources = linearTransformBuilder.sources;
        this.gridLength = linearTransformBuilder.gridLength;
        this.numPoints = linearTransformBuilder.numPoints;
    }

    public LinearTransformBuilder() {
        this.gridSize = null;
        this.gridLength = 0;
    }

    public LinearTransformBuilder(int ... nArray) {
        ArgumentChecks.ensureNonEmpty("gridSize", nArray, 1, Integer.MAX_VALUE, false);
        if (nArray.length == 0) {
            this.gridSize = null;
            this.gridLength = 0;
        } else {
            nArray = (int[])nArray.clone();
            long l = 1L;
            for (int n : nArray) {
                ArgumentChecks.ensureStrictlyPositive("gridSize", n);
                l = Math.multiplyExact(l, (long)n);
            }
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Errors.format((short)166, "\u220fgridSize", 1, Integer.MAX_VALUE, l));
            }
            this.gridSize = nArray;
            this.gridLength = (int)l;
        }
    }

    public static LinearTransform approximate(MathTransform mathTransform, Envelope envelope) throws FactoryException {
        ArgumentChecks.ensureNonNull("gridToCRS", mathTransform);
        ArgumentChecks.ensureNonNull("domain", envelope);
        try {
            return (LinearTransform)Linearizer.approximate(mathTransform, envelope);
        }
        catch (TransformException transformException) {
            throw new LocalizationGridException(transformException);
        }
    }

    final int gridSize(int n) {
        return this.gridSize[n];
    }

    private void allocate(int n) {
        for (double[] dArray : this.targets = new double[n][this.gridLength]) {
            Arrays.fill(dArray, Double.NaN);
        }
    }

    private static void resize(double[][] dArray, int n) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ArraysExt.resize(dArray[i], n);
        }
    }

    private int search(int[] nArray) {
        assert (this.gridSize == null);
        int n = this.numPoints;
        block0: while (--n >= 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if ((double)nArray[i] != this.sources[i][n]) continue block0;
            }
            return n;
        }
        return -1;
    }

    private int flatIndex(int[] nArray) {
        assert (this.sources == null);
        int n = 0;
        int n2 = this.gridSize.length;
        while (n2 != 0) {
            int n3 = this.gridSize[--n2];
            int n4 = nArray[n2];
            if (n4 < 0 || n4 >= n3) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, n3 - 1, n4));
            }
            n = n * n3 + n4;
        }
        return n;
    }

    private int flatIndex(DirectPosition directPosition) {
        assert (this.sources == null);
        int n = 0;
        int n2 = this.gridSize.length;
        while (n2 != 0) {
            int n3 = this.gridSize[--n2];
            double d = directPosition.getOrdinate(n2);
            int n4 = (int)d;
            if ((double)n4 != d) {
                throw new IllegalArgumentException(Errors.format((short)171, d));
            }
            if (n4 < 0 || n4 >= n3) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, n3 - 1, n4));
            }
            n = n * n3 + n4;
        }
        return n;
    }

    final boolean isModifiable() {
        return this.transform == null;
    }

    private void ensureModifiable() throws IllegalStateException {
        if (this.transform != null) {
            throw new IllegalStateException(Errors.format((short)153, LinearTransformBuilder.class));
        }
    }

    private void verifySourceDimension(int n) throws MismatchedDimensionException {
        int n2;
        if (this.gridSize != null) {
            n2 = this.gridSize.length;
        } else if (this.sources != null) {
            n2 = this.sources.length;
        } else {
            return;
        }
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((short)81, "source", n2, n));
        }
    }

    private MismatchedDimensionException mismatchedDimension(String string, int n, int n2) {
        return new MismatchedDimensionException(Errors.format((short)81, Strings.toIndexed(string, this.numPoints), n, n2));
    }

    private static String noData() {
        return Resources.format((short)81);
    }

    final int getGridDimensions() {
        return this.gridSize != null ? this.gridSize.length : -1;
    }

    public int getSourceDimensions() {
        if (this.gridSize != null) {
            return this.gridSize.length;
        }
        if (this.sources != null) {
            return this.sources.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public int getTargetDimensions() {
        if (this.targets != null) {
            return this.targets.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public Envelope getSourceEnvelope() {
        if (this.gridSize != null) {
            int n = this.gridSize.length;
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(n);
            for (int i = 0; i < n; ++i) {
                generalEnvelope.setRange(i, 0.0, this.gridSize[i] - 1);
            }
            return generalEnvelope;
        }
        return LinearTransformBuilder.envelope(this.sources, this.numPoints);
    }

    public Envelope getTargetEnvelope() {
        return LinearTransformBuilder.envelope(this.targets, this.gridLength != 0 ? this.gridLength : this.numPoints);
    }

    private static Envelope envelope(double[][] dArray, int n) {
        if (dArray == null) {
            throw new IllegalStateException(LinearTransformBuilder.noData());
        }
        int n2 = dArray.length;
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n2);
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = dArray[i];
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < n; ++j) {
                double d3 = dArray2[j];
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            if (d > d2) {
                d2 = Double.NaN;
                d = Double.NaN;
            }
            generalEnvelope.setRange(i, d, d2);
        }
        return generalEnvelope;
    }

    private static DirectPosition position(Position position) {
        return position != null ? position.getDirectPosition() : null;
    }

    public void setControlPoints(MathTransform mathTransform) throws TransformException {
        ArgumentChecks.ensureNonNull("gridToCRS", mathTransform);
        if (this.gridSize == null) {
            throw new IllegalStateException(Resources.format((short)99));
        }
        int n = mathTransform.getSourceDimensions();
        if (n != this.gridSize.length) {
            throw new MismatchedDimensionException(Errors.format((short)190, "gridToCRS", 0, this.gridSize.length, n));
        }
        int n2 = mathTransform.getTargetDimensions();
        this.allocate(n2);
        int n3 = this.gridSize[0];
        int n4 = n3 * n2;
        double[] dArray = new double[Math.max(n, n2) * n3];
        double[] dArray2 = new double[n];
        block0: for (int i = 0; i < this.gridLength; i += n3) {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                dArray2[0] = n5;
                System.arraycopy(dArray2, 0, dArray, n5 * n, n);
            }
            mathTransform.transform(dArray, 0, dArray, 0, n3);
            for (n5 = 0; n5 < n2; ++n5) {
                double[] dArray3 = this.targets[n5];
                int n6 = i;
                for (int j = n5; j < n4; j += n2) {
                    dArray3[n6++] = dArray[j];
                }
            }
            for (n5 = 1; n5 < this.gridSize.length; ++n5) {
                int n7 = n5;
                double d = dArray2[n7];
                dArray2[n7] = d + 1.0;
                if (d < (double)this.gridSize[n5]) continue block0;
                dArray2[n5] = 0.0;
            }
        }
    }

    public void setControlPoints(Map<? extends Position, ? extends Position> map) throws MismatchedDimensionException {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("sourceToTarget", map);
        this.sources = null;
        this.targets = null;
        this.numPoints = 0;
        int n = 0;
        int n2 = 0;
        for (Map.Entry<? extends Position, ? extends Position> entry : map.entrySet()) {
            int n3;
            int n4;
            int n5;
            DirectPosition directPosition;
            DirectPosition directPosition2 = LinearTransformBuilder.position(entry.getKey());
            if (directPosition2 == null || (directPosition = LinearTransformBuilder.position(entry.getValue())) == null) continue;
            if (this.targets == null) {
                n2 = directPosition.getDimension();
                if (n2 <= 0) {
                    throw this.mismatchedDimension("target", 2, n2);
                }
                if (this.gridSize == null) {
                    n = directPosition2.getDimension();
                    if (n <= 0) {
                        throw this.mismatchedDimension("source", 2, n);
                    }
                    n5 = map.size();
                    this.sources = new double[n][n5];
                    this.targets = new double[n2][n5];
                } else {
                    n = this.gridSize.length;
                    this.allocate(n2);
                }
            }
            if ((n5 = directPosition2.getDimension()) != n) {
                throw this.mismatchedDimension("source", n, n5);
            }
            n5 = directPosition.getDimension();
            if (n5 != n2) {
                throw this.mismatchedDimension("target", n2, n5);
            }
            boolean bl = true;
            if (this.gridSize != null) {
                n4 = this.flatIndex(directPosition2);
            } else {
                n4 = this.numPoints;
                for (n3 = 0; n3 < n; ++n3) {
                    double d = directPosition2.getOrdinate(n3);
                    this.sources[n3][n4] = d;
                    bl &= Double.isFinite(d);
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                double d = directPosition.getOrdinate(n3);
                this.targets[n3][n4] = d;
                bl &= Double.isFinite(d);
            }
            if (bl) {
                ++this.numPoints;
                continue;
            }
            this.targets[0][n4] = Double.NaN;
            throw new IllegalArgumentException(Errors.format((short)185, directPosition2, directPosition));
        }
    }

    public Map<DirectPosition, DirectPosition> getControlPoints() {
        return this.gridSize != null ? new ControlPoints() : new Ungridded();
    }

    public void setControlPoint(int[] nArray, double[] dArray) {
        int n;
        int n2;
        int n3;
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("source", nArray);
        ArgumentChecks.ensureNonNull("target", dArray);
        this.verifySourceDimension(nArray.length);
        int n4 = dArray.length;
        if (this.targets != null && n4 != this.targets.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, "target", this.targets.length, n4));
        }
        if (this.gridSize != null) {
            n3 = this.flatIndex(nArray);
            if (this.targets == null) {
                this.allocate(n4);
            }
            if (Double.isNaN(this.targets[0][n3])) {
                ++this.numPoints;
            }
        } else {
            n2 = nArray.length;
            if (this.targets == null) {
                this.targets = new double[n4][20];
                this.sources = new double[n2][20];
            }
            if ((n3 = this.search(nArray)) < 0) {
                n3 = this.numPoints++;
                if (this.numPoints >= this.targets[0].length) {
                    n = Math.multiplyExact(this.numPoints, 2);
                    LinearTransformBuilder.resize(this.sources, n);
                    LinearTransformBuilder.resize(this.targets, n);
                }
            }
            for (n = 0; n < n2; ++n) {
                this.sources[n][n3] = nArray[n];
            }
        }
        n2 = 1;
        for (n = 0; n < n4; ++n) {
            double d = dArray[n];
            this.targets[n][n3] = d;
            n2 &= Double.isFinite(d);
        }
        if (n2 == 0) {
            --this.numPoints;
            for (n = 0; n < n4; ++n) {
                this.targets[n][n3] = Double.NaN;
            }
            throw new IllegalArgumentException(Errors.format((short)185, nArray, new DirectPositionView.Double(dArray)));
        }
    }

    public double[] getControlPoint(int[] nArray) {
        int n;
        ArgumentChecks.ensureNonNull("source", nArray);
        this.verifySourceDimension(nArray.length);
        if (this.targets == null) {
            return null;
        }
        if (this.gridSize != null) {
            n = this.flatIndex(nArray);
        } else {
            n = this.search(nArray);
            if (n < 0) {
                return null;
            }
        }
        double[] dArray = new double[this.targets.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.targets[i][n];
            if (!Double.isNaN(dArray[i])) continue;
            return null;
        }
        return dArray;
    }

    final void setControlPoints(Vector[] vectorArray) {
        assert (this.gridSize != null);
        int n = vectorArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            Vector vector = vectorArray[i];
            ArgumentChecks.ensureNonNullElement("coordinates", i, vector);
            int n2 = vector.size();
            if (n2 == this.gridLength && (n2 = (dArrayArray[i] = vector.doubleValues()).length) == this.gridLength) continue;
            throw new IllegalArgumentException(Errors.format((short)133, this.gridLength, n2));
        }
        this.targets = dArrayArray;
        this.numPoints = this.gridLength;
    }

    final void getControlRow(int[] nArray, double[] dArray) {
        assert (this.gridSize != null);
        int n = this.flatIndex(nArray);
        int n2 = n + this.gridSize[0];
        int n3 = this.targets.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = i;
            double[] dArray2 = this.targets[i];
            for (int j = n; j < n2; ++j) {
                dArray[n4] = dArray2[j];
                n4 += n3;
            }
        }
    }

    final Vector getTransect(int n, int[] nArray, int n2) {
        int n3 = this.flatIndex(nArray);
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            n4 *= this.gridSize[i];
        }
        return Vector.create(this.targets[n]).subSampling(n3, n4, this.gridSize[n2] - nArray[n2]);
    }

    final NumberRange<Double> resolveWraparoundAxis(int n, int n2, double d) {
        double d2;
        double d3;
        int n3;
        double[] dArray = this.targets[n];
        int n4 = 1;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 *= this.gridSize[n3];
        }
        n3 = n4 * this.gridSize[n2];
        double d4 = d / 2.0;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double d7 = Double.POSITIVE_INFINITY;
        double d8 = Double.NEGATIVE_INFINITY;
        double d9 = dArray[0];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < this.gridLength; j += n3) {
                int n5 = j + n3;
                for (int k = i + j; k < n5; k += n4) {
                    d3 = dArray[k];
                    if (d3 < d5) {
                        d5 = d3;
                    }
                    if (d3 > d6) {
                        d6 = d3;
                    }
                    if (Math.abs(d2 = d3 - d9) > d4) {
                        d2 = Math.rint(d2 / d) * d;
                        dArray[k] = d3 -= d2;
                    }
                    d9 = d3;
                    if (d3 < d7) {
                        d7 = d3;
                    }
                    if (!(d3 > d8)) continue;
                    d8 = d3;
                }
                d9 = dArray[i];
            }
        }
        double d10 = 0.0;
        if (d6 - d5 > d) {
            d5 = -d;
            d6 = d;
        }
        double d11 = d5 - d7;
        d3 = d6 - d8;
        if (d11 != 0.0 || d3 != 0.0) {
            d2 = 0.0;
            double d12 = Math.floor(Math.min(d11, d3) / d);
            double d13 = Math.ceil(Math.max(d11, d3) / d);
            for (double d14 = d12; d14 <= d13; d14 += 1.0) {
                double d15 = d14 * d;
                double d16 = Math.min(d6, d8 + d15) - Math.max(d5, d7 + d15);
                if (!(d16 > d2)) continue;
                d2 = d16;
                d10 = d15;
            }
            if (d10 != 0.0) {
                int n6 = 0;
                while (n6 < dArray.length) {
                    int n7 = n6++;
                    dArray[n7] = dArray[n7] + d10;
                }
            }
        }
        return NumberRange.create(d7 + d10, true, d8 + d10, true);
    }

    final Vector[] sources() {
        if (this.sources != null) {
            Vector[] vectorArray = new Vector[this.sources.length];
            for (int i = 0; i < vectorArray.length; ++i) {
                vectorArray[i] = this.vector(this.sources[i]);
            }
            return vectorArray;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public void addLinearizers(Map<String, MathTransform> map, int ... nArray) {
        ArgumentChecks.ensureNonNull("projections", map);
        this.addLinearizers(map, false, nArray);
    }

    final void addLinearizers(Map<String, MathTransform> map, boolean bl, int[] nArray) {
        this.ensureModifiable();
        int n = this.getTargetDimensions();
        if (nArray == null || nArray.length == 0) {
            nArray = ArraysExt.range(0, n);
        } else {
            long l = 0L;
            for (int n2 : nArray = (int[])nArray.clone()) {
                ArgumentChecks.ensureValidIndex(n, n2);
                if (l != (l |= Numerics.bitmask(n2))) continue;
                throw new IllegalArgumentException(Errors.format((short)187, n2));
            }
        }
        if (this.linearizers == null) {
            this.linearizers = new ArrayList<ProjectedTransformTry>(map.size());
        }
        for (Map.Entry<String, MathTransform> entry : map.entrySet()) {
            this.linearizers.add(new ProjectedTransformTry(entry.getKey(), entry.getValue(), nArray, n, bl));
        }
    }

    final void setLinearizers(LinearTransformBuilder linearTransformBuilder) {
        if (linearTransformBuilder.linearizers != null) {
            this.linearizers = new ArrayList<ProjectedTransformTry>(linearTransformBuilder.linearizers);
            this.linearizers.replaceAll(ProjectedTransformTry::new);
        }
    }

    @Override
    public LinearTransform create(MathTransformFactory mathTransformFactory) throws FactoryException {
        if (this.transform == null) {
            MatrixSIS matrixSIS;
            if (this.linearizers == null || this.linearizers.isEmpty()) {
                matrixSIS = this.fit();
            } else {
                matrixSIS = null;
                double d = 0.0;
                double[] dArray = null;
                double[][] dArray2 = null;
                double d2 = Math.sqrt(this.targets.length);
                ProjectedTransformTry object2 = null;
                for (ProjectedTransformTry object3 : this.linearizers) {
                    if (!object3.projection.isIdentity()) continue;
                    matrixSIS = this.fit();
                    dArray = this.correlations;
                    d = LinearTransformBuilder.rms(dArray, d2);
                    dArray2 = this.targets;
                    this.appliedLinearizer = object3;
                    object2 = object3;
                    object3.correlation = (float)d;
                    break;
                }
                ArrayDeque arrayDeque = new ArrayDeque();
                LinearTransformBuilder linearTransformBuilder = new LinearTransformBuilder(this);
                int n = this.gridLength != 0 ? this.gridLength : this.numPoints;
                boolean bl = false;
                for (ProjectedTransformTry projectedTransformTry : this.linearizers) {
                    if (projectedTransformTry == object2 || (linearTransformBuilder.targets = projectedTransformTry.transform(this.targets, n, arrayDeque)) == null) continue;
                    if (matrixSIS == null) {
                        dArray2 = linearTransformBuilder.targets = projectedTransformTry.replaceTransformed(this.targets, linearTransformBuilder.targets);
                        matrixSIS = linearTransformBuilder.fit();
                        dArray = linearTransformBuilder.correlations;
                        d = LinearTransformBuilder.rms(dArray, d2);
                        projectedTransformTry.correlation = (float)d;
                        this.appliedLinearizer = projectedTransformTry;
                        continue;
                    }
                    MatrixSIS matrixSIS2 = linearTransformBuilder.fit();
                    double[] dArray3 = projectedTransformTry.replaceTransformed(dArray, linearTransformBuilder.correlations);
                    double d3 = LinearTransformBuilder.rms(dArray3, d2);
                    projectedTransformTry.correlation = (float)d3;
                    if (d3 > d) {
                        ProjectedTransformTry.recycle(dArray2, arrayDeque);
                        dArray2 = linearTransformBuilder.targets;
                        d = d3;
                        dArray = dArray3;
                        matrixSIS = projectedTransformTry.replaceTransformed(matrixSIS, matrixSIS2);
                        this.appliedLinearizer = projectedTransformTry;
                        bl = true;
                        continue;
                    }
                    ProjectedTransformTry.recycle(linearTransformBuilder.targets, arrayDeque);
                }
                if (matrixSIS == null) {
                    throw new LocalizationGridException(Resources.format((short)100), ProjectedTransformTry.getError(this.linearizers));
                }
                if (bl) {
                    dArray2 = this.appliedLinearizer.replaceTransformed(this.targets, dArray2);
                }
                this.targets = dArray2;
                this.correlations = dArray;
            }
            this.transform = (LinearTransform)LinearTransformBuilder.nonNull(mathTransformFactory).createAffineTransform((Matrix)matrixSIS);
        }
        return this.transform;
    }

    private MatrixSIS fit() throws FactoryException {
        double[][] dArray = this.sources;
        double[][] dArray2 = this.targets;
        if (dArray2 == null) {
            throw new InvalidGeodeticParameterException(LinearTransformBuilder.noData());
        }
        int n = dArray != null ? dArray.length : this.gridSize.length;
        int n2 = dArray2.length;
        this.correlations = new double[n2];
        final MatrixSIS matrixSIS = Matrices.create(n2 + 1, n + 1, ExtendedPrecisionMatrix.ZERO);
        matrixSIS.setElement(n2, n, 1.0);
        for (int i = 0; i < n2; ++i) {
            double d;
            switch (n) {
                case 1: {
                    final int n3 = i;
                    Cloneable cloneable = new Line(){

                        @Override
                        public void setEquation(Number number, Number number2) {
                            super.setEquation(number, number2);
                            matrixSIS.setNumber(n3, 0, number);
                            matrixSIS.setNumber(n3, 1, number2);
                        }
                    };
                    if (dArray != null) {
                        d = ((Line)cloneable).fit(this.vector(dArray[0]), this.vector(dArray2[i]));
                        break;
                    }
                    d = ((Line)cloneable).fit(Vector.createSequence(0, 1, this.gridSize[0]), Vector.create(dArray2[i]));
                    break;
                }
                case 2: {
                    final int n3 = i;
                    Cloneable cloneable = new Plane(){

                        @Override
                        public void setEquation(Number number, Number number2, Number number3) {
                            super.setEquation(number, number2, number3);
                            matrixSIS.setNumber(n3, 0, number);
                            matrixSIS.setNumber(n3, 1, number2);
                            matrixSIS.setNumber(n3, 2, number3);
                        }
                    };
                    if (dArray != null) {
                        d = ((Plane)cloneable).fit(this.vector(dArray[0]), this.vector(dArray[1]), this.vector(dArray2[i]));
                        break;
                    }
                    try {
                        d = ((Plane)cloneable).fit(this.gridSize[0], this.gridSize[1], Vector.create(dArray2[i]));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidGeodeticParameterException(LinearTransformBuilder.noData(), illegalArgumentException);
                    }
                }
                default: {
                    throw new InvalidGeodeticParameterException(Errors.format((short)37, n));
                }
            }
            this.correlations[i] = d;
        }
        return matrixSIS;
    }

    private Vector vector(double[] dArray) {
        assert (this.gridSize == null);
        return Vector.create(dArray).subList(0, this.numPoints);
    }

    private static double rms(double[] dArray, double d) {
        return MathFunctions.magnitude(dArray) / d;
    }

    public Optional<Map.Entry<String, MathTransform>> linearizer() {
        return Optional.ofNullable(this.appliedLinearizer);
    }

    final ProjectedTransformTry appliedLinearizer() {
        return this.appliedLinearizer;
    }

    public double[] correlation() {
        return this.correlations != null ? (double[])this.correlations.clone() : null;
    }

    final LinearTransform transform() {
        return this.transform;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder(400);
        try {
            string = this.appendTo(stringBuilder, this.getClass(), null, (short)174);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        Strings.insertLineInLeftMargin(stringBuilder, string);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    final String appendTo(StringBuilder stringBuilder, Class<?> clazz, Locale locale, short s) throws IOException {
        Object object;
        String string = System.lineSeparator();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        stringBuilder.append(Classes.getShortName(clazz)).append('[').append(this.numPoints).append(" points");
        if (this.gridSize != null) {
            object = " on ";
            for (int n : this.gridSize) {
                stringBuilder.append((String)object).append(n);
                object = " \u00d7 ";
            }
            stringBuilder.append(" grid");
        }
        stringBuilder.append(']').append(string);
        if (this.linearizers != null) {
            object = this.linearizers.toArray(new ProjectedTransformTry[this.linearizers.size()]);
            Arrays.sort((Object[])object);
            stringBuilder.append("\u25b6\u00a0");
            vocabulary.appendLabel((short)161, stringBuilder);
            stringBuilder.append(string);
            Object var8_9 = null;
            TableAppender tableAppender = new TableAppender(stringBuilder, " \u2502 ");
            tableAppender.appendHorizontalSeparator();
            tableAppender.append(vocabulary.getString((short)34)).nextColumn();
            tableAppender.append(vocabulary.getString((short)37)).nextLine();
            tableAppender.appendHorizontalSeparator();
            for (Object object2 : object) {
                void var8_10;
                NumberFormat numberFormat = ((ProjectedTransformTry)object2).summarize(tableAppender, (NumberFormat)var8_10, locale);
            }
            tableAppender.appendHorizontalSeparator();
            tableAppender.flush();
        }
        if (this.transform != null) {
            stringBuilder.append("\u25b6\u00a0");
            vocabulary.appendLabel(s, stringBuilder);
            stringBuilder.append(string);
            object = new TableAppender(stringBuilder, " ");
            ((TableAppender)object).setMultiLinesCells(true);
            ((TableAppender)object).append(Matrices.toString(this.transform.getMatrix())).nextColumn();
            ((TableAppender)object).append(string).append("  ").append(vocabulary.getString((short)37)).append(" =").nextColumn();
            ((TableAppender)object).append(Matrices.create(this.correlations.length, 1, this.correlations).toString());
            ((TableAppender)object).flush();
        }
        return string;
    }

    private class ControlPoints
    extends AbstractMap<DirectPosition, DirectPosition> {
        ControlPoints() {
        }

        final DirectPosition position(double[][] dArray, int n) {
            switch (dArray.length) {
                case 1: {
                    return new DirectPosition1D(dArray[0][n]);
                }
                case 2: {
                    return new DirectPosition2D(dArray[0][n], dArray[1][n]);
                }
            }
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                generalDirectPosition.setOrdinate(i, dArray[i][n]);
            }
            return generalDirectPosition;
        }

        int domain() {
            return LinearTransformBuilder.this.gridLength;
        }

        final int search(double[][] dArray, double[] dArray2) {
            if (dArray != null && dArray2.length == dArray.length) {
                int n = this.domain();
                block0: while (--n >= 0) {
                    for (int i = 0; i < dArray2.length; ++i) {
                        if (dArray2[i] != dArray[i][n]) continue block0;
                    }
                    return n;
                }
            }
            return -1;
        }

        @Override
        public final boolean containsValue(Object object) {
            return object instanceof Position && this.search(LinearTransformBuilder.this.targets, ((Position)object).getDirectPosition().getCoordinate()) >= 0;
        }

        @Override
        public final boolean containsKey(Object object) {
            return object instanceof Position && this.flatIndex(((Position)object).getDirectPosition()) >= 0;
        }

        @Override
        public final DirectPosition get(Object object) {
            int n;
            if (object instanceof Position && (n = this.flatIndex(((Position)object).getDirectPosition())) >= 0) {
                return this.position(LinearTransformBuilder.this.targets, n);
            }
            return null;
        }

        int flatIndex(DirectPosition directPosition) {
            int[] nArray;
            int n;
            double[][] dArray = LinearTransformBuilder.this.targets;
            if (dArray != null && (n = (nArray = LinearTransformBuilder.this.gridSize).length) == directPosition.getDimension()) {
                int n2 = 0;
                while (n != 0) {
                    int n3 = nArray[--n];
                    double d = directPosition.getOrdinate(n);
                    int n4 = (int)d;
                    if (n4 < 0 || n4 >= n3 || (double)n4 != d) {
                        return -1;
                    }
                    n2 = n2 * n3 + n4;
                }
                if (!Double.isNaN(dArray[0][n2])) {
                    return n2;
                }
            }
            return -1;
        }

        @Override
        protected AbstractMap.EntryIterator<DirectPosition, DirectPosition> entryIterator() {
            return new AbstractMap.EntryIterator<DirectPosition, DirectPosition>(){
                private int index = -1;

                @Override
                protected boolean next() {
                    double[][] dArray = LinearTransformBuilder.this.targets;
                    if (dArray != null) {
                        double[] dArray2 = dArray[0];
                        int n = LinearTransformBuilder.this.gridLength;
                        while (++this.index < n) {
                            if (Double.isNaN(dArray2[this.index])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                protected DirectPosition getKey() {
                    int[] nArray = LinearTransformBuilder.this.gridSize;
                    int n = nArray.length;
                    GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
                    int n2 = this.index;
                    for (int i = 0; i < n; ++i) {
                        int n3 = nArray[i];
                        generalDirectPosition.setOrdinate(i, n2 % n3);
                        n2 /= n3;
                    }
                    if (n2 == 0) {
                        return generalDirectPosition;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                protected DirectPosition getValue() {
                    return ControlPoints.this.position(LinearTransformBuilder.this.targets, this.index);
                }
            };
        }
    }

    private final class Ungridded
    extends ControlPoints {
        private Ungridded() {
        }

        @Override
        public boolean isEmpty() {
            return LinearTransformBuilder.this.numPoints == 0;
        }

        @Override
        public int size() {
            return LinearTransformBuilder.this.numPoints;
        }

        @Override
        int domain() {
            return LinearTransformBuilder.this.numPoints;
        }

        @Override
        int flatIndex(DirectPosition directPosition) {
            return this.search(LinearTransformBuilder.this.sources, directPosition.getCoordinate());
        }

        @Override
        protected AbstractMap.EntryIterator<DirectPosition, DirectPosition> entryIterator() {
            return new AbstractMap.EntryIterator<DirectPosition, DirectPosition>(){
                private int index = -1;

                @Override
                protected boolean next() {
                    return ++this.index < LinearTransformBuilder.this.numPoints;
                }

                @Override
                protected DirectPosition getKey() {
                    return Ungridded.this.position(LinearTransformBuilder.this.sources, this.index);
                }

                @Override
                protected DirectPosition getValue() {
                    return Ungridded.this.position(LinearTransformBuilder.this.targets, this.index);
                }
            };
        }
    }
}

