/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.fragment.Fragment;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javafragment.LineNumberTokensFragment;
import org.jd.core.v1.model.javafragment.StartBlockFragment;
import org.jd.core.v1.model.javafragment.StartBodyFragment;
import org.jd.core.v1.model.javafragment.TokensFragment;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.CommentExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaFormalParametersExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.ParenthesesExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.token.BooleanConstantToken;
import org.jd.core.v1.model.token.CharacterConstantToken;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.NumericConstantToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.StringConstantToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.CharacterUtil;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.JavaFragmentFactory;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.StringUtil;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.TypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class ExpressionVisitor
extends TypeVisitor {
    public static final KeywordToken CLASS = new KeywordToken("class");
    public static final KeywordToken FALSE = new KeywordToken("false");
    public static final KeywordToken INSTANCEOF = new KeywordToken("instanceof");
    public static final KeywordToken LENGTH = new KeywordToken("length");
    public static final KeywordToken NEW = new KeywordToken("new");
    public static final KeywordToken NULL = new KeywordToken("null");
    public static final KeywordToken THIS = new KeywordToken("this");
    public static final KeywordToken TRUE = new KeywordToken("true");
    protected static final int UNKNOWN_LINE_NUMBER = 0;
    protected LinkedList<Context> contextStack = new LinkedList();
    protected Fragments fragments = new Fragments();
    protected boolean inExpressionFlag = false;
    protected HashSet<String> currentMethodParamNames = new HashSet();
    protected String currentTypeName;
    protected HexaExpressionVisitor hexaExpressionVisitor = new HexaExpressionVisitor();

    public ExpressionVisitor(Loader loader, String mainInternalTypeName, int majorVersion, ImportsFragment importsFragment) {
        super(loader, mainInternalTypeName, majorVersion, importsFragment);
    }

    public DefaultList<Fragment> getFragments() {
        return this.fragments;
    }

    @Override
    public void visit(ArrayExpression expression) {
        this.visit(expression, expression.getExpression());
        this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
        expression.getIndex().accept(this);
        this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        switch (expression.getOperator()) {
            case "&": 
            case "|": 
            case "^": 
            case "&=": 
            case "|=": 
            case "^=": {
                this.visitHexa(expression, expression.getLeftExpression());
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(this.newTextToken(expression.getOperator()));
                this.tokens.add(TextToken.SPACE);
                this.visitHexa(expression, expression.getRightExpression());
                break;
            }
            default: {
                this.visit(expression, expression.getLeftExpression());
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(this.newTextToken(expression.getOperator()));
                this.tokens.add(TextToken.SPACE);
                this.visit(expression, expression.getRightExpression());
            }
        }
    }

    @Override
    public void visit(BooleanExpression expression) {
        if (expression.isTrue()) {
            this.tokens.add(TRUE);
        } else {
            this.tokens.add(FALSE);
        }
    }

    @Override
    public void visit(CastExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken(expression.getLineNumber());
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            Type type = expression.getType();
            type.accept(this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        }
        this.visit(expression, expression.getExpression());
    }

    @Override
    public void visit(CommentExpression expression) {
        this.tokens.add(StartMarkerToken.COMMENT);
        this.tokens.add(this.newTextToken(expression.getText()));
        this.tokens.add(EndMarkerToken.COMMENT);
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(THIS);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept(this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
        ObjectType ot = expression.getObjectType();
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(this.newTypeReferenceToken(ot, this.currentInternalTypeName));
        this.tokens.add(TextToken.COLON_COLON);
        this.tokens.add(NEW);
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getValue()) + 'D'));
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
        this.tokens.addLineNumberToken(expression);
        ObjectType type = expression.getObjectType();
        this.tokens.add(new ReferenceToken(2, type.getInternalName(), expression.getName(), type.getDescriptor(), this.currentInternalTypeName));
    }

    @Override
    public void visit(Expressions list) {
        int size;
        if (list != null && (size = list.size()) > 0) {
            Iterator iterator = list.iterator();
            for (int i = size - 1; i > 0; --i) {
                this.inExpressionFlag = true;
                ((Expression)iterator.next()).accept(this);
                if (this.tokens.isEmpty()) continue;
                this.tokens.add(TextToken.COMMA_SPACE);
            }
            this.inExpressionFlag = false;
            ((Expression)iterator.next()).accept(this);
        }
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        if (expression.getExpression() == null) {
            this.tokens.addLineNumberToken(expression);
            this.tokens.add(new TextToken(expression.getName()));
        } else {
            this.tokens.addLineNumberToken(expression.getExpression());
            int delta = this.tokens.size();
            this.visit(expression, expression.getExpression());
            this.tokens.addLineNumberToken(expression);
            if ((delta -= this.tokens.size()) != 0) {
                this.tokens.add(TextToken.DOT);
            }
            this.tokens.add(new ReferenceToken(2, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentInternalTypeName));
        }
    }

    @Override
    public void visit(FloatConstantExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getValue()) + 'F'));
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
        this.tokens.addLineNumberToken(expression);
        PrimitiveType pt = (PrimitiveType)expression.getType();
        switch (pt.getJavaPrimitiveFlags()) {
            case 2: {
                this.tokens.add(new CharacterConstantToken(CharacterUtil.escapeChar((char)expression.getValue()), this.currentInternalTypeName));
                break;
            }
            case 1: {
                this.tokens.add(new BooleanConstantToken(expression.getValue() != 0));
                break;
            }
            default: {
                this.tokens.add(new NumericConstantToken(String.valueOf(expression.getValue())));
            }
        }
    }

    @Override
    public void visit(InstanceOfExpression expression) {
        expression.getExpression().accept(this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(INSTANCEOF);
        this.tokens.add(TextToken.SPACE);
        Type type = expression.getInstanceOfType();
        type.accept(this);
    }

    @Override
    public void visit(LambdaFormalParametersExpression expression) {
        BaseFormalParameter parameters = expression.getParameters();
        if (parameters == null) {
            this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
        } else {
            int size = parameters.size();
            switch (size) {
                case 0: {
                    this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
                    break;
                }
                case 1: {
                    ((FormalParameter)parameters.getFirst()).accept(this);
                    break;
                }
                default: {
                    this.tokens.add(TextToken.LEFTROUNDBRACKET);
                    Iterator iterator = parameters.iterator();
                    ((FormalParameter)iterator.next()).accept(this);
                    while (iterator.hasNext()) {
                        this.tokens.add(TextToken.COMMA_SPACE);
                        ((FormalParameter)iterator.next()).accept(this);
                    }
                    this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                }
            }
        }
        this.visitLambdaBody(expression.getStatements());
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        List<String> parameters = expression.getParameters();
        if (parameters == null) {
            this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
        } else {
            int size = parameters.size();
            switch (size) {
                case 0: {
                    this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
                    break;
                }
                case 1: {
                    this.tokens.add(this.newTextToken(parameters.get(0)));
                    break;
                }
                default: {
                    this.tokens.add(TextToken.LEFTROUNDBRACKET);
                    this.tokens.add(this.newTextToken(parameters.get(0)));
                    for (int i = 1; i < size; ++i) {
                        this.tokens.add(TextToken.COMMA_SPACE);
                        this.tokens.add(this.newTextToken(parameters.get(i)));
                    }
                    this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                }
            }
        }
        this.visitLambdaBody(expression.getStatements());
    }

    protected void visitLambdaBody(BaseStatement statementList) {
        if (statementList != null) {
            this.tokens.add(TextToken.SPACE_ARROW_SPACE);
            if (statementList.getClass() == LambdaExpressionStatement.class) {
                statementList.accept(this);
            } else {
                this.fragments.addTokensFragment(this.tokens);
                StartBlockFragment start = JavaFragmentFactory.addStartStatementsInLambdaBlock(this.fragments);
                this.tokens = new TypeVisitor.Tokens(this);
                statementList.accept(this);
                JavaFragmentFactory.addEndStatementsInLambdaBlock(this.fragments, start);
                this.tokens = new TypeVisitor.Tokens(this);
            }
        }
    }

    @Override
    public void visit(LengthExpression expression) {
        this.visit(expression, expression.getExpression());
        this.tokens.add(TextToken.DOT);
        this.tokens.add(LENGTH);
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(this.newTextToken(expression.getName()));
    }

    @Override
    public void visit(LongConstantExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getValue()) + 'L'));
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        Expression exp = expression.getExpression();
        BaseTypeArgument nonWildcardTypeArguments = expression.getNonWildcardTypeArguments();
        BaseExpression parameters = expression.getParameters();
        boolean dot = false;
        if (exp.getClass() != ThisExpression.class) {
            if (exp.getClass() == ObjectTypeReferenceExpression.class) {
                ObjectType ot = ((ObjectTypeReferenceExpression)exp).getObjectType();
                if (!ot.getInternalName().equals(this.currentInternalTypeName)) {
                    this.visit(expression, exp);
                    this.tokens.addLineNumberToken(expression);
                    this.tokens.add(TextToken.DOT);
                    dot = true;
                }
            } else {
                this.visit(expression, exp);
                this.tokens.addLineNumberToken(expression);
                this.tokens.add(TextToken.DOT);
                dot = true;
            }
        }
        this.tokens.addLineNumberToken(expression);
        if (nonWildcardTypeArguments != null && dot) {
            this.tokens.add(TextToken.LEFTANGLEBRACKET);
            nonWildcardTypeArguments.accept(this);
            this.tokens.add(TextToken.RIGHTANGLEBRACKET);
        }
        this.tokens.add(new ReferenceToken(3, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentInternalTypeName));
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        if (parameters != null) {
            parameters.accept(this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(MethodReferenceExpression expression) {
        expression.getExpression().accept(this);
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(TextToken.COLON_COLON);
        this.tokens.add(new ReferenceToken(3, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentInternalTypeName));
    }

    @Override
    public void visit(NewArray expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(NEW);
        this.tokens.add(TextToken.SPACE);
        Type type = expression.getType();
        type.accept(this);
        BaseExpression dimensionExpressionList = expression.getDimensionExpressionList();
        int dimension = expression.getType().getDimension();
        if (dimension > 0) {
            this.tokens.remove(this.tokens.size() - 1);
        }
        if (dimensionExpressionList != null) {
            if (dimensionExpressionList.isList()) {
                Iterator iterator = dimensionExpressionList.iterator();
                while (iterator.hasNext()) {
                    this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
                    ((Expression)iterator.next()).accept(this);
                    this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
                    --dimension;
                }
            } else {
                this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
                dimensionExpressionList.accept(this);
                this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
                --dimension;
            }
        }
        this.visitDimension(dimension);
    }

    @Override
    public void visit(NewInitializedArray expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(NEW);
        this.tokens.add(TextToken.SPACE);
        Type type = expression.getType();
        type.accept(this);
        this.tokens.add(TextToken.SPACE);
        expression.getArrayInitializer().accept(this);
    }

    @Override
    public void visit(NewExpression expression) {
        BodyDeclaration bodyDeclaration = expression.getBodyDeclaration();
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(NEW);
        this.tokens.add(TextToken.SPACE);
        ObjectType objectType = expression.getObjectType();
        if (objectType.getTypeArguments() != null && bodyDeclaration == null && this.majorVersion >= 51) {
            objectType = objectType.createType(DiamondTypeArgument.DIAMOND);
        }
        ObjectType type = objectType;
        type.accept(this);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept(this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        if (bodyDeclaration != null) {
            this.fragments.addTokensFragment(this.tokens);
            StartBodyFragment start = JavaFragmentFactory.addStartTypeBody(this.fragments);
            ObjectType ot = expression.getObjectType();
            this.storeContext();
            this.currentInternalTypeName = bodyDeclaration.getInternalTypeName();
            this.currentTypeName = ot.getName();
            bodyDeclaration.accept(this);
            if (!this.tokens.isEmpty()) {
                this.tokens = new TypeVisitor.Tokens(this);
            }
            this.restoreContext();
            if (this.inExpressionFlag) {
                JavaFragmentFactory.addEndSubTypeBodyInParameter(this.fragments, start);
            } else {
                JavaFragmentFactory.addEndSubTypeBody(this.fragments, start);
            }
            this.tokens = new TypeVisitor.Tokens(this);
        }
    }

    @Override
    public void visit(NullExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(NULL);
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken(expression);
            Type type = expression.getType();
            type.accept(this);
        }
    }

    @Override
    public void visit(ParenthesesExpression expression) {
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        expression.getExpression().accept(this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(PostOperatorExpression expression) {
        this.visit(expression, expression.getExpression());
        this.tokens.add(this.newTextToken(expression.getOperator()));
    }

    @Override
    public void visit(PreOperatorExpression expression) {
        this.tokens.addLineNumberToken(expression.getExpression());
        this.tokens.add(this.newTextToken(expression.getOperator()));
        this.visit(expression, expression.getExpression());
    }

    @Override
    public void visit(StringConstantExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(new StringConstantToken(StringUtil.escapeString(expression.getString()), this.currentInternalTypeName));
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(SUPER);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept(this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(SuperExpression expression) {
        this.tokens.addLineNumberToken(expression);
        this.tokens.add(SUPER);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        this.tokens.addLineNumberToken(expression.getCondition());
        if (expression.getExpressionTrue().getClass() == BooleanExpression.class && expression.getExpressionFalse().getClass() == BooleanExpression.class) {
            BooleanExpression be1 = (BooleanExpression)expression.getExpressionTrue();
            BooleanExpression be2 = (BooleanExpression)expression.getExpressionFalse();
            if (be1.isTrue() && be2.isFalse()) {
                this.printTernaryOperatorExpression(expression.getCondition());
                return;
            }
            if (be1.isFalse() && be2.isTrue()) {
                this.tokens.add(TextToken.EXCLAMATION);
                this.printTernaryOperatorExpression(expression.getCondition());
                return;
            }
        }
        this.printTernaryOperatorExpression(expression.getCondition());
        this.tokens.add(TextToken.SPACE_QUESTION_SPACE);
        this.printTernaryOperatorExpression(expression.getExpressionTrue());
        this.tokens.add(TextToken.SPACE_COLON_SPACE);
        this.printTernaryOperatorExpression(expression.getExpressionFalse());
    }

    protected void printTernaryOperatorExpression(Expression expression) {
        if (expression.getPriority() > 3) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            expression.accept(this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visit(ThisExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken(expression);
            this.tokens.add(THIS);
        }
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
        this.tokens.addLineNumberToken(expression);
        Type type = expression.getTypeDotClass();
        type.accept(this);
        this.tokens.add(TextToken.DOT);
        this.tokens.add(CLASS);
    }

    protected void storeContext() {
        this.contextStack.add(new Context(this.currentInternalTypeName, this.currentTypeName, this.currentMethodParamNames));
    }

    protected void restoreContext() {
        Context currentContext = this.contextStack.removeLast();
        this.currentInternalTypeName = currentContext.currentInternalTypeName;
        this.currentTypeName = currentContext.currentTypeName;
        this.currentMethodParamNames = currentContext.currentMethodParamNames;
    }

    protected void visit(Expression parent, Expression child) {
        if (parent.getPriority() < child.getPriority() || parent.getPriority() == 14 && child.getPriority() == 13) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            child.accept(this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            child.accept(this);
        }
    }

    protected void visitHexa(Expression parent, Expression child) {
        if (parent.getPriority() < child.getPriority() || parent.getPriority() == 14 && child.getPriority() == 13) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            child.accept(this.hexaExpressionVisitor);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            child.accept(this.hexaExpressionVisitor);
        }
    }

    protected class HexaExpressionVisitor
    implements org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor {
        protected HexaExpressionVisitor() {
        }

        @Override
        public void visit(IntegerConstantExpression expression) {
            ExpressionVisitor.this.tokens.addLineNumberToken(expression);
            PrimitiveType pt = (PrimitiveType)expression.getType();
            switch (pt.getJavaPrimitiveFlags()) {
                case 1: {
                    ExpressionVisitor.this.tokens.add(new BooleanConstantToken(expression.getValue() == 1));
                    break;
                }
                default: {
                    ExpressionVisitor.this.tokens.add(new NumericConstantToken("0x" + Integer.toHexString(expression.getValue()).toUpperCase()));
                }
            }
        }

        @Override
        public void visit(LongConstantExpression expression) {
            ExpressionVisitor.this.tokens.addLineNumberToken(expression);
            ExpressionVisitor.this.tokens.add(new NumericConstantToken("0x" + Long.toHexString(expression.getValue()).toUpperCase() + 'L'));
        }

        @Override
        public void visit(ArrayExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(BinaryOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(BooleanExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(CastExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(CommentExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(ConstructorInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(ConstructorReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(DoubleConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(EnumConstantReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(Expressions expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(FieldReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(FloatConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(InstanceOfExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(LambdaFormalParametersExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(LambdaIdentifiersExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(LengthExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(LocalVariableReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(MethodInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(MethodReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(NewArray expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(NewExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(NewInitializedArray expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(NullExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(ObjectTypeReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(ParenthesesExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(PostOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(PreOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(StringConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(SuperConstructorInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(SuperExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(TernaryOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(ThisExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        @Override
        public void visit(TypeReferenceDotClassExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }
    }

    protected static class Fragments
    extends DefaultList<Fragment> {
        protected Fragments() {
        }

        public void addTokensFragment(TypeVisitor.Tokens tokens) {
            if (!tokens.isEmpty()) {
                if (tokens.getCurrentLineNumber() == 0) {
                    super.add(new TokensFragment(tokens));
                } else {
                    super.add(new LineNumberTokensFragment(tokens));
                }
            }
        }
    }

    protected static class Context {
        public final String currentInternalTypeName;
        public final String currentTypeName;
        public final HashSet<String> currentMethodParamNames;

        public Context(String currentInternalTypeName, String currentTypeName, HashSet<String> currentMethodParamNames) {
            this.currentInternalTypeName = currentInternalTypeName;
            this.currentTypeName = currentTypeName;
            this.currentMethodParamNames = new HashSet<String>(currentMethodParamNames);
        }
    }
}

