/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.terminal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.aesh.command.shell.Shell;
import org.aesh.io.Encoder;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.Config;
import org.jboss.galleon.cli.CliLogging;

class CliShell
implements Shell {
    private final Terminal terminal;
    private final Consumer<int[]> stdOut;
    private final TerminalConnection connection;
    private final Readline readline;

    CliShell(TerminalConnection connection) throws IOException {
        this.connection = connection;
        this.terminal = connection.getTerminal();
        this.stdOut = this.terminal.getCodePointConsumer() == null ? new Encoder(Charset.defaultCharset(), this::write) : this.terminal.getCodePointConsumer();
        this.readline = new Readline(EditModeBuilder.builder().create());
    }

    public void close() throws IOException {
        this.terminal.close();
    }

    private void write(byte[] data) {
        try {
            this.terminal.output().write(data);
        }
        catch (IOException ex) {
            CliLogging.exception(ex);
        }
    }

    @Override
    public void write(String msg, boolean paging) {
        this.stdOut.accept(msg.codePoints().toArray());
    }

    @Override
    public void writeln(String msg, boolean paging) {
        this.stdOut.accept((msg + Config.getLineSeparator()).codePoints().toArray());
    }

    @Override
    public void write(int[] out) {
        this.stdOut.accept(out);
    }

    @Override
    public void write(char out) {
        this.stdOut.accept(new int[]{out});
    }

    @Override
    public String readLine() throws InterruptedException {
        return this.readLine(new Prompt(""));
    }

    @Override
    public String readLine(Prompt prompt) throws InterruptedException {
        String[] out = new String[]{null};
        this.readline.readline((Connection)this.connection, prompt, event -> {
            out[0] = event;
            this.connection.stopReading();
        });
        try {
            this.connection.openBlocking();
        }
        finally {
            this.connection.setStdinHandler(null);
        }
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key read() throws InterruptedException {
        ActionDecoder decoder = new ActionDecoder();
        Key[] key = new Key[]{null};
        Attributes attributes = this.connection.enterRawMode();
        try {
            this.connection.setStdinHandler(keys -> {
                decoder.add((int[])keys);
                if (decoder.hasNext()) {
                    key[0] = Key.findStartKey(decoder.next().buffer().array());
                    this.connection.stopReading();
                }
            });
            try {
                this.connection.openBlocking();
            }
            finally {
                this.connection.setStdinHandler(null);
            }
        }
        finally {
            this.connection.setAttributes(attributes);
        }
        return key[0];
    }

    @Override
    public Key read(Prompt prompt) throws InterruptedException {
        return null;
    }

    @Override
    public boolean enableAlternateBuffer() {
        return this.connection.put(Capability.enter_ca_mode, new Object[0]);
    }

    @Override
    public boolean enableMainBuffer() {
        return this.connection.put(Capability.exit_ca_mode, new Object[0]);
    }

    @Override
    public Size size() {
        return this.connection.size();
    }

    @Override
    public void clear() {
        this.connection.put(Capability.clear_screen, new Object[0]);
    }
}

