/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.event.ProfileChangeEvent;
import ca.sqlpower.architect.profile.event.ProfileChangeListener;
import ca.sqlpower.architect.profile.output.ProfileColumn;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.ProfilePanel;
import ca.sqlpower.architect.swingui.action.SaveProfileAction;
import ca.sqlpower.architect.swingui.table.MultiFreqValueCountTableModel;
import ca.sqlpower.architect.swingui.table.ProfileJTable;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.TableFilterDecorator;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.TimedDocumentListener;
import ca.sqlpower.swingui.table.DateTableCellRenderer;
import ca.sqlpower.swingui.table.FancyExportableJTable;
import ca.sqlpower.swingui.table.PercentTableCellRenderer;
import ca.sqlpower.swingui.table.TableModelColumnAutofit;
import ca.sqlpower.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.swingui.table.TableModelSortDecorator;
import ca.sqlpower.swingui.table.TableTextConverter;
import ca.sqlpower.swingui.table.TableUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class ProfileResultsViewer {
    private static final Logger logger = Logger.getLogger(ProfileResultsViewer.class);
    private final ProfileManager profileManager;
    private final Collection<TableProfileResult> results;
    private final JFrame frame;
    private TimedDocumentListener tableNotesFieldListener;
    private TableProfileResult currentTable;
    private final ProfileTableModel tm;
    private final ProfileChangeListener profileChangeListener = new ProfileChangeListener(){

        @Override
        public void profilesAdded(ProfileChangeEvent e) {
            List<ProfileResult> profileResult = e.getProfileResults();
            logger.debug((Object)("ProfileResultsViewer.inner.profileAdded()" + profileResult));
        }

        @Override
        public void profileListChanged(ProfileChangeEvent event) {
            this.disposeIfEmpty();
        }

        @Override
        public void profilesRemoved(ProfileChangeEvent e) {
            this.disposeIfEmpty();
        }

        private void disposeIfEmpty() {
            for (TableProfileResult tpr : ProfileResultsViewer.this.results) {
                if (!ProfileResultsViewer.this.profileManager.getResults().contains(tpr)) continue;
                return;
            }
            ProfileResultsViewer.this.frame.dispose();
        }
    };
    private final Action closeAction = new AbstractAction(Messages.getString("ProfileResultsViewer.closeButton")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileResultsViewer.this.frame.dispose();
        }
    };
    private JComboBox tableSelector;

    public ProfileResultsViewer(ProfileManager pm) {
        JTextArea notesField;
        this.profileManager = pm;
        this.results = new ArrayList<TableProfileResult>();
        this.frame = new JFrame(Messages.getString("ProfileResultsViewer.frameTitle"));
        this.frame.setIconImage(ASUtils.getFrameIconImage());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ProfileResultsViewer.this.tm.cleanup();
                ProfileResultsViewer.this.profileManager.removeProfileChangeListener(ProfileResultsViewer.this.profileChangeListener);
            }
        });
        JTabbedPane tabPane = new JTabbedPane();
        this.tm = new ProfileTableModel(this.profileManager);
        this.profileManager.addProfileChangeListener(this.profileChangeListener);
        ProfilePanelMouseListener profilePanelMouseListener = new ProfilePanelMouseListener();
        ComboBoxSynchronizationListener graphPanelListener = new ComboBoxSynchronizationListener();
        ComboBoxSynchronizationListener tableViewListener = new ComboBoxSynchronizationListener();
        JPanel profilePanel = new JPanel(new BorderLayout());
        final ProfilePanel p = new ProfilePanel(this.tm, this.profileManager);
        p.setTabPane(tabPane);
        p.setTableModel(this.tm);
        profilePanel.add((Component)p, "Center");
        ButtonBarBuilder2 profileButtons = new ButtonBarBuilder2();
        profileButtons.addGlue();
        profileButtons.addFixed((JComponent)new JButton(this.closeAction));
        profilePanel.add((Component)profileButtons.getPanel(), "South");
        tabPane.addTab(Messages.getString("ProfileResultsViewer.graphViewTab"), profilePanel);
        profilePanelMouseListener.setProfilePanel(p);
        p.getTableSelector().addActionListener(graphPanelListener);
        tableViewListener.setTarget(p.getTableSelector());
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                p.close();
                if (ProfileResultsViewer.this.tableNotesFieldListener != null) {
                    ProfileResultsViewer.this.tableNotesFieldListener.cancel();
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        TableModelSearchDecorator searchDecorator = new TableModelSearchDecorator((TableModel)this.tm);
        final TableFilterDecorator filterTableModel = new TableFilterDecorator((TableModel)searchDecorator);
        TableModelSortDecorator tableModelSortDecorator = new TableModelSortDecorator((TableModel)filterTableModel);
        final ProfileJTable viewTable = new ProfileJTable((TableModel)tableModelSortDecorator);
        searchDecorator.setTableTextConverter((TableTextConverter)viewTable);
        TableModelColumnAutofit columnAutoFit = new TableModelColumnAutofit((TableModel)tableModelSortDecorator, (JTable)viewTable);
        JTableHeader tableHeader = viewTable.getTableHeader();
        tableModelSortDecorator.setTableHeader(tableHeader);
        columnAutoFit.setTableHeader(tableHeader);
        viewTable.setAutoResizeMode(4);
        profilePanelMouseListener.setTabPane(tabPane);
        viewTable.addMouseListener(profilePanelMouseListener);
        viewTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableUtils.fitColumnWidths((JTable)viewTable, (int)2);
            }
        });
        JScrollPane editorScrollPane = new JScrollPane(viewTable);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(800, 600));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JPanel tableViewPane = new JPanel(new BorderLayout());
        if (this.profileManager.getWorkspaceContainer() instanceof ArchitectSession && ((ArchitectSession)this.profileManager.getWorkspaceContainer()).isEnterpriseSession()) {
            notesField = new JTextArea();
            notesField.setEnabled(false);
            notesField.setText("Select a Table");
            JScrollPane notesScroll = new JScrollPane(notesField);
            notesScroll.setVerticalScrollBarPolicy(22);
            notesScroll.setHorizontalScrollBarPolicy(32);
            notesScroll.setMinimumSize(new Dimension(0, 50));
            JPanel notesPanel = new JPanel(new BorderLayout());
            notesPanel.add((Component)new JLabel("Table Profile Notes:"), "North");
            notesPanel.add((Component)notesScroll, "Center");
            JSplitPane tableViewSplit = new JSplitPane(0);
            tableViewSplit.setTopComponent(editorScrollPane);
            tableViewSplit.setBottomComponent(notesPanel);
            tableViewPane.add((Component)tableViewSplit, "Center");
        } else {
            tableViewPane.add(editorScrollPane);
            notesField = null;
        }
        JPanel searchPanel = new JPanel();
        FormLayout layout = new FormLayout("4dlu, pref, 4dlu, pref, 4dlu, pref:grow, 4dlu, pref, 4dlu, pref, 4dlu", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, searchPanel);
        CellConstraints cc = new CellConstraints();
        JLabel tableLabel = new JLabel("Table:");
        this.tableSelector = new JComboBox();
        this.tableSelector.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                TableProfileResult tpr = (TableProfileResult)value;
                StringBuffer buf = new StringBuffer();
                if (tpr != null) {
                    buf.append(((SQLTable)tpr.getProfiledObject()).getName());
                    buf.append(" (");
                    DateFormat df = DateFormat.getDateTimeInstance();
                    buf.append(df.format(new Date(tpr.getCreateStartTime())));
                    buf.append(")");
                } else {
                    buf.append("All");
                }
                return super.getListCellRendererComponent((JList<?>)list, buf.toString(), index, isSelected, cellHasFocus);
            }
        });
        this.tableSelector.addActionListener(new ActionListener(){
            private AbstractSPListener tableNotesListener;

            @Override
            public void actionPerformed(ActionEvent e) {
                final TableProfileResult tpr = (TableProfileResult)ProfileResultsViewer.this.tableSelector.getSelectedItem();
                filterTableModel.setFilter(tpr);
                if (notesField != null) {
                    if (ProfileResultsViewer.this.tableNotesFieldListener != null) {
                        notesField.getDocument().removeDocumentListener((DocumentListener)ProfileResultsViewer.this.tableNotesFieldListener);
                        ProfileResultsViewer.this.tableNotesFieldListener.cancel();
                    }
                    if (ProfileResultsViewer.this.currentTable != null) {
                        ProfileResultsViewer.this.currentTable.removeSPListener((SPListener)this.tableNotesListener);
                    }
                    ProfileResultsViewer.this.currentTable = tpr;
                    if (tpr != null) {
                        notesField.setText(tpr.getNotes());
                        this.tableNotesListener = new AbstractSPListener(){

                            public void propertyChanged(PropertyChangeEvent evt) {
                                if ("notes".equals(evt.getPropertyName()) && !evt.getNewValue().equals(notesField.getText())) {
                                    notesField.setText((String)evt.getNewValue());
                                }
                            }
                        };
                        tpr.addSPListener((SPListener)this.tableNotesListener);
                        ProfileResultsViewer.this.tableNotesFieldListener = new TimedDocumentListener(((SQLTable)tpr.getProfiledObject()).getName(), 2500L){

                            public void textChanged() {
                                final String notesText = notesField.getText();
                                ProfileResultsViewer.this.profileManager.getRunnableDispatcher().runInForeground(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!tpr.getNotes().equals(notesText)) {
                                            tpr.setNotes(notesText);
                                        }
                                    }
                                });
                            }
                        };
                        notesField.setEnabled(true);
                    } else {
                        notesField.setEnabled(false);
                        notesField.setText("Select a Table");
                        ProfileResultsViewer.this.tableNotesFieldListener = null;
                    }
                    if (ProfileResultsViewer.this.tableNotesFieldListener != null) {
                        notesField.getDocument().addDocumentListener((DocumentListener)ProfileResultsViewer.this.tableNotesFieldListener);
                    }
                }
            }
        });
        this.tableSelector.addActionListener(tableViewListener);
        graphPanelListener.setTarget(this.tableSelector);
        JLabel searchLabel = new JLabel(Messages.getString("ProfileResultsViewer.search"));
        JTextField searchField = new JTextField(searchDecorator.getDoc(), "", 25);
        searchField.setEditable(true);
        builder.add((Component)tableLabel, cc.xy(2, 1));
        builder.add((Component)this.tableSelector, cc.xy(4, 1));
        builder.add((Component)searchLabel, cc.xy(8, 1));
        builder.add((Component)searchField, cc.xy(10, 1));
        tableViewPane.add((Component)searchPanel, "North");
        ButtonBarBuilder2 tableButtons = new ButtonBarBuilder2();
        tableButtons.addGlue();
        tableButtons.addFixed((JComponent)new JButton(new SaveProfileAction(this.frame, Messages.getString("ProfileResultsViewer.PDFExport"), viewTable, SaveProfileAction.SaveableFileType.PDF)));
        tableButtons.addFixed((JComponent)new JButton(new SaveProfileAction(this.frame, Messages.getString("ProfileResultsViewer.CSVExport"), viewTable, SaveProfileAction.SaveableFileType.CSV)));
        tableButtons.addFixed((JComponent)new JButton(new SaveProfileAction(this.frame, Messages.getString("ProfileResultsViewer.HTMLExport"), viewTable, SaveProfileAction.SaveableFileType.HTML)));
        tableButtons.addFixed((JComponent)new JButton(this.closeAction));
        tableViewPane.add((Component)tableButtons.getPanel(), "South");
        tabPane.addTab(Messages.getString("ProfileResultsViewer.tableViewTab"), tableViewPane);
        MultiFreqValueCountTableModel columnTableModel = new MultiFreqValueCountTableModel(this.tm);
        JTextField columnSearchField = new JTextField("", 25);
        final FancyExportableJTable columnTable = new FancyExportableJTable((TableModel)columnTableModel, columnSearchField.getDocument());
        columnTable.getTableModelSortDecorator().setColumnComparator(columnTableModel.getColumnClass(2), (Comparator)new ColumnValueCount.ColumnValueComparator());
        columnTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableUtils.fitColumnWidths((JTable)columnTable, (int)15);
            }
        });
        columnTable.setColumnFormatter(4, new PercentTableCellRenderer(false).getFormat());
        columnTable.setColumnFormatter(5, new DateTableCellRenderer().getFormat());
        for (int i = 0; i < columnTableModel.getColumnCount(); ++i) {
            columnTable.getColumnModel().getColumn(i).setCellRenderer(columnTableModel.getCellRenderer(i));
        }
        JPanel columnViewerPanel = new JPanel(new BorderLayout());
        columnViewerPanel.add((Component)new JScrollPane((Component)columnTable), "Center");
        JPanel columnSearchPanel = new JPanel(new FlowLayout(2));
        columnSearchPanel.add(new JLabel(Messages.getString("ProfileResultsViewer.search")));
        columnSearchPanel.add(columnSearchField);
        columnViewerPanel.add((Component)columnSearchPanel, "North");
        ButtonBarBuilder2 columnButtonBar = new ButtonBarBuilder2();
        columnButtonBar.addGlue();
        JButton csvExportButton = new JButton(columnTable.getExportCSVAction());
        csvExportButton.setText(Messages.getString("ProfileResultsViewer.CSVExport"));
        columnButtonBar.addFixed((JComponent)csvExportButton);
        JButton htmlExportButton = new JButton(columnTable.getExportHTMLAction());
        htmlExportButton.setText(Messages.getString("ProfileResultsViewer.HTMLExport"));
        columnButtonBar.addFixed((JComponent)htmlExportButton);
        columnButtonBar.addFixed((JComponent)new JButton(this.closeAction));
        columnViewerPanel.add((Component)columnButtonBar.getPanel(), "South");
        tabPane.addTab(Messages.getString("ProfileResultsViewer.columnViewTab"), columnViewerPanel);
        this.frame.add((Component)tabPane, "Center");
        this.frame.setDefaultCloseOperation(2);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        SPSUtils.makeJDialogCancellable((Window)this.frame, null);
    }

    public void addTableProfileResult(TableProfileResult result) {
        this.results.add(result);
        this.tm.refresh();
    }

    public void addTableProfileResultToScan(TableProfileResult result) {
        this.tm.addTableResultToScan(result);
        ArrayList<TableProfileResult> profileResults = new ArrayList<TableProfileResult>(this.tm.getTableResultsToScan());
        profileResults.add(0, null);
        this.tableSelector.setModel(new DefaultComboBoxModel<Object>(profileResults.toArray()));
    }

    public void removeTableProfileResultToScan(TableProfileResult result) {
        this.tm.removeTableResultToScan(result);
        this.tableSelector.setModel(new DefaultComboBoxModel<Object>(this.tm.getTableResultsToScan().toArray()));
    }

    public void clearScanList() {
        this.tm.clearScanList();
    }

    public JFrame getDialog() {
        return this.frame;
    }

    private class ComboBoxSynchronizationListener
    implements ActionListener {
        private JComboBox target;

        private ComboBoxSynchronizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox && this.target != null && (this.target.getSelectedItem() == null ? ((JComboBox)e.getSource()).getSelectedItem() != null : !this.target.getSelectedItem().equals(((JComboBox)e.getSource()).getSelectedItem()))) {
                this.target.setSelectedItem(((JComboBox)e.getSource()).getSelectedItem());
            }
        }

        public void setTarget(JComboBox target) {
            this.target = target;
        }
    }

    private class ProfilePanelMouseListener
    extends MouseAdapter {
        private ProfilePanel profilePanel;
        private JTabbedPane tabPane;

        private ProfilePanelMouseListener() {
        }

        public void setProfilePanel(ProfilePanel profilePanel) {
            this.profilePanel = profilePanel;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Object obj = evt.getSource();
            if (evt.getClickCount() == 2 && obj instanceof JTable) {
                JTable t = (JTable)obj;
                SQLColumn col = (SQLColumn)t.getValueAt(t.getSelectedRow(), t.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                this.profilePanel.getTableSelector().setSelectedItem(col.getParent());
                this.profilePanel.getColumnSelector().setSelectedValue(col, true);
                this.tabPane.setSelectedIndex(0);
            }
        }

        public void setTabPane(JTabbedPane tabPane) {
            this.tabPane = tabPane;
        }
    }
}

