#!/usr/bin/env perl
#
# Constants.pm
#
# Copyright (C) 2005 David J. Goehrig <dgoehrig@cpan.org>
#
# ------------------------------------------------------------------------------
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# ------------------------------------------------------------------------------
#
# Please feel free to send questions, suggestions or improvements to:
#
#	David J. Goehrig
#	dgoehrig@cpan.org
#

package SDL::OpenGL::Constants;

@EXPORT=qw(
	GLU_AUTO_LOAD_MATRIX
	GLU_CULLING
	GLU_DISPLAY_MODE
	GLU_DOMAIN_DISTANCE
	GLU_FILL
	GLU_MAP1_TRIM_2
	GLU_MAP1_TRIM_3
	GLU_NURBS_BEGIN
	GLU_NURBS_BEGIN_DATA
	GLU_NURBS_COLOR
	GLU_NURBS_COLOR_DATA
	GLU_NURBS_END
	GLU_NURBS_END_DATA
	GLU_NURBS_ERROR
	GLU_NURBS_MODE
	GLU_NURBS_NORMAL
	GLU_NURBS_NORMAL_DATA
	GLU_NURBS_RENDERER
	GLU_NURBS_TESSELLATOR
	GLU_NURBS_TEXTURE_COORD
	GLU_NURBS_TEXTURE_COORD_DATA
	GLU_NURBS_VERTEX
	GLU_NURBS_VERTEX_DATA
	GLU_OBJECT_PARAMETRIC_ERROR
	GLU_OBJECT_PATH_LENGTH
	GLU_OUTLINE_PATCH
	GLU_OUTLINE_POLYGON
	GLU_PARAMETRIC_TOLERANCE
	GLU_PATH_LENGTH
	GLU_SAMPLING_METHOD
	GLU_SAMPLING_TOLERANCE
	GLU_TESS_BOUNDARY_ONLY
	GLU_TESS_TOLERANCE
	GLU_TESS_WINDING_ABS_GEQ_TWO
	GLU_TESS_WINDING_NEGATIVE
	GLU_TESS_WINDING_NONZERO
	GLU_TESS_WINDING_ODD
	GLU_TESS_WINDING_POSITIVE
	GLU_TESS_WINDING_RULE
	GLU_U_STEP
	GLU_V_STEP
	GL_2D
	GL_2_BYTES
	GL_3D
	GL_3D_COLOR
	GL_3D_COLOR_TEXTURE
	GL_3_BYTES
	GL_4D_COLOR_TEXTURE
	GL_4_BYTES
	GL_ABGR_EXT
	GL_ACCUM
	GL_ACCUM_ALPHA_BITS
	GL_ACCUM_BLUE_BITS
	GL_ACCUM_BUFFER_BIT
	GL_ACCUM_CLEAR_VALUE
	GL_ACCUM_GREEN_BITS
	GL_ACCUM_RED_BITS
	GL_ACTIVE_STENCIL_FACE_EXT
	GL_ACTIVE_TEXTURE
	GL_ACTIVE_TEXTURE_ARB
	GL_ADD
	GL_ADD_SIGNED
	GL_ADD_SIGNED_ARB
	GL_ADD_SIGNED_EXT
	GL_ALIASED_LINE_WIDTH_RANGE
	GL_ALIASED_POINT_SIZE_RANGE
	GL_ALL_ATTRIB_BITS
	GL_ALL_COMPLETED_NV
	GL_ALL_EXTENSIONS_NV
	GL_ALPHA
	GL_ALPHA12
	GL_ALPHA16
	GL_ALPHA4
	GL_ALPHA8
	GL_ALPHA_BIAS
	GL_ALPHA_BITS
	GL_ALPHA_SCALE
	GL_ALPHA_TEST
	GL_ALPHA_TEST_FUNC
	GL_ALPHA_TEST_REF
	GL_ALWAYS
	GL_AMBIENT
	GL_AMBIENT_AND_DIFFUSE
	GL_AND
	GL_AND_INVERTED
	GL_AND_REVERSE
	GL_ARRAY_BUFFER_ARB
	GL_ARRAY_BUFFER_BINDING_ARB
	GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
	GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
	GL_ATTRIB_ARRAY_POINTER_NV
	GL_ATTRIB_ARRAY_SIZE_NV
	GL_ATTRIB_ARRAY_STRIDE_NV
	GL_ATTRIB_ARRAY_TYPE_NV
	GL_ATTRIB_STACK_DEPTH
	GL_AUTO_NORMAL
	GL_AUX0
	GL_AUX1
	GL_AUX2
	GL_AUX3
	GL_AUX_BUFFERS
	GL_BACK
	GL_BACK_LEFT
	GL_BACK_RIGHT
	GL_BGR
	GL_BGRA
	GL_BGRA_EXT
	GL_BGR_EXT
	GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
	GL_BITMAP
	GL_BITMAP_TOKEN
	GL_BLEND
	GL_BLEND_COLOR
	GL_BLEND_COLOR_EXT
	GL_BLEND_DST
	GL_BLEND_DST_ALPHA
	GL_BLEND_DST_ALPHA_EXT
	GL_BLEND_DST_RGB
	GL_BLEND_DST_RGB_EXT
	GL_BLEND_EQUATION
	GL_BLEND_EQUATION_EXT
	GL_BLEND_SRC
	GL_BLEND_SRC_ALPHA
	GL_BLEND_SRC_ALPHA_EXT
	GL_BLEND_SRC_RGB
	GL_BLEND_SRC_RGB_EXT
	GL_BLUE
	GL_BLUE_BIAS
	GL_BLUE_BITS
	GL_BLUE_SCALE
	GL_BUFFER_ACCESS_ARB
	GL_BUFFER_MAPPED_ARB
	GL_BUFFER_MAP_POINTER_ARB
	GL_BUFFER_SIZE_ARB
	GL_BUFFER_USAGE_ARB
	GL_BYTE
	GL_C3F_V3F
	GL_C4F_N3F_V3F
	GL_C4UB_V2F
	GL_C4UB_V3F
	GL_CCW
	GL_CLAMP
	GL_CLAMP_TO_BORDER
	GL_CLAMP_TO_BORDER_ARB
	GL_CLAMP_TO_EDGE
	GL_CLAMP_TO_EDGE_EXT
	GL_CLEAR
	GL_CLIENT_ACTIVE_TEXTURE
	GL_CLIENT_ACTIVE_TEXTURE_ARB
	GL_CLIENT_ALL_ATTRIB_BITS
	GL_ALL_CLIENT_ATTRIB_BITS
	GL_CLIENT_ATTRIB_STACK_DEPTH
	GL_CLIENT_PIXEL_STORE_BIT
	GL_CLIENT_VERTEX_ARRAY_BIT
	GL_CLIP_PLANE0
	GL_CLIP_PLANE1
	GL_CLIP_PLANE2
	GL_CLIP_PLANE3
	GL_CLIP_PLANE4
	GL_CLIP_PLANE5
	GL_CLIP_VOLUME_CLIPPING_HINT_EXT
	GL_COEFF
	GL_COLOR
	GL_COLOR_ARRAY
	GL_COLOR_ARRAY_BUFFER_BINDING_ARB
	GL_COLOR_ARRAY_COUNT_EXT
	GL_COLOR_ARRAY_EXT
	GL_COLOR_ARRAY_POINTER
	GL_COLOR_ARRAY_POINTER_EXT
	GL_COLOR_ARRAY_SIZE
	GL_COLOR_ARRAY_SIZE_EXT
	GL_COLOR_ARRAY_STRIDE
	GL_COLOR_ARRAY_STRIDE_EXT
	GL_COLOR_ARRAY_TYPE
	GL_COLOR_ARRAY_TYPE_EXT
	GL_COLOR_BUFFER_BIT
	GL_COLOR_CLEAR_VALUE
	GL_COLOR_INDEX
	GL_COLOR_INDEX12_EXT
	GL_COLOR_INDEX16_EXT
	GL_COLOR_INDEX1_EXT
	GL_COLOR_INDEX2_EXT
	GL_COLOR_INDEX4_EXT
	GL_COLOR_INDEX8_EXT
	GL_COLOR_INDEXES
	GL_COLOR_LOGIC_OP
	GL_COLOR_MATERIAL
	GL_COLOR_MATERIAL_FACE
	GL_COLOR_MATERIAL_PARAMETER
	GL_COLOR_MATRIX
	GL_COLOR_MATRIX_STACK_DEPTH
	GL_COLOR_SUM
	GL_COLOR_SUM_ARB
	GL_COLOR_SUM_CLAMP_NV
	GL_COLOR_SUM_EXT
	GL_COLOR_TABLE
	GL_COLOR_TABLE_ALPHA_SIZE
	GL_COLOR_TABLE_ALPHA_SIZE_EXT
	GL_COLOR_TABLE_BIAS
	GL_COLOR_TABLE_BLUE_SIZE
	GL_COLOR_TABLE_BLUE_SIZE_EXT
	GL_COLOR_TABLE_FORMAT
	GL_COLOR_TABLE_FORMAT_EXT
	GL_COLOR_TABLE_GREEN_SIZE
	GL_COLOR_TABLE_GREEN_SIZE_EXT
	GL_COLOR_TABLE_INTENSITY_SIZE
	GL_COLOR_TABLE_INTENSITY_SIZE_EXT
	GL_COLOR_TABLE_LUMINANCE_SIZE
	GL_COLOR_TABLE_LUMINANCE_SIZE_EXT
	GL_COLOR_TABLE_RED_SIZE
	GL_COLOR_TABLE_RED_SIZE_EXT
	GL_COLOR_TABLE_SCALE
	GL_COLOR_TABLE_WIDTH
	GL_COLOR_TABLE_WIDTH_EXT
	GL_COLOR_WRITEMASK
	GL_COMBINE
	GL_COMBINE4_NV
	GL_COMBINER0_NV
	GL_COMBINER1_NV
	GL_COMBINER2_NV
	GL_COMBINER3_NV
	GL_COMBINER4_NV
	GL_COMBINER5_NV
	GL_COMBINER6_NV
	GL_COMBINER7_NV
	GL_COMBINER_AB_DOT_PRODUCT_NV
	GL_COMBINER_AB_OUTPUT_NV
	GL_COMBINER_BIAS_NV
	GL_COMBINER_CD_DOT_PRODUCT_NV
	GL_COMBINER_CD_OUTPUT_NV
	GL_COMBINER_COMPONENT_USAGE_NV
	GL_COMBINER_INPUT_NV
	GL_COMBINER_MAPPING_NV
	GL_COMBINER_MUX_SUM_NV
	GL_COMBINER_SCALE_NV
	GL_COMBINER_SUM_OUTPUT_NV
	GL_COMBINE_ALPHA
	GL_COMBINE_ALPHA_ARB
	GL_COMBINE_ALPHA_EXT
	GL_COMBINE_ARB
	GL_COMBINE_EXT
	GL_COMBINE_RGB
	GL_COMBINE_RGB_ARB
	GL_COMBINE_RGB_EXT
	GL_COMPARE_R_TO_TEXTURE
	GL_COMPARE_R_TO_TEXTURE_ARB
	GL_COMPILE
	GL_COMPILE_AND_EXECUTE
	GL_COMPRESSED_ALPHA
	GL_COMPRESSED_ALPHA_ARB
	GL_COMPRESSED_INTENSITY
	GL_COMPRESSED_INTENSITY_ARB
	GL_COMPRESSED_LUMINANCE
	GL_COMPRESSED_LUMINANCE_ALPHA
	GL_COMPRESSED_LUMINANCE_ALPHA_ARB
	GL_COMPRESSED_LUMINANCE_ARB
	GL_COMPRESSED_RGB
	GL_COMPRESSED_RGBA
	GL_COMPRESSED_RGBA_ARB
	GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
	GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
	GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
	GL_COMPRESSED_RGB_ARB
	GL_COMPRESSED_RGB_S3TC_DXT1_EXT
	GL_COMPRESSED_TEXTURE_FORMATS
	GL_COMPRESSED_TEXTURE_FORMATS_ARB
	GL_CONSTANT
	GL_CONSTANT_ALPHA
	GL_CONSTANT_ALPHA_EXT
	GL_CONSTANT_ARB
	GL_CONSTANT_ATTENUATION
	GL_CONSTANT_BORDER
	GL_CONSTANT_COLOR
	GL_CONSTANT_COLOR0_NV
	GL_CONSTANT_COLOR1_NV
	GL_CONSTANT_COLOR_EXT
	GL_CONSTANT_EXT
	GL_CONST_EYE_NV
	GL_CONVOLUTION_1D
	GL_CONVOLUTION_2D
	GL_CONVOLUTION_BORDER_COLOR
	GL_CONVOLUTION_BORDER_MODE
	GL_CONVOLUTION_FILTER_BIAS
	GL_CONVOLUTION_FILTER_SCALE
	GL_CONVOLUTION_FORMAT
	GL_CONVOLUTION_HEIGHT
	GL_CONVOLUTION_WIDTH
	GL_COORD_REPLACE_NV
	GL_COPY
	GL_COPY_INVERTED
	GL_COPY_PIXEL_TOKEN
	GL_CRYCBY_422_NVX
	GL_CULL_FACE
	GL_CULL_FACE_MODE
	GL_CULL_FRAGMENT_NV
	GL_CULL_MODES_NV
	GL_CURRENT_ATTRIB_NV
	GL_CURRENT_BIT
	GL_CURRENT_COLOR
	GL_CURRENT_FLUSHHOLD_NVX
	GL_CURRENT_FOG_COORDINATE
	GL_CURRENT_FOG_COORDINATE_EXT
	GL_CURRENT_INDEX
	GL_CURRENT_MATRIX_ARB
	GL_CURRENT_MATRIX_NV
	GL_CURRENT_MATRIX_STACK_DEPTH_ARB
	GL_CURRENT_MATRIX_STACK_DEPTH_NV
	GL_CURRENT_NORMAL
	GL_CURRENT_OCCLUSION_QUERY_ID_NV
	GL_CURRENT_RASTER_COLOR
	GL_CURRENT_RASTER_DISTANCE
	GL_CURRENT_RASTER_INDEX
	GL_CURRENT_RASTER_POSITION
	GL_CURRENT_RASTER_POSITION_VALID
	GL_CURRENT_RASTER_TEXTURE_COORDS
	GL_CURRENT_SECONDARY_COLOR
	GL_CURRENT_SECONDARY_COLOR_EXT
	GL_CURRENT_TEXTURE_COORDS
	GL_CURRENT_VERTEX_ATTRIB_ARB
	GL_CURRENT_VERTEX_WEIGHT_EXT
	GL_CW
	GL_DECAL
	GL_DECR
	GL_DECR_WRAP
	GL_DECR_WRAP_EXT
	GL_DEPENDENT_AR_TEXTURE_2D_NV
	GL_DEPENDENT_GB_TEXTURE_2D_NV
	GL_DEPENDENT_HILO_TEXTURE_2D_NV
	GL_DEPENDENT_RGB_TEXTURE_3D_NV
	GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
	GL_DEPTH
	GL_DEPTH_BIAS
	GL_DEPTH_BITS
	GL_DEPTH_BOUNDS_NV
	GL_DEPTH_BOUNDS_TEST_NV
	GL_DEPTH_BUFFER_BIT
	GL_DEPTH_CLAMP_NV
	GL_DEPTH_CLEAR_VALUE
	GL_DEPTH_COMPONENT
	GL_DEPTH_COMPONENT16
	GL_DEPTH_COMPONENT16_ARB
	GL_DEPTH_COMPONENT16_SGIX
	GL_DEPTH_COMPONENT24
	GL_DEPTH_COMPONENT24_ARB
	GL_DEPTH_COMPONENT24_SGIX
	GL_DEPTH_COMPONENT32
	GL_DEPTH_COMPONENT32_ARB
	GL_DEPTH_COMPONENT32_SGIX
	GL_DEPTH_FUNC
	GL_DEPTH_RANGE
	GL_DEPTH_SCALE
	GL_DEPTH_STENCIL_NV
	GL_DEPTH_STENCIL_TO_BGRA_NV
	GL_DEPTH_STENCIL_TO_RGBA_NV
	GL_DEPTH_TEST
	GL_DEPTH_TEXTURE_MODE
	GL_DEPTH_TEXTURE_MODE_ARB
	GL_DEPTH_WRITEMASK
	GL_DIFFUSE
	GL_DISCARD_NV
	GL_DISTANCE_ATTENUATION_EXT
	GL_DITHER
	GL_DOMAIN
	GL_DONT_CARE
	GL_DOT3_RGB
	GL_DOT3_RGBA
	GL_DOT3_RGBA_ARB
	GL_DOT3_RGBA_EXT
	GL_DOT3_RGB_ARB
	GL_DOT3_RGB_EXT
	GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
	GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
	GL_DOT_PRODUCT_DEPTH_REPLACE_NV
	GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
	GL_DOT_PRODUCT_NV
	GL_DOT_PRODUCT_PASS_THROUGH_NV
	GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
	GL_DOT_PRODUCT_TEXTURE_1D_NV
	GL_DOT_PRODUCT_TEXTURE_2D_NV
	GL_DOT_PRODUCT_TEXTURE_3D_NV
	GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
	GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
	GL_DOUBLE
	GL_DOUBLEBUFFER
	GL_DOUBLE_EXT
	GL_DRAW_BUFFER
	GL_DRAW_PIXEL_TOKEN
	GL_DSDT8_MAG8_INTENSITY8_NV
	GL_DSDT8_MAG8_NV
	GL_DSDT8_NV
	GL_DSDT_MAG_INTENSITY_NV
	GL_DSDT_MAG_NV
	GL_DSDT_MAG_VIB_NV
	GL_DSDT_NV
	GL_DST_ALPHA
	GL_DST_COLOR
	GL_DS_BIAS_NV
	GL_DS_SCALE_NV
	GL_DT_BIAS_NV
	GL_DT_SCALE_NV
	GL_DYNAMIC_COPY_ARB
	GL_DYNAMIC_DRAW_ARB
	GL_DYNAMIC_READ_ARB
	GL_EDGE_FLAG
	GL_EDGE_FLAG_ARRAY
	GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
	GL_EDGE_FLAG_ARRAY_COUNT_EXT
	GL_EDGE_FLAG_ARRAY_EXT
	GL_EDGE_FLAG_ARRAY_POINTER
	GL_EDGE_FLAG_ARRAY_POINTER_EXT
	GL_EDGE_FLAG_ARRAY_STRIDE
	GL_EDGE_FLAG_ARRAY_STRIDE_EXT
	GL_ELEMENT_ARRAY_BUFFER_ARB
	GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
	GL_EMISSION
	GL_ENABLE_BIT
	GL_EQUAL
	GL_EQUIV
	GL_EVAL_BIT
	GL_EXP
	GL_EXP2
	GL_EXPAND_NEGATE_NV
	GL_EXPAND_NORMAL_NV
	GL_EXTENSIONS
	GL_EYE_LINEAR
	GL_EYE_PLANE
	GL_EYE_PLANE_ABSOLUTE_NV
	GL_EYE_RADIAL_NV
	GL_E_TIMES_F_NV
	GL_FALSE
	GL_FASTEST
	GL_FEEDBACK
	GL_FEEDBACK_BUFFER_POINTER
	GL_FEEDBACK_BUFFER_SIZE
	GL_FEEDBACK_BUFFER_TYPE
	GL_FENCE_CONDITION_NV
	GL_FENCE_STATUS_NV
	GL_FILL
	GL_FLAT
	GL_FLOAT
	GL_FLOAT_CLEAR_COLOR_VALUE_NV
	GL_FLOAT_R16_NV
	GL_FLOAT_R32_NV
	GL_FLOAT_RG16_NV
	GL_FLOAT_RG32_NV
	GL_FLOAT_RGB16_NV
	GL_FLOAT_RGB32_NV
	GL_FLOAT_RGBA16_NV
	GL_FLOAT_RGBA32_NV
	GL_FLOAT_RGBA_MODE_NV
	GL_FLOAT_RGBA_NV
	GL_FLOAT_RGB_NV
	GL_FLOAT_RG_NV
	GL_FLOAT_R_NV
	GL_FOG
	GL_FOG_BIT
	GL_FOG_COLOR
	GL_FOG_COORDINATE
	GL_FOG_COORDINATE_ARRAY
	GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
	GL_FOG_COORDINATE_ARRAY_EXT
	GL_FOG_COORDINATE_ARRAY_POINTER
	GL_FOG_COORDINATE_ARRAY_POINTER_EXT
	GL_FOG_COORDINATE_ARRAY_STRIDE
	GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
	GL_FOG_COORDINATE_ARRAY_TYPE
	GL_FOG_COORDINATE_ARRAY_TYPE_EXT
	GL_FOG_COORDINATE_EXT
	GL_FOG_COORDINATE_SOURCE
	GL_FOG_COORDINATE_SOURCE_EXT
	GL_FOG_DENSITY
	GL_FOG_DISTANCE_MODE_NV
	GL_FOG_END
	GL_FOG_HINT
	GL_FOG_INDEX
	GL_FOG_MODE
	GL_FOG_START
	GL_FORCE_BLUE_TO_ONE_NV
	GL_FORCE_SOFTWARE_NV
	GL_FRAGMENT_DEPTH
	GL_FRAGMENT_DEPTH_EXT
	GL_FRAGMENT_PROGRAM_ARB
	GL_FRAGMENT_PROGRAM_BINDING_NV
	GL_FRAGMENT_PROGRAM_NV
	GL_FRONT
	GL_FRONT_AND_BACK
	GL_FRONT_FACE
	GL_FRONT_LEFT
	GL_FRONT_RIGHT
	GL_FUNC_ADD
	GL_FUNC_ADD_EXT
	GL_FUNC_REVERSE_SUBTRACT
	GL_FUNC_REVERSE_SUBTRACT_EXT
	GL_FUNC_SUBTRACT
	GL_FUNC_SUBTRACT_EXT
	GL_GENERATE_MIPMAP
	GL_GENERATE_MIPMAP_HINT
	GL_GENERATE_MIPMAP_HINT_SGIS
	GL_GENERATE_MIPMAP_SGIS
	GL_GEQUAL
	GL_GREATER
	GL_GREEN
	GL_GREEN_BIAS
	GL_GREEN_BITS
	GL_GREEN_SCALE
	GL_HALF_BIAS_NEGATE_NV
	GL_HALF_BIAS_NORMAL_NV
	GL_HALF_FLOAT_NV
	GL_HILO16_NV
	GL_HILO8_NV
	GL_HILO_NV
	GL_HINT_BIT
	GL_HISTOGRAM
	GL_HISTOGRAM_ALPHA_SIZE
	GL_HISTOGRAM_BLUE_SIZE
	GL_HISTOGRAM_FORMAT
	GL_HISTOGRAM_GREEN_SIZE
	GL_HISTOGRAM_LUMINANCE_SIZE
	GL_HISTOGRAM_RED_SIZE
	GL_HISTOGRAM_SINK
	GL_HISTOGRAM_WIDTH
	GL_HI_BIAS_NV
	GL_HI_SCALE_NV
	GL_IDENTITY_NV
	GL_IGNORE_BORDER
	GL_INCR
	GL_INCR_WRAP
	GL_INCR_WRAP_EXT
	GL_INDEX_ARRAY
	GL_INDEX_ARRAY_BUFFER_BINDING_ARB
	GL_INDEX_ARRAY_COUNT_EXT
	GL_INDEX_ARRAY_EXT
	GL_INDEX_ARRAY_POINTER
	GL_INDEX_ARRAY_POINTER_EXT
	GL_INDEX_ARRAY_STRIDE
	GL_INDEX_ARRAY_STRIDE_EXT
	GL_INDEX_ARRAY_TYPE
	GL_INDEX_ARRAY_TYPE_EXT
	GL_INDEX_BITS
	GL_INDEX_CLEAR_VALUE
	GL_INDEX_LOGIC_OP
	GL_INDEX_MODE
	GL_INDEX_OFFSET
	GL_INDEX_SHIFT
	GL_INDEX_WRITEMASK
	GL_INT
	GL_INTENSITY
	GL_INTENSITY12
	GL_INTENSITY16
	GL_INTENSITY4
	GL_INTENSITY8
	GL_INTERPOLATE
	GL_INTERPOLATE_ARB
	GL_INTERPOLATE_EXT
	GL_INVALID_ENUM
	GL_INVALID_OPERATION
	GL_INVALID_VALUE
	GL_INVERSE_NV
	GL_INVERSE_TRANSPOSE_NV
	GL_INVERT
	GL_KEEP
	GL_LEFT
	GL_LEQUAL
	GL_LESS
	GL_LIGHT0
	GL_LIGHT1
	GL_LIGHT2
	GL_LIGHT3
	GL_LIGHT4
	GL_LIGHT5
	GL_LIGHT6
	GL_LIGHT7
	GL_LIGHTING
	GL_LIGHTING_BIT
	GL_LIGHT_MODEL_AMBIENT
	GL_LIGHT_MODEL_COLOR_CONTROL
	GL_LIGHT_MODEL_COLOR_CONTROL_EXT
	GL_LIGHT_MODEL_LOCAL_VIEWER
	GL_LIGHT_MODEL_TWO_SIDE
	GL_LINE
	GL_LINEAR
	GL_LINEAR_ATTENUATION
	GL_LINEAR_MIPMAP_LINEAR
	GL_LINEAR_MIPMAP_NEAREST
	GL_LINES
	GL_LINE_BIT
	GL_LINE_LOOP
	GL_LINE_RESET_TOKEN
	GL_LINE_SMOOTH
	GL_LINE_SMOOTH_HINT
	GL_LINE_STIPPLE
	GL_LINE_STIPPLE_PATTERN
	GL_LINE_STIPPLE_REPEAT
	GL_LINE_STRIP
	GL_LINE_TOKEN
	GL_LINE_WIDTH
	GL_LINE_WIDTH_GRANULARITY
	GL_LINE_WIDTH_RANGE
	GL_LIST_BASE
	GL_LIST_BIT
	GL_LIST_INDEX
	GL_LIST_MODE
	GL_LOAD
	GL_LOGIC_OP
	GL_LOGIC_OP_MODE
	GL_LO_BIAS_NV
	GL_LO_SCALE_NV
	GL_LUMINANCE
	GL_LUMINANCE12
	GL_LUMINANCE12_ALPHA12
	GL_LUMINANCE12_ALPHA4
	GL_LUMINANCE16
	GL_LUMINANCE16_ALPHA16
	GL_LUMINANCE4
	GL_LUMINANCE4_ALPHA4
	GL_LUMINANCE6_ALPHA2
	GL_LUMINANCE8
	GL_LUMINANCE8_ALPHA8
	GL_LUMINANCE_ALPHA
	GL_MAC_GET_PROC_ADDRESS_NV
	GL_MAGNITUDE_BIAS_NV
	GL_MAGNITUDE_SCALE_NV
	GL_MAP1_COLOR_4
	GL_MAP1_GRID_DOMAIN
	GL_MAP1_GRID_SEGMENTS
	GL_MAP1_INDEX
	GL_MAP1_NORMAL
	GL_MAP1_TEXTURE_COORD_1
	GL_MAP1_TEXTURE_COORD_2
	GL_MAP1_TEXTURE_COORD_3
	GL_MAP1_TEXTURE_COORD_4
	GL_MAP1_VERTEX_3
	GL_MAP1_VERTEX_4
	GL_MAP1_VERTEX_ATTRIB0_4_NV
	GL_MAP1_VERTEX_ATTRIB10_4_NV
	GL_MAP1_VERTEX_ATTRIB11_4_NV
	GL_MAP1_VERTEX_ATTRIB12_4_NV
	GL_MAP1_VERTEX_ATTRIB13_4_NV
	GL_MAP1_VERTEX_ATTRIB14_4_NV
	GL_MAP1_VERTEX_ATTRIB15_4_NV
	GL_MAP1_VERTEX_ATTRIB1_4_NV
	GL_MAP1_VERTEX_ATTRIB2_4_NV
	GL_MAP1_VERTEX_ATTRIB3_4_NV
	GL_MAP1_VERTEX_ATTRIB4_4_NV
	GL_MAP1_VERTEX_ATTRIB5_4_NV
	GL_MAP1_VERTEX_ATTRIB6_4_NV
	GL_MAP1_VERTEX_ATTRIB7_4_NV
	GL_MAP1_VERTEX_ATTRIB8_4_NV
	GL_MAP1_VERTEX_ATTRIB9_4_NV
	GL_MAP2_COLOR_4
	GL_MAP2_GRID_DOMAIN
	GL_MAP2_GRID_SEGMENTS
	GL_MAP2_INDEX
	GL_MAP2_NORMAL
	GL_MAP2_TEXTURE_COORD_1
	GL_MAP2_TEXTURE_COORD_2
	GL_MAP2_TEXTURE_COORD_3
	GL_MAP2_TEXTURE_COORD_4
	GL_MAP2_VERTEX_3
	GL_MAP2_VERTEX_4
	GL_MAP2_VERTEX_ATTRIB0_4_NV
	GL_MAP2_VERTEX_ATTRIB10_4_NV
	GL_MAP2_VERTEX_ATTRIB11_4_NV
	GL_MAP2_VERTEX_ATTRIB12_4_NV
	GL_MAP2_VERTEX_ATTRIB13_4_NV
	GL_MAP2_VERTEX_ATTRIB14_4_NV
	GL_MAP2_VERTEX_ATTRIB15_4_NV
	GL_MAP2_VERTEX_ATTRIB1_4_NV
	GL_MAP2_VERTEX_ATTRIB2_4_NV
	GL_MAP2_VERTEX_ATTRIB3_4_NV
	GL_MAP2_VERTEX_ATTRIB4_4_NV
	GL_MAP2_VERTEX_ATTRIB5_4_NV
	GL_MAP2_VERTEX_ATTRIB6_4_NV
	GL_MAP2_VERTEX_ATTRIB7_4_NV
	GL_MAP2_VERTEX_ATTRIB8_4_NV
	GL_MAP2_VERTEX_ATTRIB9_4_NV
	GL_MAP_COLOR
	GL_MAP_STENCIL
	GL_MATRIX0_ARB
	GL_MATRIX0_NV
	GL_MATRIX10_ARB
	GL_MATRIX11_ARB
	GL_MATRIX12_ARB
	GL_MATRIX13_ARB
	GL_MATRIX14_ARB
	GL_MATRIX15_ARB
	GL_MATRIX16_ARB
	GL_MATRIX17_ARB
	GL_MATRIX18_ARB
	GL_MATRIX19_ARB
	GL_MATRIX1_ARB
	GL_MATRIX1_NV
	GL_MATRIX20_ARB
	GL_MATRIX21_ARB
	GL_MATRIX22_ARB
	GL_MATRIX23_ARB
	GL_MATRIX24_ARB
	GL_MATRIX25_ARB
	GL_MATRIX26_ARB
	GL_MATRIX27_ARB
	GL_MATRIX28_ARB
	GL_MATRIX29_ARB
	GL_MATRIX2_ARB
	GL_MATRIX2_NV
	GL_MATRIX30_ARB
	GL_MATRIX31_ARB
	GL_MATRIX3_ARB
	GL_MATRIX3_NV
	GL_MATRIX4_ARB
	GL_MATRIX4_NV
	GL_MATRIX5_ARB
	GL_MATRIX5_NV
	GL_MATRIX6_ARB
	GL_MATRIX6_NV
	GL_MATRIX7_ARB
	GL_MATRIX7_NV
	GL_MATRIX8_ARB
	GL_MATRIX9_ARB
	GL_MATRIX_MODE
	GL_MAX
	GL_MAX_3D_TEXTURE_SIZE
	GL_MAX_3D_TEXTURE_SIZE_EXT
	GL_MAX_ATTRIB_STACK_DEPTH
	GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
	GL_MAX_CLIP_PLANES
	GL_MAX_COLOR_MATRIX_STACK_DEPTH
	GL_MAX_CONVOLUTION_HEIGHT
	GL_MAX_CONVOLUTION_WIDTH
	GL_MAX_CUBE_MAP_TEXTURE_SIZE
	GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
	GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT
	GL_MAX_ELEMENTS_INDICES
	GL_MAX_ELEMENTS_INDICES_EXT
	GL_MAX_ELEMENTS_VERTICES
	GL_MAX_ELEMENTS_VERTICES_EXT
	GL_MAX_EVAL_ORDER
	GL_MAX_EXT
	GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
	GL_MAX_GENERAL_COMBINERS_NV
	GL_MAX_LIGHTS
	GL_MAX_LIST_NESTING
	GL_MAX_MODELVIEW_STACK_DEPTH
	GL_MAX_NAME_STACK_DEPTH
	GL_MAX_PENDING_FLUSHHOLD_NVX
	GL_MAX_PIXEL_MAP_TABLE
	GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
	GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
	GL_MAX_PROGRAM_ATTRIBS_ARB
	GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
	GL_MAX_PROGRAM_INSTRUCTIONS_ARB
	GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
	GL_MAX_PROGRAM_MATRICES_ARB
	GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
	GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
	GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
	GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
	GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
	GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
	GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
	GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
	GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
	GL_MAX_PROGRAM_PARAMETERS_ARB
	GL_MAX_PROGRAM_TEMPORARIES_ARB
	GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
	GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
	GL_MAX_PROJECTION_STACK_DEPTH
	GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
	GL_MAX_SHININESS_NV
	GL_MAX_SPOT_EXPONENT_NV
	GL_MAX_TEXTURES_SGIS
	GL_MAX_TEXTURE_COORDS_ARB
	GL_MAX_TEXTURE_COORDS_NV
	GL_MAX_TEXTURE_IMAGE_UNITS_ARB
	GL_MAX_TEXTURE_IMAGE_UNITS_NV
	GL_MAX_TEXTURE_LOD_BIAS
	GL_MAX_TEXTURE_LOD_BIAS_EXT
	GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
	GL_MAX_TEXTURE_SIZE
	GL_MAX_TEXTURE_STACK_DEPTH
	GL_MAX_TEXTURE_UNITS
	GL_MAX_TEXTURE_UNITS_ARB
	GL_MAX_TRACK_MATRICES_NV
	GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
	GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
	GL_MAX_VERTEX_ATTRIBS_ARB
	GL_MAX_VIEWPORT_DIMS
	GL_MIN
	GL_MINMAX
	GL_MINMAX_FORMAT
	GL_MINMAX_SINK
	GL_MIN_EXT
	GL_MIRRORED_REPEAT
	GL_MIRRORED_REPEAT_ARB
	GL_MIRRORED_REPEAT_IBM
	GL_MODELVIEW
	GL_MODELVIEW0_EXT
	GL_MODELVIEW0_MATRIX_EXT
	GL_MODELVIEW0_STACK_DEPTH_EXT
	GL_MODELVIEW1_EXT
	GL_MODELVIEW1_MATRIX_EXT
	GL_MODELVIEW1_STACK_DEPTH_EXT
	GL_MODELVIEW_MATRIX
	GL_MODELVIEW_PROJECTION_NV
	GL_MODELVIEW_STACK_DEPTH
	GL_MODULATE
	GL_MULT
	GL_MULTISAMPLE
	GL_MULTISAMPLE_ARB
	GL_MULTISAMPLE_BIT
	GL_MULTISAMPLE_BIT_ARB
	GL_MULTISAMPLE_FILTER_HINT_NV
	GL_N3F_V3F
	GL_NAME_STACK_DEPTH
	GL_NAND
	GL_NEAREST
	GL_NEAREST_MIPMAP_LINEAR
	GL_NEAREST_MIPMAP_NEAREST
	GL_NEVER
	GL_NICEST
	GL_NONE
	GL_NOOP
	GL_NOR
	GL_NORMALIZE
	GL_NORMAL_ARRAY
	GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
	GL_NORMAL_ARRAY_COUNT_EXT
	GL_NORMAL_ARRAY_EXT
	GL_NORMAL_ARRAY_POINTER
	GL_NORMAL_ARRAY_POINTER_EXT
	GL_NORMAL_ARRAY_STRIDE
	GL_NORMAL_ARRAY_STRIDE_EXT
	GL_NORMAL_ARRAY_TYPE
	GL_NORMAL_ARRAY_TYPE_EXT
	GL_NORMAL_MAP
	GL_NORMAL_MAP_ARB
	GL_NORMAL_MAP_EXT
	GL_NORMAL_MAP_NV
	GL_NOTEQUAL
	GL_NO_ERROR
	GL_NUM_COMPRESSED_TEXTURE_FORMATS
	GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
	GL_NUM_GENERAL_COMBINERS_NV
	GL_OBJECT_LINEAR
	GL_OBJECT_PLANE
	GL_OCCLUSION_TEST_HP
	GL_OCCLUSION_TEST_RESULT_HP
	GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
	GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
	GL_OFFSET_HILO_TEXTURE_2D_NV
	GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
	GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
	GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
	GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
	GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
	GL_OFFSET_TEXTURE_2D_BIAS_NV
	GL_OFFSET_TEXTURE_2D_MATRIX_NV
	GL_OFFSET_TEXTURE_2D_NV
	GL_OFFSET_TEXTURE_2D_SCALE_NV
	GL_OFFSET_TEXTURE_BIAS_NV
	GL_OFFSET_TEXTURE_MATRIX_NV
	GL_OFFSET_TEXTURE_RECTANGLE_NV
	GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
	GL_OFFSET_TEXTURE_SCALE_NV
	GL_ONE
	GL_ONE_MINUS_CONSTANT_ALPHA
	GL_ONE_MINUS_CONSTANT_ALPHA_EXT
	GL_ONE_MINUS_CONSTANT_COLOR
	GL_ONE_MINUS_CONSTANT_COLOR_EXT
	GL_ONE_MINUS_DST_ALPHA
	GL_ONE_MINUS_DST_COLOR
	GL_ONE_MINUS_SRC_ALPHA
	GL_ONE_MINUS_SRC_COLOR
	GL_OPERAND0_ALPHA
	GL_OPERAND0_ALPHA_ARB
	GL_OPERAND0_ALPHA_EXT
	GL_OPERAND0_RGB
	GL_OPERAND0_RGB_ARB
	GL_OPERAND0_RGB_EXT
	GL_OPERAND1_ALPHA
	GL_OPERAND1_ALPHA_ARB
	GL_OPERAND1_ALPHA_EXT
	GL_OPERAND1_RGB
	GL_OPERAND1_RGB_ARB
	GL_OPERAND1_RGB_EXT
	GL_OPERAND2_ALPHA
	GL_OPERAND2_ALPHA_ARB
	GL_OPERAND2_ALPHA_EXT
	GL_OPERAND2_RGB
	GL_OPERAND2_RGB_ARB
	GL_OPERAND2_RGB_EXT
	GL_OPERAND3_ALPHA_NV
	GL_OPERAND3_RGB_NV
	GL_OR
	GL_ORDER
	GL_OR_INVERTED
	GL_OR_REVERSE
	GL_OUT_OF_MEMORY
	GL_PACK_ALIGNMENT
	GL_PACK_IMAGE_HEIGHT
	GL_PACK_IMAGE_HEIGHT_EXT
	GL_PACK_LSB_FIRST
	GL_PACK_ROW_LENGTH
	GL_PACK_SKIP_IMAGES
	GL_PACK_SKIP_IMAGES_EXT
	GL_PACK_SKIP_PIXELS
	GL_PACK_SKIP_ROWS
	GL_PACK_SWAP_BYTES
	GL_PASS_THROUGH_NV
	GL_PASS_THROUGH_TOKEN
	GL_PERSPECTIVE_CORRECTION_HINT
	GL_PER_STAGE_CONSTANTS_NV
	GL_PIXEL_COUNTER_BITS_NV
	GL_PIXEL_COUNT_AVAILABLE_NV
	GL_PIXEL_COUNT_NV
	GL_PIXEL_MAP_A_TO_A
	GL_PIXEL_MAP_A_TO_A_SIZE
	GL_PIXEL_MAP_B_TO_B
	GL_PIXEL_MAP_B_TO_B_SIZE
	GL_PIXEL_MAP_G_TO_G
	GL_PIXEL_MAP_G_TO_G_SIZE
	GL_PIXEL_MAP_I_TO_A
	GL_PIXEL_MAP_I_TO_A_SIZE
	GL_PIXEL_MAP_I_TO_B
	GL_PIXEL_MAP_I_TO_B_SIZE
	GL_PIXEL_MAP_I_TO_G
	GL_PIXEL_MAP_I_TO_G_SIZE
	GL_PIXEL_MAP_I_TO_I
	GL_PIXEL_MAP_I_TO_I_SIZE
	GL_PIXEL_MAP_I_TO_R
	GL_PIXEL_MAP_I_TO_R_SIZE
	GL_PIXEL_MAP_R_TO_R
	GL_PIXEL_MAP_R_TO_R_SIZE
	GL_PIXEL_MAP_S_TO_S
	GL_PIXEL_MAP_S_TO_S_SIZE
	GL_PIXEL_MODE_BIT
	GL_POINT
	GL_POINTS
	GL_POINT_BIT
	GL_POINT_DISTANCE_ATTENUATION
	GL_POINT_DISTANCE_ATTENUATION_ARB
	GL_POINT_FADE_THRESHOLD_SIZE
	GL_POINT_FADE_THRESHOLD_SIZE_ARB
	GL_POINT_FADE_THRESHOLD_SIZE_EXT
	GL_POINT_SIZE
	GL_POINT_SIZE_GRANULARITY
	GL_POINT_SIZE_MAX
	GL_POINT_SIZE_MAX_ARB
	GL_POINT_SIZE_MAX_EXT
	GL_POINT_SIZE_MIN
	GL_POINT_SIZE_MIN_ARB
	GL_POINT_SIZE_MIN_EXT
	GL_POINT_SIZE_RANGE
	GL_POINT_SMOOTH
	GL_POINT_SMOOTH_HINT
	GL_POINT_SPRITE_NV
	GL_POINT_SPRITE_R_MODE_NV
	GL_POINT_TOKEN
	GL_POLYGON
	GL_POLYGON_BIT
	GL_POLYGON_MODE
	GL_POLYGON_OFFSET_FACTOR
	GL_POLYGON_OFFSET_FILL
	GL_POLYGON_OFFSET_LINE
	GL_POLYGON_OFFSET_POINT
	GL_POLYGON_OFFSET_UNITS
	GL_POLYGON_SMOOTH
	GL_POLYGON_SMOOTH_HINT
	GL_POLYGON_STIPPLE
	GL_POLYGON_STIPPLE_BIT
	GL_POLYGON_TOKEN
	GL_POSITION
	GL_POST_COLOR_MATRIX_ALPHA_BIAS
	GL_POST_COLOR_MATRIX_ALPHA_SCALE
	GL_POST_COLOR_MATRIX_BLUE_BIAS
	GL_POST_COLOR_MATRIX_BLUE_SCALE
	GL_POST_COLOR_MATRIX_COLOR_TABLE
	GL_POST_COLOR_MATRIX_GREEN_BIAS
	GL_POST_COLOR_MATRIX_GREEN_SCALE
	GL_POST_COLOR_MATRIX_RED_BIAS
	GL_POST_COLOR_MATRIX_RED_SCALE
	GL_POST_CONVOLUTION_ALPHA_BIAS
	GL_POST_CONVOLUTION_ALPHA_SCALE
	GL_POST_CONVOLUTION_BLUE_BIAS
	GL_POST_CONVOLUTION_BLUE_SCALE
	GL_POST_CONVOLUTION_COLOR_TABLE
	GL_POST_CONVOLUTION_GREEN_BIAS
	GL_POST_CONVOLUTION_GREEN_SCALE
	GL_POST_CONVOLUTION_RED_BIAS
	GL_POST_CONVOLUTION_RED_SCALE
	GL_PREVIOUS
	GL_PREVIOUS_ARB
	GL_PREVIOUS_EXT
	GL_PREVIOUS_TEXTURE_INPUT_NV
	GL_PRIMARY_COLOR
	GL_PRIMARY_COLOR_ARB
	GL_PRIMARY_COLOR_EXT
	GL_PRIMARY_COLOR_NV
	GL_PRIMITIVE_RESTART_INDEX_NV
	GL_PRIMITIVE_RESTART_NV
	GL_PROGRAM_ADDRESS_REGISTERS_ARB
	GL_PROGRAM_ALU_INSTRUCTIONS_ARB
	GL_PROGRAM_ATTRIBS_ARB
	GL_PROGRAM_BINDING_ARB
	GL_PROGRAM_ERROR_POSITION_ARB
	GL_PROGRAM_ERROR_POSITION_NV
	GL_PROGRAM_ERROR_STRING_ARB
	GL_PROGRAM_ERROR_STRING_NV
	GL_PROGRAM_FORMAT_ARB
	GL_PROGRAM_FORMAT_ASCII_ARB
	GL_PROGRAM_INSTRUCTIONS_ARB
	GL_PROGRAM_LENGTH_ARB
	GL_PROGRAM_LENGTH_NV
	GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
	GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
	GL_PROGRAM_NATIVE_ATTRIBS_ARB
	GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
	GL_PROGRAM_NATIVE_PARAMETERS_ARB
	GL_PROGRAM_NATIVE_TEMPORARIES_ARB
	GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
	GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
	GL_PROGRAM_PARAMETERS_ARB
	GL_PROGRAM_PARAMETER_NV
	GL_PROGRAM_RESIDENT_NV
	GL_PROGRAM_STRING_ARB
	GL_PROGRAM_STRING_NV
	GL_PROGRAM_TARGET_NV
	GL_PROGRAM_TEMPORARIES_ARB
	GL_PROGRAM_TEX_INDIRECTIONS_ARB
	GL_PROGRAM_TEX_INSTRUCTIONS_ARB
	GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
	GL_PROJECTION
	GL_PROJECTION_MATRIX
	GL_PROJECTION_STACK_DEPTH
	GL_PROXY_COLOR_TABLE
	GL_PROXY_HISTOGRAM
	GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
	GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
	GL_PROXY_TEXTURE_1D
	GL_PROXY_TEXTURE_2D
	GL_PROXY_TEXTURE_3D
	GL_PROXY_TEXTURE_3D_EXT
	GL_PROXY_TEXTURE_CUBE_MAP
	GL_PROXY_TEXTURE_CUBE_MAP_ARB
	GL_PROXY_TEXTURE_CUBE_MAP_EXT
	GL_PROXY_TEXTURE_RECTANGLE_NV
	GL_Q
	GL_QUADRATIC_ATTENUATION
	GL_QUADS
	GL_QUAD_STRIP
	GL_R
	GL_R3_G3_B2
	GL_READ_BUFFER
	GL_READ_ONLY_ARB
	GL_READ_PIXEL_DATA_RANGE_LENGTH_NV
	GL_READ_PIXEL_DATA_RANGE_NV
	GL_READ_PIXEL_DATA_RANGE_POINTER_NV
	GL_READ_WRITE_ARB
	GL_RED
	GL_REDUCE
	GL_RED_BIAS
	GL_RED_BITS
	GL_RED_SCALE
	GL_REFLECTION_MAP
	GL_REFLECTION_MAP_ARB
	GL_REFLECTION_MAP_EXT
	GL_REFLECTION_MAP_NV
	GL_REGISTER_COMBINERS_NV
	GL_RENDER
	GL_RENDERER
	GL_RENDER_MODE
	GL_REPEAT
	GL_REPLACE
	GL_REPLICATE_BORDER
	GL_RESCALE_NORMAL
	GL_RESCALE_NORMAL_EXT
	GL_RETURN
	GL_RGB
	GL_RGB10
	GL_RGB10_A2
	GL_RGB12
	GL_RGB16
	GL_RGB4
	GL_RGB4_S3TC
	GL_RGB5
	GL_RGB5_A1
	GL_RGB8
	GL_RGBA
	GL_RGBA12
	GL_RGBA16
	GL_RGBA2
	GL_RGBA4
	GL_RGBA4_DXT5_S3TC
	GL_RGBA4_S3TC
	GL_RGBA8
	GL_RGBA_DXT5_S3TC
	GL_RGBA_MODE
	GL_RGBA_S3TC
	GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
	GL_RGB_S3TC
	GL_RGB_SCALE
	GL_RGB_SCALE_ARB
	GL_RGB_SCALE_EXT
	GL_RIGHT
	GL_S
	GL_SAMPLES
	GL_SAMPLES_ARB
	GL_SAMPLE_ALPHA_TO_COVERAGE
	GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
	GL_SAMPLE_ALPHA_TO_ONE
	GL_SAMPLE_ALPHA_TO_ONE_ARB
	GL_SAMPLE_BUFFERS
	GL_SAMPLE_BUFFERS_ARB
	GL_SAMPLE_COVERAGE
	GL_SAMPLE_COVERAGE_ARB
	GL_SAMPLE_COVERAGE_INVERT
	GL_SAMPLE_COVERAGE_INVERT_ARB
	GL_SAMPLE_COVERAGE_VALUE
	GL_SAMPLE_COVERAGE_VALUE_ARB
	GL_SCALE_BY_FOUR_NV
	GL_SCALE_BY_ONE_HALF_NV
	GL_SCALE_BY_TWO_NV
	GL_SCISSOR_BIT
	GL_SCISSOR_BOX
	GL_SCISSOR_TEST
	GL_SECONDARY_COLOR_ARRAY
	GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
	GL_SECONDARY_COLOR_ARRAY_EXT
	GL_SECONDARY_COLOR_ARRAY_POINTER
	GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
	GL_SECONDARY_COLOR_ARRAY_SIZE
	GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
	GL_SECONDARY_COLOR_ARRAY_STRIDE
	GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
	GL_SECONDARY_COLOR_ARRAY_TYPE
	GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
	GL_SECONDARY_COLOR_NV
	GL_SELECT
	GL_SELECTED_TEXTURE_SGIS
	GL_SELECTION_BUFFER_POINTER
	GL_SELECTION_BUFFER_SIZE
	GL_SEPARABLE_2D
	GL_SEPARATE_SPECULAR_COLOR
	GL_SEPARATE_SPECULAR_COLOR_EXT
	GL_SET
	GL_SHADER_CONSISTENT_NV
	GL_SHADER_OPERATION_NV
	GL_SHADE_MODEL
	GL_SHARED_TEXTURE_PALETTE_EXT
	GL_SHININESS
	GL_SHORT
	GL_SIGNED_ALPHA8_NV
	GL_SIGNED_ALPHA_NV
	GL_SIGNED_HILO16_NV
	GL_SIGNED_HILO8_NV
	GL_SIGNED_HILO_NV
	GL_SIGNED_IDENTITY_NV
	GL_SIGNED_INTENSITY8_NV
	GL_SIGNED_INTENSITY_NV
	GL_SIGNED_LUMINANCE8_ALPHA8_NV
	GL_SIGNED_LUMINANCE8_NV
	GL_SIGNED_LUMINANCE_ALPHA_NV
	GL_SIGNED_LUMINANCE_NV
	GL_SIGNED_NEGATE_NV
	GL_SIGNED_RGB8_NV
	GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
	GL_SIGNED_RGBA8_NV
	GL_SIGNED_RGBA_NV
	GL_SIGNED_RGB_NV
	GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
	GL_SINGLE_COLOR
	GL_SINGLE_COLOR_EXT
	GL_SMOOTH
	GL_SMOOTH_LINE_WIDTH_GRANULARITY
	GL_SMOOTH_LINE_WIDTH_RANGE
	GL_SMOOTH_POINT_SIZE_GRANULARITY
	GL_SMOOTH_POINT_SIZE_RANGE
	GL_SOURCE0_ALPHA
	GL_SOURCE0_ALPHA_ARB
	GL_SOURCE0_ALPHA_EXT
	GL_SOURCE0_RGB
	GL_SOURCE0_RGB_ARB
	GL_SOURCE0_RGB_EXT
	GL_SOURCE1_ALPHA
	GL_SOURCE1_ALPHA_ARB
	GL_SOURCE1_ALPHA_EXT
	GL_SOURCE1_RGB
	GL_SOURCE1_RGB_ARB
	GL_SOURCE1_RGB_EXT
	GL_SOURCE2_ALPHA
	GL_SOURCE2_ALPHA_ARB
	GL_SOURCE2_ALPHA_EXT
	GL_SOURCE2_RGB
	GL_SOURCE2_RGB_ARB
	GL_SOURCE2_RGB_EXT
	GL_SOURCE3_ALPHA_NV
	GL_SOURCE3_RGB_NV
	GL_SPARE0_NV
	GL_SPARE0_PLUS_SECONDARY_COLOR_NV
	GL_SPARE1_NV
	GL_SPECULAR
	GL_SPHERE_MAP
	GL_SPOT_CUTOFF
	GL_SPOT_DIRECTION
	GL_SPOT_EXPONENT
	GL_SRC_ALPHA
	GL_SRC_ALPHA_SATURATE
	GL_SRC_COLOR
	GL_STACK_OVERFLOW
	GL_STACK_UNDERFLOW
	GL_STATIC_COPY_ARB
	GL_STATIC_DRAW_ARB
	GL_STATIC_READ_ARB
	GL_STENCIL
	GL_STENCIL_BITS
	GL_STENCIL_BUFFER_BIT
	GL_STENCIL_CLEAR_VALUE
	GL_STENCIL_FAIL
	GL_STENCIL_FUNC
	GL_STENCIL_INDEX
	GL_STENCIL_PASS_DEPTH_FAIL
	GL_STENCIL_PASS_DEPTH_PASS
	GL_STENCIL_REF
	GL_STENCIL_TEST
	GL_STENCIL_TEST_TWO_SIDE_EXT
	GL_STENCIL_VALUE_MASK
	GL_STENCIL_WRITEMASK
	GL_STEREO
	GL_STREAM_COPY_ARB
	GL_STREAM_DRAW_ARB
	GL_STREAM_READ_ARB
	GL_SUBPIXEL_BITS
	GL_SUBTRACT
	GL_SUBTRACT_ARB
	GL_T
	GL_T2F_C3F_V3F
	GL_T2F_C4F_N3F_V3F
	GL_T2F_C4UB_V3F
	GL_T2F_N3F_V3F
	GL_T2F_V3F
	GL_T4F_C4F_N3F_V4F
	GL_T4F_V4F
	GL_TABLE_TOO_LARGE
	GL_TABLE_TOO_LARGE_EXT
	GL_TBUFFER_WRITE_MASK_3DFX
	GL_TEXTURE
	GL_TEXTURE0
	GL_TEXTURE0_ARB
	GL_TEXTURE0_SGIS
	GL_TEXTURE1
	GL_TEXTURE10
	GL_TEXTURE10_ARB
	GL_TEXTURE11
	GL_TEXTURE11_ARB
	GL_TEXTURE12
	GL_TEXTURE12_ARB
	GL_TEXTURE13
	GL_TEXTURE13_ARB
	GL_TEXTURE14
	GL_TEXTURE14_ARB
	GL_TEXTURE15
	GL_TEXTURE15_ARB
	GL_TEXTURE16
	GL_TEXTURE16_ARB
	GL_TEXTURE17
	GL_TEXTURE17_ARB
	GL_TEXTURE18
	GL_TEXTURE18_ARB
	GL_TEXTURE19
	GL_TEXTURE19_ARB
	GL_TEXTURE1_ARB
	GL_TEXTURE1_SGIS
	GL_TEXTURE2
	GL_TEXTURE20
	GL_TEXTURE20_ARB
	GL_TEXTURE21
	GL_TEXTURE21_ARB
	GL_TEXTURE22
	GL_TEXTURE22_ARB
	GL_TEXTURE23
	GL_TEXTURE23_ARB
	GL_TEXTURE24
	GL_TEXTURE24_ARB
	GL_TEXTURE25
	GL_TEXTURE25_ARB
	GL_TEXTURE26
	GL_TEXTURE26_ARB
	GL_TEXTURE27
	GL_TEXTURE27_ARB
	GL_TEXTURE28
	GL_TEXTURE28_ARB
	GL_TEXTURE29
	GL_TEXTURE29_ARB
	GL_TEXTURE2_ARB
	GL_TEXTURE2_SGIS
	GL_TEXTURE3
	GL_TEXTURE30
	GL_TEXTURE30_ARB
	GL_TEXTURE31
	GL_TEXTURE31_ARB
	GL_TEXTURE3_ARB
	GL_TEXTURE3_SGIS
	GL_TEXTURE4
	GL_TEXTURE4_ARB
	GL_TEXTURE5
	GL_TEXTURE5_ARB
	GL_TEXTURE6
	GL_TEXTURE6_ARB
	GL_TEXTURE7
	GL_TEXTURE7_ARB
	GL_TEXTURE8
	GL_TEXTURE8_ARB
	GL_TEXTURE9
	GL_TEXTURE9_ARB
	GL_TEXTURE_1D
	GL_TEXTURE_2D
	GL_TEXTURE_3D
	GL_TEXTURE_3D_EXT
	GL_TEXTURE_ALPHA_SIZE
	GL_TEXTURE_BASE_LEVEL
	GL_TEXTURE_BASE_LEVEL_SGIS
	GL_TEXTURE_BINDING_1D
	GL_TEXTURE_BINDING_2D
	GL_TEXTURE_BINDING_3D
	GL_TEXTURE_BINDING_CUBE_MAP
	GL_TEXTURE_BINDING_CUBE_MAP_ARB
	GL_TEXTURE_BINDING_CUBE_MAP_EXT
	GL_TEXTURE_BINDING_RECTANGLE_NV
	GL_TEXTURE_BIT
	GL_TEXTURE_BLUE_SIZE
	GL_TEXTURE_BORDER
	GL_TEXTURE_BORDER_COLOR
	GL_TEXTURE_BORDER_VALUES_NV
	GL_TEXTURE_COLOR_WRITEMASK_SGIS
	GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
	GL_TEXTURE_COMPARE_FUNC
	GL_TEXTURE_COMPARE_FUNC_ARB
	GL_TEXTURE_COMPARE_MODE
	GL_TEXTURE_COMPARE_MODE_ARB
	GL_TEXTURE_COMPARE_OPERATOR_SGIX
	GL_TEXTURE_COMPARE_SGIX
	GL_TEXTURE_COMPONENTS
	GL_TEXTURE_COMPRESSED
	GL_TEXTURE_COMPRESSED_ARB
	GL_TEXTURE_COMPRESSED_IMAGE_SIZE
	GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
	GL_TEXTURE_COMPRESSION_HINT
	GL_TEXTURE_COMPRESSION_HINT_ARB
	GL_TEXTURE_COORD_ARRAY
	GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
	GL_TEXTURE_COORD_ARRAY_COUNT_EXT
	GL_TEXTURE_COORD_ARRAY_EXT
	GL_TEXTURE_COORD_ARRAY_POINTER
	GL_TEXTURE_COORD_ARRAY_POINTER_EXT
	GL_TEXTURE_COORD_ARRAY_SIZE
	GL_TEXTURE_COORD_ARRAY_SIZE_EXT
	GL_TEXTURE_COORD_ARRAY_STRIDE
	GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
	GL_TEXTURE_COORD_ARRAY_TYPE
	GL_TEXTURE_COORD_ARRAY_TYPE_EXT
	GL_TEXTURE_CUBE_MAP
	GL_TEXTURE_CUBE_MAP_ARB
	GL_TEXTURE_CUBE_MAP_EXT
	GL_TEXTURE_CUBE_MAP_NEGATIVE_X
	GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
	GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
	GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT
	GL_TEXTURE_CUBE_MAP_POSITIVE_X
	GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
	GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT
	GL_TEXTURE_CUBE_MAP_POSITIVE_Y
	GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
	GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT
	GL_TEXTURE_CUBE_MAP_POSITIVE_Z
	GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
	GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT
	GL_TEXTURE_DEPTH
	GL_TEXTURE_DEPTH_EXT
	GL_TEXTURE_DEPTH_SIZE
	GL_TEXTURE_DEPTH_SIZE_ARB
	GL_TEXTURE_DS_SIZE_NV
	GL_TEXTURE_DT_SIZE_NV
	GL_TEXTURE_ENV
	GL_TEXTURE_ENV_COLOR
	GL_TEXTURE_ENV_MODE
	GL_TEXTURE_FILTER_CONTROL
	GL_TEXTURE_FILTER_CONTROL_EXT
	GL_TEXTURE_FLOAT_COMPONENTS_NV
	GL_TEXTURE_GEN_MODE
	GL_TEXTURE_GEN_Q
	GL_TEXTURE_GEN_R
	GL_TEXTURE_GEN_S
	GL_TEXTURE_GEN_T
	GL_TEXTURE_GEQUAL_R_SGIX
	GL_TEXTURE_GREEN_SIZE
	GL_TEXTURE_HEIGHT
	GL_TEXTURE_HI_SIZE_NV
	GL_TEXTURE_INDEX_SIZE_EXT
	GL_TEXTURE_INTENSITY_SIZE
	GL_TEXTURE_INTERNAL_FORMAT
	GL_TEXTURE_LEQUAL_R_SGIX
	GL_TEXTURE_LOD_BIAS
	GL_TEXTURE_LOD_BIAS_EXT
	GL_TEXTURE_LO_SIZE_NV
	GL_TEXTURE_LUMINANCE_SIZE
	GL_TEXTURE_MAG_FILTER
	GL_TEXTURE_MAG_SIZE_NV
	GL_TEXTURE_MATRIX
	GL_TEXTURE_MAX_ANISOTROPY_EXT
	GL_TEXTURE_MAX_LEVEL
	GL_TEXTURE_MAX_LEVEL_SGIS
	GL_TEXTURE_MAX_LOD
	GL_TEXTURE_MAX_LOD_SGIS
	GL_TEXTURE_MIN_FILTER
	GL_TEXTURE_MIN_LOD
	GL_TEXTURE_MIN_LOD_SGIS
	GL_TEXTURE_PRIORITY
	GL_TEXTURE_RECTANGLE_NV
	GL_TEXTURE_RED_SIZE
	GL_TEXTURE_RESIDENT
	GL_TEXTURE_SHADER_NV
	GL_TEXTURE_STACK_DEPTH
	GL_TEXTURE_UNSIGNED_REMAP_MODE_NV
	GL_TEXTURE_WIDTH
	GL_TEXTURE_WRAP_R
	GL_TEXTURE_WRAP_R_EXT
	GL_TEXTURE_WRAP_S
	GL_TEXTURE_WRAP_T
	GL_TRACK_MATRIX_NV
	GL_TRACK_MATRIX_TRANSFORM_NV
	GL_TRANSFORM_BIT
	GL_TRANSFORM_HINT_APPLE
	GL_TRANSPOSE_COLOR_MATRIX
	GL_TRANSPOSE_COLOR_MATRIX_ARB
	GL_TRANSPOSE_CURRENT_MATRIX_ARB
	GL_TRANSPOSE_MODELVIEW_MATRIX
	GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
	GL_TRANSPOSE_NV
	GL_TRANSPOSE_PROJECTION_MATRIX
	GL_TRANSPOSE_PROJECTION_MATRIX_ARB
	GL_TRANSPOSE_TEXTURE_MATRIX
	GL_TRANSPOSE_TEXTURE_MATRIX_ARB
	GL_TRIANGLES
	GL_TRIANGLE_FAN
	GL_TRIANGLE_STRIP
	GL_TRUE
	GL_UNPACK_ALIGNMENT
	GL_UNPACK_IMAGE_HEIGHT
	GL_UNPACK_IMAGE_HEIGHT_EXT
	GL_UNPACK_LSB_FIRST
	GL_UNPACK_ROW_LENGTH
	GL_UNPACK_SKIP_IMAGES
	GL_UNPACK_SKIP_IMAGES_EXT
	GL_UNPACK_SKIP_PIXELS
	GL_UNPACK_SKIP_ROWS
	GL_UNPACK_SWAP_BYTES
	GL_UNSIGNED_BYTE
	GL_UNSIGNED_BYTE_2_3_3_REV
	GL_UNSIGNED_BYTE_3_3_2
	GL_UNSIGNED_BYTE_3_3_2_EXT
	GL_UNSIGNED_IDENTITY_NV
	GL_UNSIGNED_INT
	GL_UNSIGNED_INT_10_10_10_2
	GL_UNSIGNED_INT_10_10_10_2_EXT
	GL_UNSIGNED_INT_24_8_NV
	GL_UNSIGNED_INT_2_10_10_10_REV
	GL_UNSIGNED_INT_8_8_8_8
	GL_UNSIGNED_INT_8_8_8_8_EXT
	GL_UNSIGNED_INT_8_8_8_8_REV
	GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
	GL_UNSIGNED_INT_S10_S11_S11_REV_NV
	GL_UNSIGNED_INT_S8_S8_8_8_NV
	GL_UNSIGNED_INVERT_NV
	GL_UNSIGNED_SHORT
	GL_UNSIGNED_SHORT_1_5_5_5_REV
	GL_UNSIGNED_SHORT_4_4_4_4
	GL_UNSIGNED_SHORT_4_4_4_4_EXT
	GL_UNSIGNED_SHORT_4_4_4_4_REV
	GL_UNSIGNED_SHORT_5_5_5_1
	GL_UNSIGNED_SHORT_5_5_5_1_EXT
	GL_UNSIGNED_SHORT_5_6_5
	GL_UNSIGNED_SHORT_5_6_5_REV
	GL_V2F
	GL_V3F
	GL_VARIABLE_A_NV
	GL_VARIABLE_B_NV
	GL_VARIABLE_C_NV
	GL_VARIABLE_D_NV
	GL_VARIABLE_E_NV
	GL_VARIABLE_F_NV
	GL_VARIABLE_G_NV
	GL_VENDOR
	GL_VERSION
	GL_VERTEX_ARRAY
	GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
	GL_VERTEX_ARRAY_COUNT_EXT
	GL_VERTEX_ARRAY_EXT
	GL_VERTEX_ARRAY_POINTER
	GL_VERTEX_ARRAY_POINTER_EXT
	GL_VERTEX_ARRAY_RANGE_LENGTH_NV
	GL_VERTEX_ARRAY_RANGE_NV
	GL_VERTEX_ARRAY_RANGE_POINTER_NV
	GL_VERTEX_ARRAY_RANGE_VALID_NV
	GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
	GL_VERTEX_ARRAY_SIZE
	GL_VERTEX_ARRAY_SIZE_EXT
	GL_VERTEX_ARRAY_STRIDE
	GL_VERTEX_ARRAY_STRIDE_EXT
	GL_VERTEX_ARRAY_TYPE
	GL_VERTEX_ARRAY_TYPE_EXT
	GL_VERTEX_ATTRIB_ARRAY0_NV
	GL_VERTEX_ATTRIB_ARRAY10_NV
	GL_VERTEX_ATTRIB_ARRAY11_NV
	GL_VERTEX_ATTRIB_ARRAY12_NV
	GL_VERTEX_ATTRIB_ARRAY13_NV
	GL_VERTEX_ATTRIB_ARRAY14_NV
	GL_VERTEX_ATTRIB_ARRAY15_NV
	GL_VERTEX_ATTRIB_ARRAY1_NV
	GL_VERTEX_ATTRIB_ARRAY2_NV
	GL_VERTEX_ATTRIB_ARRAY3_NV
	GL_VERTEX_ATTRIB_ARRAY4_NV
	GL_VERTEX_ATTRIB_ARRAY5_NV
	GL_VERTEX_ATTRIB_ARRAY6_NV
	GL_VERTEX_ATTRIB_ARRAY7_NV
	GL_VERTEX_ATTRIB_ARRAY8_NV
	GL_VERTEX_ATTRIB_ARRAY9_NV
	GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
	GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
	GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
	GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
	GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
	GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
	GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
	GL_VERTEX_PROGRAM_ARB
	GL_VERTEX_PROGRAM_BINDING_NV
	GL_VERTEX_PROGRAM_NV
	GL_VERTEX_PROGRAM_POINT_SIZE_ARB
	GL_VERTEX_PROGRAM_POINT_SIZE_NV
	GL_VERTEX_PROGRAM_TWO_SIDE_ARB
	GL_VERTEX_PROGRAM_TWO_SIDE_NV
	GL_VERTEX_STATE_PROGRAM_NV
	GL_VERTEX_WEIGHTING_EXT
	GL_VERTEX_WEIGHT_ARRAY_EXT
	GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
	GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
	GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
	GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
	GL_VIBRANCE_BIAS_NV
	GL_VIBRANCE_SCALE_NV
	GL_VIEWPORT
	GL_VIEWPORT_BIT
	GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
	GL_WRITE_ONLY_ARB
	GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV
	GL_WRITE_PIXEL_DATA_RANGE_NV
	GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV
	GL_XOR
	GL_YCRYCB_422_NVX
	GL_ZERO
	GL_ZOOM_X
	GL_ZOOM_Y
);

for (@EXPORT) {
	*{"SDL::" . $_} = *{$_};
	*{"main::" . $_} = *{$_};
}

sub GLU_AUTO_LOAD_MATRIX {100200}
sub GLU_CULLING {100201}
sub GLU_DISPLAY_MODE {100204}
sub GLU_DOMAIN_DISTANCE {100217}
sub GLU_FILL {100012}
sub GLU_MAP1_TRIM_2 {100210}
sub GLU_MAP1_TRIM_3 {100211}
sub GLU_NURBS_BEGIN {100164}
sub GLU_NURBS_BEGIN_DATA {100170}
sub GLU_NURBS_COLOR {100167}
sub GLU_NURBS_COLOR_DATA {100173}
sub GLU_NURBS_END {100169}
sub GLU_NURBS_END_DATA {100175}
sub GLU_NURBS_ERROR {100103}
sub GLU_NURBS_MODE {100160}
sub GLU_NURBS_NORMAL {100166}
sub GLU_NURBS_NORMAL_DATA {100172}
sub GLU_NURBS_RENDERER {100162}
sub GLU_NURBS_TESSELLATOR {100161}
sub GLU_NURBS_TEXTURE_COORD {100168}
sub GLU_NURBS_TEXTURE_COORD_DATA {100174}
sub GLU_NURBS_VERTEX {100165}
sub GLU_NURBS_VERTEX_DATA {100171}
sub GLU_OBJECT_PARAMETRIC_ERROR {100208}
sub GLU_OBJECT_PATH_LENGTH {100209}
sub GLU_OUTLINE_PATCH {100241}
sub GLU_OUTLINE_POLYGON {100240}
sub GLU_PARAMETRIC_TOLERANCE {100202}
sub GLU_PATH_LENGTH {100215}
sub GLU_SAMPLING_METHOD {100205}
sub GLU_SAMPLING_TOLERANCE {100203}
sub GLU_TESS_BOUNDARY_ONLY {100141}
sub GLU_TESS_TOLERANCE {100142}
sub GLU_TESS_WINDING_ABS_GEQ_TWO {100134}
sub GLU_TESS_WINDING_NEGATIVE {100133}
sub GLU_TESS_WINDING_NONZERO {100131}
sub GLU_TESS_WINDING_ODD {100130}
sub GLU_TESS_WINDING_POSITIVE {100132}
sub GLU_TESS_WINDING_RULE {100140}
sub GLU_U_STEP {100206}
sub GLU_V_STEP {100207}
sub GL_2D {0x0600}
sub GL_2_BYTES {0x1407}
sub GL_3D {0x0601}
sub GL_3D_COLOR {0x0602}
sub GL_3D_COLOR_TEXTURE {0x0603}
sub GL_3_BYTES {0x1408}
sub GL_4D_COLOR_TEXTURE {0x0604}
sub GL_4_BYTES {0x1409}
sub GL_ABGR_EXT {0x8000}
sub GL_ACCUM {0x0100}
sub GL_ACCUM_ALPHA_BITS {0x0D5B}
sub GL_ACCUM_BLUE_BITS {0x0D5A}
sub GL_ACCUM_BUFFER_BIT {0x00000200}
sub GL_ACCUM_CLEAR_VALUE {0x0B80}
sub GL_ACCUM_GREEN_BITS {0x0D59}
sub GL_ACCUM_RED_BITS {0x0D58}
sub GL_ACTIVE_STENCIL_FACE_EXT {0x8911}
sub GL_ACTIVE_TEXTURE {0x84E0}
sub GL_ACTIVE_TEXTURE_ARB {0x84E0}
sub GL_ADD {0x0104}
sub GL_ADD_SIGNED {0x8574}
sub GL_ADD_SIGNED_ARB {0x8574}
sub GL_ADD_SIGNED_EXT {0x8574}
sub GL_ALIASED_LINE_WIDTH_RANGE {0x846E}
sub GL_ALIASED_POINT_SIZE_RANGE {0x846D}
sub GL_ALL_ATTRIB_BITS {0xFFFFFFFF}
sub GL_ALL_COMPLETED_NV {0x84F2}
sub GL_ALL_EXTENSIONS_NV {0x84FB}
sub GL_ALPHA {0x1906}
sub GL_ALPHA12 {0x803D}
sub GL_ALPHA16 {0x803E}
sub GL_ALPHA4 {0x803B}
sub GL_ALPHA8 {0x803C}
sub GL_ALPHA_BIAS {0x0D1D}
sub GL_ALPHA_BITS {0x0D55}
sub GL_ALPHA_SCALE {0x0D1C}
sub GL_ALPHA_TEST {0x0BC0}
sub GL_ALPHA_TEST_FUNC {0x0BC1}
sub GL_ALPHA_TEST_REF {0x0BC2}
sub GL_ALWAYS {0x0207}
sub GL_AMBIENT {0x1200}
sub GL_AMBIENT_AND_DIFFUSE {0x1602}
sub GL_AND {0x1501}
sub GL_AND_INVERTED {0x1504}
sub GL_AND_REVERSE {0x1502}
sub GL_ARRAY_BUFFER_ARB {0x8892}
sub GL_ARRAY_BUFFER_BINDING_ARB {0x8894}
sub GL_ARRAY_ELEMENT_LOCK_COUNT_EXT {0x81A9}
sub GL_ARRAY_ELEMENT_LOCK_FIRST_EXT {0x81A8}
sub GL_ATTRIB_ARRAY_POINTER_NV {0x8645}
sub GL_ATTRIB_ARRAY_SIZE_NV {0x8623}
sub GL_ATTRIB_ARRAY_STRIDE_NV {0x8624}
sub GL_ATTRIB_ARRAY_TYPE_NV {0x8625}
sub GL_ATTRIB_STACK_DEPTH {0x0BB0}
sub GL_AUTO_NORMAL {0x0D80}
sub GL_AUX0 {0x0409}
sub GL_AUX1 {0x040A}
sub GL_AUX2 {0x040B}
sub GL_AUX3 {0x040C}
sub GL_AUX_BUFFERS {0x0C00}
sub GL_BACK {0x0405}
sub GL_BACK_LEFT {0x0402}
sub GL_BACK_RIGHT {0x0403}
sub GL_BGR {0x80E0}
sub GL_BGRA {0x80E1}
sub GL_BGRA_EXT {0x80E1}
sub GL_BGR_EXT {0x80E0}
sub GL_BIAS_BY_NEGATIVE_ONE_HALF_NV {0x8541}
sub GL_BITMAP {0x1A00}
sub GL_BITMAP_TOKEN {0x0704}
sub GL_BLEND {0x0BE2}
sub GL_BLEND_COLOR {0x8005}
sub GL_BLEND_COLOR_EXT {0x8005}
sub GL_BLEND_DST {0x0BE0}
sub GL_BLEND_DST_ALPHA {0x80CA}
sub GL_BLEND_DST_ALPHA_EXT {0x80CA}
sub GL_BLEND_DST_RGB {0x80C8}
sub GL_BLEND_DST_RGB_EXT {0x80C8}
sub GL_BLEND_EQUATION {0x8009}
sub GL_BLEND_EQUATION_EXT {0x8009}
sub GL_BLEND_SRC {0x0BE1}
sub GL_BLEND_SRC_ALPHA {0x80CB}
sub GL_BLEND_SRC_ALPHA_EXT {0x80CB}
sub GL_BLEND_SRC_RGB {0x80C9}
sub GL_BLEND_SRC_RGB_EXT {0x80C9}
sub GL_BLUE {0x1905}
sub GL_BLUE_BIAS {0x0D1B}
sub GL_BLUE_BITS {0x0D54}
sub GL_BLUE_SCALE {0x0D1A}
sub GL_BUFFER_ACCESS_ARB {0x88BB}
sub GL_BUFFER_MAPPED_ARB {0x88BC}
sub GL_BUFFER_MAP_POINTER_ARB {0x88BD}
sub GL_BUFFER_SIZE_ARB {0x8764}
sub GL_BUFFER_USAGE_ARB {0x8765}
sub GL_BYTE {0x1400}
sub GL_C3F_V3F {0x2A24}
sub GL_C4F_N3F_V3F {0x2A26}
sub GL_C4UB_V2F {0x2A22}
sub GL_C4UB_V3F {0x2A23}
sub GL_CCW {0x0901}
sub GL_CLAMP {0x2900}
sub GL_CLAMP_TO_BORDER {0x812D}
sub GL_CLAMP_TO_BORDER_ARB {0x812D}
sub GL_CLAMP_TO_EDGE {0x812F}
sub GL_CLAMP_TO_EDGE_EXT {0x812F}
sub GL_CLEAR {0x1500}
sub GL_CLIENT_ACTIVE_TEXTURE {0x84E1}
sub GL_CLIENT_ACTIVE_TEXTURE_ARB {0x84E1}
sub GL_CLIENT_ALL_ATTRIB_BITS {0xFFFFFFFF}
sub GL_ALL_CLIENT_ATTRIB_BITS {0xFFFFFFFF}
sub GL_CLIENT_ATTRIB_STACK_DEPTH {0x0BB1}
sub GL_CLIENT_PIXEL_STORE_BIT {0x00000001}
sub GL_CLIENT_VERTEX_ARRAY_BIT {0x00000002}
sub GL_CLIP_PLANE0 {0x3000}
sub GL_CLIP_PLANE1 {0x3001}
sub GL_CLIP_PLANE2 {0x3002}
sub GL_CLIP_PLANE3 {0x3003}
sub GL_CLIP_PLANE4 {0x3004}
sub GL_CLIP_PLANE5 {0x3005}
sub GL_CLIP_VOLUME_CLIPPING_HINT_EXT {0x80F0}
sub GL_COEFF {0x0A00}
sub GL_COLOR {0x1800}
sub GL_COLOR_ARRAY {0x8076}
sub GL_COLOR_ARRAY_BUFFER_BINDING_ARB {0x8898}
sub GL_COLOR_ARRAY_COUNT_EXT {0x8084}
sub GL_COLOR_ARRAY_EXT {0x8076}
sub GL_COLOR_ARRAY_POINTER {0x8090}
sub GL_COLOR_ARRAY_POINTER_EXT {0x8090}
sub GL_COLOR_ARRAY_SIZE {0x8081}
sub GL_COLOR_ARRAY_SIZE_EXT {0x8081}
sub GL_COLOR_ARRAY_STRIDE {0x8083}
sub GL_COLOR_ARRAY_STRIDE_EXT {0x8083}
sub GL_COLOR_ARRAY_TYPE {0x8082}
sub GL_COLOR_ARRAY_TYPE_EXT {0x8082}
sub GL_COLOR_BUFFER_BIT {0x00004000}
sub GL_COLOR_CLEAR_VALUE {0x0C22}
sub GL_COLOR_INDEX {0x1900}
sub GL_COLOR_INDEX12_EXT {0x80E6}
sub GL_COLOR_INDEX16_EXT {0x80E7}
sub GL_COLOR_INDEX1_EXT {0x80E2}
sub GL_COLOR_INDEX2_EXT {0x80E3}
sub GL_COLOR_INDEX4_EXT {0x80E4}
sub GL_COLOR_INDEX8_EXT {0x80E5}
sub GL_COLOR_INDEXES {0x1603}
sub GL_COLOR_LOGIC_OP {0x0BF2}
sub GL_COLOR_MATERIAL {0x0B57}
sub GL_COLOR_MATERIAL_FACE {0x0B55}
sub GL_COLOR_MATERIAL_PARAMETER {0x0B56}
sub GL_COLOR_MATRIX {0x80B1}
sub GL_COLOR_MATRIX_STACK_DEPTH {0x80B2}
sub GL_COLOR_SUM {0x8458}
sub GL_COLOR_SUM_ARB {0x8458}
sub GL_COLOR_SUM_CLAMP_NV {0x854F}
sub GL_COLOR_SUM_EXT {0x8458}
sub GL_COLOR_TABLE {0x80D0}
sub GL_COLOR_TABLE_ALPHA_SIZE {0x80DD}
sub GL_COLOR_TABLE_ALPHA_SIZE_EXT {0x80DD}
sub GL_COLOR_TABLE_BIAS {0x80D7}
sub GL_COLOR_TABLE_BLUE_SIZE {0x80DC}
sub GL_COLOR_TABLE_BLUE_SIZE_EXT {0x80DC}
sub GL_COLOR_TABLE_FORMAT {0x80D8}
sub GL_COLOR_TABLE_FORMAT_EXT {0x80D8}
sub GL_COLOR_TABLE_GREEN_SIZE {0x80DB}
sub GL_COLOR_TABLE_GREEN_SIZE_EXT {0x80DB}
sub GL_COLOR_TABLE_INTENSITY_SIZE {0x80DF}
sub GL_COLOR_TABLE_INTENSITY_SIZE_EXT {0x80DF}
sub GL_COLOR_TABLE_LUMINANCE_SIZE {0x80DE}
sub GL_COLOR_TABLE_LUMINANCE_SIZE_EXT {0x80DE}
sub GL_COLOR_TABLE_RED_SIZE {0x80DA}
sub GL_COLOR_TABLE_RED_SIZE_EXT {0x80DA}
sub GL_COLOR_TABLE_SCALE {0x80D6}
sub GL_COLOR_TABLE_WIDTH {0x80D9}
sub GL_COLOR_TABLE_WIDTH_EXT {0x80D9}
sub GL_COLOR_WRITEMASK {0x0C23}
sub GL_COMBINE {0x8570}
sub GL_COMBINE4_NV {0x8503}
sub GL_COMBINER0_NV {0x8550}
sub GL_COMBINER1_NV {0x8551}
sub GL_COMBINER2_NV {0x8552}
sub GL_COMBINER3_NV {0x8553}
sub GL_COMBINER4_NV {0x8554}
sub GL_COMBINER5_NV {0x8555}
sub GL_COMBINER6_NV {0x8556}
sub GL_COMBINER7_NV {0x8557}
sub GL_COMBINER_AB_DOT_PRODUCT_NV {0x8545}
sub GL_COMBINER_AB_OUTPUT_NV {0x854A}
sub GL_COMBINER_BIAS_NV {0x8549}
sub GL_COMBINER_CD_DOT_PRODUCT_NV {0x8546}
sub GL_COMBINER_CD_OUTPUT_NV {0x854B}
sub GL_COMBINER_COMPONENT_USAGE_NV {0x8544}
sub GL_COMBINER_INPUT_NV {0x8542}
sub GL_COMBINER_MAPPING_NV {0x8543}
sub GL_COMBINER_MUX_SUM_NV {0x8547}
sub GL_COMBINER_SCALE_NV {0x8548}
sub GL_COMBINER_SUM_OUTPUT_NV {0x854C}
sub GL_COMBINE_ALPHA {0x8572}
sub GL_COMBINE_ALPHA_ARB {0x8572}
sub GL_COMBINE_ALPHA_EXT {0x8572}
sub GL_COMBINE_ARB {0x8570}
sub GL_COMBINE_EXT {0x8570}
sub GL_COMBINE_RGB {0x8571}
sub GL_COMBINE_RGB_ARB {0x8571}
sub GL_COMBINE_RGB_EXT {0x8571}
sub GL_COMPARE_R_TO_TEXTURE {0x884E}
sub GL_COMPARE_R_TO_TEXTURE_ARB {0x884E}
sub GL_COMPILE {0x1300}
sub GL_COMPILE_AND_EXECUTE {0x1301}
sub GL_COMPRESSED_ALPHA {0x84E9}
sub GL_COMPRESSED_ALPHA_ARB {0x84E9}
sub GL_COMPRESSED_INTENSITY {0x84EC}
sub GL_COMPRESSED_INTENSITY_ARB {0x84EC}
sub GL_COMPRESSED_LUMINANCE {0x84EA}
sub GL_COMPRESSED_LUMINANCE_ALPHA {0x84EB}
sub GL_COMPRESSED_LUMINANCE_ALPHA_ARB {0x84EB}
sub GL_COMPRESSED_LUMINANCE_ARB {0x84EA}
sub GL_COMPRESSED_RGB {0x84ED}
sub GL_COMPRESSED_RGBA {0x84EE}
sub GL_COMPRESSED_RGBA_ARB {0x84EE}
sub GL_COMPRESSED_RGBA_S3TC_DXT1_EXT {0x83F1}
sub GL_COMPRESSED_RGBA_S3TC_DXT3_EXT {0x83F2}
sub GL_COMPRESSED_RGBA_S3TC_DXT5_EXT {0x83F3}
sub GL_COMPRESSED_RGB_ARB {0x84ED}
sub GL_COMPRESSED_RGB_S3TC_DXT1_EXT {0x83F0}
sub GL_COMPRESSED_TEXTURE_FORMATS {0x86A3}
sub GL_COMPRESSED_TEXTURE_FORMATS_ARB {0x86A3}
sub GL_CONSTANT {0x8576}
sub GL_CONSTANT_ALPHA {0x8003}
sub GL_CONSTANT_ALPHA_EXT {0x8003}
sub GL_CONSTANT_ARB {0x8576}
sub GL_CONSTANT_ATTENUATION {0x1207}
sub GL_CONSTANT_BORDER {0x8151}
sub GL_CONSTANT_COLOR {0x8001}
sub GL_CONSTANT_COLOR0_NV {0x852A}
sub GL_CONSTANT_COLOR1_NV {0x852B}
sub GL_CONSTANT_COLOR_EXT {0x8001}
sub GL_CONSTANT_EXT {0x8576}
sub GL_CONST_EYE_NV {0x86E5}
sub GL_CONVOLUTION_1D {0x8010}
sub GL_CONVOLUTION_2D {0x8011}
sub GL_CONVOLUTION_BORDER_COLOR {0x8154}
sub GL_CONVOLUTION_BORDER_MODE {0x8013}
sub GL_CONVOLUTION_FILTER_BIAS {0x8015}
sub GL_CONVOLUTION_FILTER_SCALE {0x8014}
sub GL_CONVOLUTION_FORMAT {0x8017}
sub GL_CONVOLUTION_HEIGHT {0x8019}
sub GL_CONVOLUTION_WIDTH {0x8018}
sub GL_COORD_REPLACE_NV {0x8862}
sub GL_COPY {0x1503}
sub GL_COPY_INVERTED {0x150C}
sub GL_COPY_PIXEL_TOKEN {0x0706}
sub GL_CRYCBY_422_NVX {0x600A}
sub GL_CULL_FACE {0x0B44}
sub GL_CULL_FACE_MODE {0x0B45}
sub GL_CULL_FRAGMENT_NV {0x86E7}
sub GL_CULL_MODES_NV {0x86E0}
sub GL_CURRENT_ATTRIB_NV {0x8626}
sub GL_CURRENT_BIT {0x00000001}
sub GL_CURRENT_COLOR {0x0B00}
sub GL_CURRENT_FLUSHHOLD_NVX {0x6008}
sub GL_CURRENT_FOG_COORDINATE {0x8453}
sub GL_CURRENT_FOG_COORDINATE_EXT {0x8453}
sub GL_CURRENT_INDEX {0x0B01}
sub GL_CURRENT_MATRIX_ARB {0x8641}
sub GL_CURRENT_MATRIX_NV {0x8641}
sub GL_CURRENT_MATRIX_STACK_DEPTH_ARB {0x8640}
sub GL_CURRENT_MATRIX_STACK_DEPTH_NV {0x8640}
sub GL_CURRENT_NORMAL {0x0B02}
sub GL_CURRENT_OCCLUSION_QUERY_ID_NV {0x8865}
sub GL_CURRENT_RASTER_COLOR {0x0B04}
sub GL_CURRENT_RASTER_DISTANCE {0x0B09}
sub GL_CURRENT_RASTER_INDEX {0x0B05}
sub GL_CURRENT_RASTER_POSITION {0x0B07}
sub GL_CURRENT_RASTER_POSITION_VALID {0x0B08}
sub GL_CURRENT_RASTER_TEXTURE_COORDS {0x0B06}
sub GL_CURRENT_SECONDARY_COLOR {0x8459}
sub GL_CURRENT_SECONDARY_COLOR_EXT {0x8459}
sub GL_CURRENT_TEXTURE_COORDS {0x0B03}
sub GL_CURRENT_VERTEX_ATTRIB_ARB {0x8626}
sub GL_CURRENT_VERTEX_WEIGHT_EXT {0x850B}
sub GL_CW {0x0900}
sub GL_DECAL {0x2101}
sub GL_DECR {0x1E03}
sub GL_DECR_WRAP {0x8508}
sub GL_DECR_WRAP_EXT {0x8508}
sub GL_DEPENDENT_AR_TEXTURE_2D_NV {0x86E9}
sub GL_DEPENDENT_GB_TEXTURE_2D_NV {0x86EA}
sub GL_DEPENDENT_HILO_TEXTURE_2D_NV {0x8858}
sub GL_DEPENDENT_RGB_TEXTURE_3D_NV {0x8859}
sub GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV {0x885A}
sub GL_DEPTH {0x1801}
sub GL_DEPTH_BIAS {0x0D1F}
sub GL_DEPTH_BITS {0x0D56}
sub GL_DEPTH_BOUNDS_NV {0x8891}
sub GL_DEPTH_BOUNDS_TEST_NV {0x8890}
sub GL_DEPTH_BUFFER_BIT {0x00000100}
sub GL_DEPTH_CLAMP_NV {0x864F}
sub GL_DEPTH_CLEAR_VALUE {0x0B73}
sub GL_DEPTH_COMPONENT {0x1902}
sub GL_DEPTH_COMPONENT16 {0x81A5}
sub GL_DEPTH_COMPONENT16_ARB {0x81A5}
sub GL_DEPTH_COMPONENT16_SGIX {0x81A5}
sub GL_DEPTH_COMPONENT24 {0x81A6}
sub GL_DEPTH_COMPONENT24_ARB {0x81A6}
sub GL_DEPTH_COMPONENT24_SGIX {0x81A6}
sub GL_DEPTH_COMPONENT32 {0x81A7}
sub GL_DEPTH_COMPONENT32_ARB {0x81A7}
sub GL_DEPTH_COMPONENT32_SGIX {0x81A7}
sub GL_DEPTH_FUNC {0x0B74}
sub GL_DEPTH_RANGE {0x0B70}
sub GL_DEPTH_SCALE {0x0D1E}
sub GL_DEPTH_STENCIL_NV {0x84F9}
sub GL_DEPTH_STENCIL_TO_BGRA_NV {0x886F}
sub GL_DEPTH_STENCIL_TO_RGBA_NV {0x886E}
sub GL_DEPTH_TEST {0x0B71}
sub GL_DEPTH_TEXTURE_MODE {0x884B}
sub GL_DEPTH_TEXTURE_MODE_ARB {0x884B}
sub GL_DEPTH_WRITEMASK {0x0B72}
sub GL_DIFFUSE {0x1201}
sub GL_DISCARD_NV {0x8530}
sub GL_DISTANCE_ATTENUATION_EXT {0x8129}
sub GL_DITHER {0x0BD0}
sub GL_DOMAIN {0x0A02}
sub GL_DONT_CARE {0x1100}
sub GL_DOT3_RGB {0x86AE}
sub GL_DOT3_RGBA {0x86AF}
sub GL_DOT3_RGBA_ARB {0x86AF}
sub GL_DOT3_RGBA_EXT {0x8741}
sub GL_DOT3_RGB_ARB {0x86AE}
sub GL_DOT3_RGB_EXT {0x8740}
sub GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV {0x885D}
sub GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV {0x86F3}
sub GL_DOT_PRODUCT_DEPTH_REPLACE_NV {0x86ED}
sub GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV {0x86F1}
sub GL_DOT_PRODUCT_NV {0x86EC}
sub GL_DOT_PRODUCT_PASS_THROUGH_NV {0x885B}
sub GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV {0x86F2}
sub GL_DOT_PRODUCT_TEXTURE_1D_NV {0x885C}
sub GL_DOT_PRODUCT_TEXTURE_2D_NV {0x86EE}
sub GL_DOT_PRODUCT_TEXTURE_3D_NV {0x86EF}
sub GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV {0x86F0}
sub GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV {0x864E}
sub GL_DOUBLE {0x140A}
sub GL_DOUBLEBUFFER {0x0C32}
sub GL_DOUBLE_EXT {0x140A}
sub GL_DRAW_BUFFER {0x0C01}
sub GL_DRAW_PIXEL_TOKEN {0x0705}
sub GL_DSDT8_MAG8_INTENSITY8_NV {0x870B}
sub GL_DSDT8_MAG8_NV {0x870A}
sub GL_DSDT8_NV {0x8709}
sub GL_DSDT_MAG_INTENSITY_NV {0x86DC}
sub GL_DSDT_MAG_NV {0x86F6}
sub GL_DSDT_MAG_VIB_NV {0x86F7}
sub GL_DSDT_NV {0x86F5}
sub GL_DST_ALPHA {0x0304}
sub GL_DST_COLOR {0x0306}
sub GL_DS_BIAS_NV {0x8716}
sub GL_DS_SCALE_NV {0x8710}
sub GL_DT_BIAS_NV {0x8717}
sub GL_DT_SCALE_NV {0x8711}
sub GL_DYNAMIC_COPY_ARB {0x88EA}
sub GL_DYNAMIC_DRAW_ARB {0x88E8}
sub GL_DYNAMIC_READ_ARB {0x88E9}
sub GL_EDGE_FLAG {0x0B43}
sub GL_EDGE_FLAG_ARRAY {0x8079}
sub GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB {0x889B}
sub GL_EDGE_FLAG_ARRAY_COUNT_EXT {0x808D}
sub GL_EDGE_FLAG_ARRAY_EXT {0x8079}
sub GL_EDGE_FLAG_ARRAY_POINTER {0x8093}
sub GL_EDGE_FLAG_ARRAY_POINTER_EXT {0x8093}
sub GL_EDGE_FLAG_ARRAY_STRIDE {0x808C}
sub GL_EDGE_FLAG_ARRAY_STRIDE_EXT {0x808C}
sub GL_ELEMENT_ARRAY_BUFFER_ARB {0x8893}
sub GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB {0x8895}
sub GL_EMISSION {0x1600}
sub GL_ENABLE_BIT {0x00002000}
sub GL_EQUAL {0x0202}
sub GL_EQUIV {0x1509}
sub GL_EVAL_BIT {0x00010000}
sub GL_EXP {0x0800}
sub GL_EXP2 {0x0801}
sub GL_EXPAND_NEGATE_NV {0x8539}
sub GL_EXPAND_NORMAL_NV {0x8538}
sub GL_EXTENSIONS {0x1F03}
sub GL_EYE_LINEAR {0x2400}
sub GL_EYE_PLANE {0x2502}
sub GL_EYE_PLANE_ABSOLUTE_NV {0x855C}
sub GL_EYE_RADIAL_NV {0x855B}
sub GL_E_TIMES_F_NV {0x8531}
sub GL_FALSE {0}
sub GL_FASTEST {0x1101}
sub GL_FEEDBACK {0x1C01}
sub GL_FEEDBACK_BUFFER_POINTER {0x0DF0}
sub GL_FEEDBACK_BUFFER_SIZE {0x0DF1}
sub GL_FEEDBACK_BUFFER_TYPE {0x0DF2}
sub GL_FENCE_CONDITION_NV {0x84F4}
sub GL_FENCE_STATUS_NV {0x84F3}
sub GL_FILL {0x1B02}
sub GL_FLAT {0x1D00}
sub GL_FLOAT {0x1406}
sub GL_FLOAT_CLEAR_COLOR_VALUE_NV {0x888D}
sub GL_FLOAT_R16_NV {0x8884}
sub GL_FLOAT_R32_NV {0x8885}
sub GL_FLOAT_RG16_NV {0x8886}
sub GL_FLOAT_RG32_NV {0x8887}
sub GL_FLOAT_RGB16_NV {0x8888}
sub GL_FLOAT_RGB32_NV {0x8889}
sub GL_FLOAT_RGBA16_NV {0x888A}
sub GL_FLOAT_RGBA32_NV {0x888B}
sub GL_FLOAT_RGBA_MODE_NV {0x888E}
sub GL_FLOAT_RGBA_NV {0x8883}
sub GL_FLOAT_RGB_NV {0x8882}
sub GL_FLOAT_RG_NV {0x8881}
sub GL_FLOAT_R_NV {0x8880}
sub GL_FOG {0x0B60}
sub GL_FOG_BIT {0x00000080}
sub GL_FOG_COLOR {0x0B66}
sub GL_FOG_COORDINATE {0x8451}
sub GL_FOG_COORDINATE_ARRAY {0x8457}
sub GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB {0x889D}
sub GL_FOG_COORDINATE_ARRAY_EXT {0x8457}
sub GL_FOG_COORDINATE_ARRAY_POINTER {0x8456}
sub GL_FOG_COORDINATE_ARRAY_POINTER_EXT {0x8456}
sub GL_FOG_COORDINATE_ARRAY_STRIDE {0x8455}
sub GL_FOG_COORDINATE_ARRAY_STRIDE_EXT {0x8455}
sub GL_FOG_COORDINATE_ARRAY_TYPE {0x8454}
sub GL_FOG_COORDINATE_ARRAY_TYPE_EXT {0x8454}
sub GL_FOG_COORDINATE_EXT {0x8451}
sub GL_FOG_COORDINATE_SOURCE {0x8450}
sub GL_FOG_COORDINATE_SOURCE_EXT {0x8450}
sub GL_FOG_DENSITY {0x0B62}
sub GL_FOG_DISTANCE_MODE_NV {0x855A}
sub GL_FOG_END {0x0B64}
sub GL_FOG_HINT {0x0C54}
sub GL_FOG_INDEX {0x0B61}
sub GL_FOG_MODE {0x0B65}
sub GL_FOG_START {0x0B63}
sub GL_FORCE_BLUE_TO_ONE_NV {0x8860}
sub GL_FORCE_SOFTWARE_NV {0x6007}
sub GL_FRAGMENT_DEPTH {0x8452}
sub GL_FRAGMENT_DEPTH_EXT {0x8452}
sub GL_FRAGMENT_PROGRAM_ARB {0x8804}
sub GL_FRAGMENT_PROGRAM_BINDING_NV {0x8873}
sub GL_FRAGMENT_PROGRAM_NV {0x8870}
sub GL_FRONT {0x0404}
sub GL_FRONT_AND_BACK {0x0408}
sub GL_FRONT_FACE {0x0B46}
sub GL_FRONT_LEFT {0x0400}
sub GL_FRONT_RIGHT {0x0401}
sub GL_FUNC_ADD {0x8006}
sub GL_FUNC_ADD_EXT {0x8006}
sub GL_FUNC_REVERSE_SUBTRACT {0x800B}
sub GL_FUNC_REVERSE_SUBTRACT_EXT {0x800B}
sub GL_FUNC_SUBTRACT {0x800A}
sub GL_FUNC_SUBTRACT_EXT {0x800A}
sub GL_GENERATE_MIPMAP {0x8191}
sub GL_GENERATE_MIPMAP_HINT {0x8192}
sub GL_GENERATE_MIPMAP_HINT_SGIS {0x8192}
sub GL_GENERATE_MIPMAP_SGIS {0x8191}
sub GL_GEQUAL {0x0206}
sub GL_GREATER {0x0204}
sub GL_GREEN {0x1904}
sub GL_GREEN_BIAS {0x0D19}
sub GL_GREEN_BITS {0x0D53}
sub GL_GREEN_SCALE {0x0D18}
sub GL_HALF_BIAS_NEGATE_NV {0x853B}
sub GL_HALF_BIAS_NORMAL_NV {0x853A}
sub GL_HALF_FLOAT_NV {0x140B}
sub GL_HILO16_NV {0x86F8}
sub GL_HILO8_NV {0x885E}
sub GL_HILO_NV {0x86F4}
sub GL_HINT_BIT {0x00008000}
sub GL_HISTOGRAM {0x8024}
sub GL_HISTOGRAM_ALPHA_SIZE {0x802B}
sub GL_HISTOGRAM_BLUE_SIZE {0x802A}
sub GL_HISTOGRAM_FORMAT {0x8027}
sub GL_HISTOGRAM_GREEN_SIZE {0x8029}
sub GL_HISTOGRAM_LUMINANCE_SIZE {0x802C}
sub GL_HISTOGRAM_RED_SIZE {0x8028}
sub GL_HISTOGRAM_SINK {0x802D}
sub GL_HISTOGRAM_WIDTH {0x8026}
sub GL_HI_BIAS_NV {0x8714}
sub GL_HI_SCALE_NV {0x870E}
sub GL_IDENTITY_NV {0x862A}
sub GL_IGNORE_BORDER {0x8150}
sub GL_INCR {0x1E02}
sub GL_INCR_WRAP {0x8507}
sub GL_INCR_WRAP_EXT {0x8507}
sub GL_INDEX_ARRAY {0x8077}
sub GL_INDEX_ARRAY_BUFFER_BINDING_ARB {0x8899}
sub GL_INDEX_ARRAY_COUNT_EXT {0x8087}
sub GL_INDEX_ARRAY_EXT {0x8077}
sub GL_INDEX_ARRAY_POINTER {0x8091}
sub GL_INDEX_ARRAY_POINTER_EXT {0x8091}
sub GL_INDEX_ARRAY_STRIDE {0x8086}
sub GL_INDEX_ARRAY_STRIDE_EXT {0x8086}
sub GL_INDEX_ARRAY_TYPE {0x8085}
sub GL_INDEX_ARRAY_TYPE_EXT {0x8085}
sub GL_INDEX_BITS {0x0D51}
sub GL_INDEX_CLEAR_VALUE {0x0C20}
sub GL_INDEX_LOGIC_OP {0x0BF1}
sub GL_INDEX_MODE {0x0C30}
sub GL_INDEX_OFFSET {0x0D13}
sub GL_INDEX_SHIFT {0x0D12}
sub GL_INDEX_WRITEMASK {0x0C21}
sub GL_INT {0x1404}
sub GL_INTENSITY {0x8049}
sub GL_INTENSITY12 {0x804C}
sub GL_INTENSITY16 {0x804D}
sub GL_INTENSITY4 {0x804A}
sub GL_INTENSITY8 {0x804B}
sub GL_INTERPOLATE {0x8575}
sub GL_INTERPOLATE_ARB {0x8575}
sub GL_INTERPOLATE_EXT {0x8575}
sub GL_INVALID_ENUM {0x0500}
sub GL_INVALID_OPERATION {0x0502}
sub GL_INVALID_VALUE {0x0501}
sub GL_INVERSE_NV {0x862B}
sub GL_INVERSE_TRANSPOSE_NV {0x862D}
sub GL_INVERT {0x150A}
sub GL_KEEP {0x1E00}
sub GL_LEFT {0x0406}
sub GL_LEQUAL {0x0203}
sub GL_LESS {0x0201}
sub GL_LIGHT0 {0x4000}
sub GL_LIGHT1 {0x4001}
sub GL_LIGHT2 {0x4002}
sub GL_LIGHT3 {0x4003}
sub GL_LIGHT4 {0x4004}
sub GL_LIGHT5 {0x4005}
sub GL_LIGHT6 {0x4006}
sub GL_LIGHT7 {0x4007}
sub GL_LIGHTING {0x0B50}
sub GL_LIGHTING_BIT {0x00000040}
sub GL_LIGHT_MODEL_AMBIENT {0x0B53}
sub GL_LIGHT_MODEL_COLOR_CONTROL {0x81F8}
sub GL_LIGHT_MODEL_COLOR_CONTROL_EXT {0x81F8}
sub GL_LIGHT_MODEL_LOCAL_VIEWER {0x0B51}
sub GL_LIGHT_MODEL_TWO_SIDE {0x0B52}
sub GL_LINE {0x1B01}
sub GL_LINEAR {0x2601}
sub GL_LINEAR_ATTENUATION {0x1208}
sub GL_LINEAR_MIPMAP_LINEAR {0x2703}
sub GL_LINEAR_MIPMAP_NEAREST {0x2701}
sub GL_LINES {0x0001}
sub GL_LINE_BIT {0x00000004}
sub GL_LINE_LOOP {0x0002}
sub GL_LINE_RESET_TOKEN {0x0707}
sub GL_LINE_SMOOTH {0x0B20}
sub GL_LINE_SMOOTH_HINT {0x0C52}
sub GL_LINE_STIPPLE {0x0B24}
sub GL_LINE_STIPPLE_PATTERN {0x0B25}
sub GL_LINE_STIPPLE_REPEAT {0x0B26}
sub GL_LINE_STRIP {0x0003}
sub GL_LINE_TOKEN {0x0702}
sub GL_LINE_WIDTH {0x0B21}
sub GL_LINE_WIDTH_GRANULARITY {0x0B23}
sub GL_LINE_WIDTH_RANGE {0x0B22}
sub GL_LIST_BASE {0x0B32}
sub GL_LIST_BIT {0x00020000}
sub GL_LIST_INDEX {0x0B33}
sub GL_LIST_MODE {0x0B30}
sub GL_LOAD {0x0101}
sub GL_LOGIC_OP {0x0BF1}
sub GL_LOGIC_OP_MODE {0x0BF0}
sub GL_LO_BIAS_NV {0x8715}
sub GL_LO_SCALE_NV {0x870F}
sub GL_LUMINANCE {0x1909}
sub GL_LUMINANCE12 {0x8041}
sub GL_LUMINANCE12_ALPHA12 {0x8047}
sub GL_LUMINANCE12_ALPHA4 {0x8046}
sub GL_LUMINANCE16 {0x8042}
sub GL_LUMINANCE16_ALPHA16 {0x8048}
sub GL_LUMINANCE4 {0x803F}
sub GL_LUMINANCE4_ALPHA4 {0x8043}
sub GL_LUMINANCE6_ALPHA2 {0x8044}
sub GL_LUMINANCE8 {0x8040}
sub GL_LUMINANCE8_ALPHA8 {0x8045}
sub GL_LUMINANCE_ALPHA {0x190A}
sub GL_MAC_GET_PROC_ADDRESS_NV {0x84FC}
sub GL_MAGNITUDE_BIAS_NV {0x8718}
sub GL_MAGNITUDE_SCALE_NV {0x8712}
sub GL_MAP1_COLOR_4 {0x0D90}
sub GL_MAP1_GRID_DOMAIN {0x0DD0}
sub GL_MAP1_GRID_SEGMENTS {0x0DD1}
sub GL_MAP1_INDEX {0x0D91}
sub GL_MAP1_NORMAL {0x0D92}
sub GL_MAP1_TEXTURE_COORD_1 {0x0D93}
sub GL_MAP1_TEXTURE_COORD_2 {0x0D94}
sub GL_MAP1_TEXTURE_COORD_3 {0x0D95}
sub GL_MAP1_TEXTURE_COORD_4 {0x0D96}
sub GL_MAP1_VERTEX_3 {0x0D97}
sub GL_MAP1_VERTEX_4 {0x0D98}
sub GL_MAP1_VERTEX_ATTRIB0_4_NV {0x8660}
sub GL_MAP1_VERTEX_ATTRIB10_4_NV {0x866A}
sub GL_MAP1_VERTEX_ATTRIB11_4_NV {0x866B}
sub GL_MAP1_VERTEX_ATTRIB12_4_NV {0x866C}
sub GL_MAP1_VERTEX_ATTRIB13_4_NV {0x866D}
sub GL_MAP1_VERTEX_ATTRIB14_4_NV {0x866E}
sub GL_MAP1_VERTEX_ATTRIB15_4_NV {0x866F}
sub GL_MAP1_VERTEX_ATTRIB1_4_NV {0x8661}
sub GL_MAP1_VERTEX_ATTRIB2_4_NV {0x8662}
sub GL_MAP1_VERTEX_ATTRIB3_4_NV {0x8663}
sub GL_MAP1_VERTEX_ATTRIB4_4_NV {0x8664}
sub GL_MAP1_VERTEX_ATTRIB5_4_NV {0x8665}
sub GL_MAP1_VERTEX_ATTRIB6_4_NV {0x8666}
sub GL_MAP1_VERTEX_ATTRIB7_4_NV {0x8667}
sub GL_MAP1_VERTEX_ATTRIB8_4_NV {0x8668}
sub GL_MAP1_VERTEX_ATTRIB9_4_NV {0x8669}
sub GL_MAP2_COLOR_4 {0x0DB0}
sub GL_MAP2_GRID_DOMAIN {0x0DD2}
sub GL_MAP2_GRID_SEGMENTS {0x0DD3}
sub GL_MAP2_INDEX {0x0DB1}
sub GL_MAP2_NORMAL {0x0DB2}
sub GL_MAP2_TEXTURE_COORD_1 {0x0DB3}
sub GL_MAP2_TEXTURE_COORD_2 {0x0DB4}
sub GL_MAP2_TEXTURE_COORD_3 {0x0DB5}
sub GL_MAP2_TEXTURE_COORD_4 {0x0DB6}
sub GL_MAP2_VERTEX_3 {0x0DB7}
sub GL_MAP2_VERTEX_4 {0x0DB8}
sub GL_MAP2_VERTEX_ATTRIB0_4_NV {0x8670}
sub GL_MAP2_VERTEX_ATTRIB10_4_NV {0x867A}
sub GL_MAP2_VERTEX_ATTRIB11_4_NV {0x867B}
sub GL_MAP2_VERTEX_ATTRIB12_4_NV {0x867C}
sub GL_MAP2_VERTEX_ATTRIB13_4_NV {0x867D}
sub GL_MAP2_VERTEX_ATTRIB14_4_NV {0x867E}
sub GL_MAP2_VERTEX_ATTRIB15_4_NV {0x867F}
sub GL_MAP2_VERTEX_ATTRIB1_4_NV {0x8671}
sub GL_MAP2_VERTEX_ATTRIB2_4_NV {0x8672}
sub GL_MAP2_VERTEX_ATTRIB3_4_NV {0x8673}
sub GL_MAP2_VERTEX_ATTRIB4_4_NV {0x8674}
sub GL_MAP2_VERTEX_ATTRIB5_4_NV {0x8675}
sub GL_MAP2_VERTEX_ATTRIB6_4_NV {0x8676}
sub GL_MAP2_VERTEX_ATTRIB7_4_NV {0x8677}
sub GL_MAP2_VERTEX_ATTRIB8_4_NV {0x8678}
sub GL_MAP2_VERTEX_ATTRIB9_4_NV {0x8679}
sub GL_MAP_COLOR {0x0D10}
sub GL_MAP_STENCIL {0x0D11}
sub GL_MATRIX0_ARB {0x88C0}
sub GL_MATRIX0_NV {0x8630}
sub GL_MATRIX10_ARB {0x88CA}
sub GL_MATRIX11_ARB {0x88CB}
sub GL_MATRIX12_ARB {0x88CC}
sub GL_MATRIX13_ARB {0x88CD}
sub GL_MATRIX14_ARB {0x88CE}
sub GL_MATRIX15_ARB {0x88CF}
sub GL_MATRIX16_ARB {0x88D0}
sub GL_MATRIX17_ARB {0x88D1}
sub GL_MATRIX18_ARB {0x88D2}
sub GL_MATRIX19_ARB {0x88D3}
sub GL_MATRIX1_ARB {0x88C1}
sub GL_MATRIX1_NV {0x8631}
sub GL_MATRIX20_ARB {0x88D4}
sub GL_MATRIX21_ARB {0x88D5}
sub GL_MATRIX22_ARB {0x88D6}
sub GL_MATRIX23_ARB {0x88D7}
sub GL_MATRIX24_ARB {0x88D8}
sub GL_MATRIX25_ARB {0x88D9}
sub GL_MATRIX26_ARB {0x88DA}
sub GL_MATRIX27_ARB {0x88DB}
sub GL_MATRIX28_ARB {0x88DC}
sub GL_MATRIX29_ARB {0x88DD}
sub GL_MATRIX2_ARB {0x88C2}
sub GL_MATRIX2_NV {0x8632}
sub GL_MATRIX30_ARB {0x88DE}
sub GL_MATRIX31_ARB {0x88DF}
sub GL_MATRIX3_ARB {0x88C3}
sub GL_MATRIX3_NV {0x8633}
sub GL_MATRIX4_ARB {0x88C4}
sub GL_MATRIX4_NV {0x8634}
sub GL_MATRIX5_ARB {0x88C5}
sub GL_MATRIX5_NV {0x8635}
sub GL_MATRIX6_ARB {0x88C6}
sub GL_MATRIX6_NV {0x8636}
sub GL_MATRIX7_ARB {0x88C7}
sub GL_MATRIX7_NV {0x8637}
sub GL_MATRIX8_ARB {0x88C8}
sub GL_MATRIX9_ARB {0x88C9}
sub GL_MATRIX_MODE {0x0BA0}
sub GL_MAX {0x8008}
sub GL_MAX_3D_TEXTURE_SIZE {0x8073}
sub GL_MAX_3D_TEXTURE_SIZE_EXT {0x8073}
sub GL_MAX_ATTRIB_STACK_DEPTH {0x0D35}
sub GL_MAX_CLIENT_ATTRIB_STACK_DEPTH {0x0D3B}
sub GL_MAX_CLIP_PLANES {0x0D32}
sub GL_MAX_COLOR_MATRIX_STACK_DEPTH {0x80B3}
sub GL_MAX_CONVOLUTION_HEIGHT {0x801B}
sub GL_MAX_CONVOLUTION_WIDTH {0x801A}
sub GL_MAX_CUBE_MAP_TEXTURE_SIZE {0x851C}
sub GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB {0x851C}
sub GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT {0x851C}
sub GL_MAX_ELEMENTS_INDICES {0x80E9}
sub GL_MAX_ELEMENTS_INDICES_EXT {0x80E9}
sub GL_MAX_ELEMENTS_VERTICES {0x80E8}
sub GL_MAX_ELEMENTS_VERTICES_EXT {0x80E8}
sub GL_MAX_EVAL_ORDER {0x0D30}
sub GL_MAX_EXT {0x8008}
sub GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV {0x8868}
sub GL_MAX_GENERAL_COMBINERS_NV {0x854D}
sub GL_MAX_LIGHTS {0x0D31}
sub GL_MAX_LIST_NESTING {0x0B31}
sub GL_MAX_MODELVIEW_STACK_DEPTH {0x0D36}
sub GL_MAX_NAME_STACK_DEPTH {0x0D37}
sub GL_MAX_PENDING_FLUSHHOLD_NVX {0x6009}
sub GL_MAX_PIXEL_MAP_TABLE {0x0D34}
sub GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB {0x88B1}
sub GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB {0x880B}
sub GL_MAX_PROGRAM_ATTRIBS_ARB {0x88AD}
sub GL_MAX_PROGRAM_ENV_PARAMETERS_ARB {0x88B5}
sub GL_MAX_PROGRAM_INSTRUCTIONS_ARB {0x88A1}
sub GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB {0x88B4}
sub GL_MAX_PROGRAM_MATRICES_ARB {0x862F}
sub GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB {0x862E}
sub GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB {0x88B3}
sub GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB {0x880E}
sub GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB {0x88AF}
sub GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB {0x88A3}
sub GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB {0x88AB}
sub GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB {0x88A7}
sub GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB {0x8810}
sub GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB {0x880F}
sub GL_MAX_PROGRAM_PARAMETERS_ARB {0x88A9}
sub GL_MAX_PROGRAM_TEMPORARIES_ARB {0x88A5}
sub GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB {0x880D}
sub GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB {0x880C}
sub GL_MAX_PROJECTION_STACK_DEPTH {0x0D38}
sub GL_MAX_RECTANGLE_TEXTURE_SIZE_NV {0x84F8}
sub GL_MAX_SHININESS_NV {0x8504}
sub GL_MAX_SPOT_EXPONENT_NV {0x8505}
sub GL_MAX_TEXTURES_SGIS {0x835D}
sub GL_MAX_TEXTURE_COORDS_ARB {0x8871}
sub GL_MAX_TEXTURE_COORDS_NV {0x8871}
sub GL_MAX_TEXTURE_IMAGE_UNITS_ARB {0x8872}
sub GL_MAX_TEXTURE_IMAGE_UNITS_NV {0x8872}
sub GL_MAX_TEXTURE_LOD_BIAS {0x84FD}
sub GL_MAX_TEXTURE_LOD_BIAS_EXT {0x84FD}
sub GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT {0x84FF}
sub GL_MAX_TEXTURE_SIZE {0x0D33}
sub GL_MAX_TEXTURE_STACK_DEPTH {0x0D39}
sub GL_MAX_TEXTURE_UNITS {0x84E2}
sub GL_MAX_TEXTURE_UNITS_ARB {0x84E2}
sub GL_MAX_TRACK_MATRICES_NV {0x862F}
sub GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV {0x862E}
sub GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV {0x8520}
sub GL_MAX_VERTEX_ATTRIBS_ARB {0x8869}
sub GL_MAX_VIEWPORT_DIMS {0x0D3A}
sub GL_MIN {0x8007}
sub GL_MINMAX {0x802E}
sub GL_MINMAX_FORMAT {0x802F}
sub GL_MINMAX_SINK {0x8030}
sub GL_MIN_EXT {0x8007}
sub GL_MIRRORED_REPEAT {0x8370}
sub GL_MIRRORED_REPEAT_ARB {0x8370}
sub GL_MIRRORED_REPEAT_IBM {0x8370}
sub GL_MODELVIEW {0x1700}
sub GL_MODELVIEW0_EXT {0x1700}
sub GL_MODELVIEW0_MATRIX_EXT {0x0BA6}
sub GL_MODELVIEW0_STACK_DEPTH_EXT {0x0BA3}
sub GL_MODELVIEW1_EXT {0x850A}
sub GL_MODELVIEW1_MATRIX_EXT {0x8506}
sub GL_MODELVIEW1_STACK_DEPTH_EXT {0x8502}
sub GL_MODELVIEW_MATRIX {0x0BA6}
sub GL_MODELVIEW_PROJECTION_NV {0x8629}
sub GL_MODELVIEW_STACK_DEPTH {0x0BA3}
sub GL_MODULATE {0x2100}
sub GL_MULT {0x0103}
sub GL_MULTISAMPLE {0x809D}
sub GL_MULTISAMPLE_ARB {0x809D}
sub GL_MULTISAMPLE_BIT {0x20000000}
sub GL_MULTISAMPLE_BIT_ARB {0x20000000}
sub GL_MULTISAMPLE_FILTER_HINT_NV {0x8534}
sub GL_N3F_V3F {0x2A25}
sub GL_NAME_STACK_DEPTH {0x0D70}
sub GL_NAND {0x150E}
sub GL_NEAREST {0x2600}
sub GL_NEAREST_MIPMAP_LINEAR {0x2702}
sub GL_NEAREST_MIPMAP_NEAREST {0x2700}
sub GL_NEVER {0x0200}
sub GL_NICEST {0x1102}
sub GL_NONE {0}
sub GL_NOOP {0x1505}
sub GL_NOR {0x1508}
sub GL_NORMALIZE {0x0BA1}
sub GL_NORMAL_ARRAY {0x8075}
sub GL_NORMAL_ARRAY_BUFFER_BINDING_ARB {0x8897}
sub GL_NORMAL_ARRAY_COUNT_EXT {0x8080}
sub GL_NORMAL_ARRAY_EXT {0x8075}
sub GL_NORMAL_ARRAY_POINTER {0x808F}
sub GL_NORMAL_ARRAY_POINTER_EXT {0x808F}
sub GL_NORMAL_ARRAY_STRIDE {0x807F}
sub GL_NORMAL_ARRAY_STRIDE_EXT {0x807F}
sub GL_NORMAL_ARRAY_TYPE {0x807E}
sub GL_NORMAL_ARRAY_TYPE_EXT {0x807E}
sub GL_NORMAL_MAP {0x8511}
sub GL_NORMAL_MAP_ARB {0x8511}
sub GL_NORMAL_MAP_EXT {0x8511}
sub GL_NORMAL_MAP_NV {0x8511}
sub GL_NOTEQUAL {0x0205}
sub GL_NO_ERROR {0}
sub GL_NUM_COMPRESSED_TEXTURE_FORMATS {0x86A2}
sub GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB {0x86A2}
sub GL_NUM_GENERAL_COMBINERS_NV {0x854E}
sub GL_OBJECT_LINEAR {0x2401}
sub GL_OBJECT_PLANE {0x2501}
sub GL_OCCLUSION_TEST_HP {0x8165}
sub GL_OCCLUSION_TEST_RESULT_HP {0x8166}
sub GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV {0x8856}
sub GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV {0x8857}
sub GL_OFFSET_HILO_TEXTURE_2D_NV {0x8854}
sub GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV {0x8855}
sub GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV {0x8850}
sub GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV {0x8851}
sub GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV {0x8852}
sub GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV {0x8853}
sub GL_OFFSET_TEXTURE_2D_BIAS_NV {0x86E3}
sub GL_OFFSET_TEXTURE_2D_MATRIX_NV {0x86E1}
sub GL_OFFSET_TEXTURE_2D_NV {0x86E8}
sub GL_OFFSET_TEXTURE_2D_SCALE_NV {0x86E2}
sub GL_OFFSET_TEXTURE_BIAS_NV {0x86E3}
sub GL_OFFSET_TEXTURE_MATRIX_NV {0x86E1}
sub GL_OFFSET_TEXTURE_RECTANGLE_NV {0x864C}
sub GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV {0x864D}
sub GL_OFFSET_TEXTURE_SCALE_NV {0x86E2}
sub GL_ONE {1}
sub GL_ONE_MINUS_CONSTANT_ALPHA {0x8004}
sub GL_ONE_MINUS_CONSTANT_ALPHA_EXT {0x8004}
sub GL_ONE_MINUS_CONSTANT_COLOR {0x8002}
sub GL_ONE_MINUS_CONSTANT_COLOR_EXT {0x8002}
sub GL_ONE_MINUS_DST_ALPHA {0x0305}
sub GL_ONE_MINUS_DST_COLOR {0x0307}
sub GL_ONE_MINUS_SRC_ALPHA {0x0303}
sub GL_ONE_MINUS_SRC_COLOR {0x0301}
sub GL_OPERAND0_ALPHA {0x8598}
sub GL_OPERAND0_ALPHA_ARB {0x8598}
sub GL_OPERAND0_ALPHA_EXT {0x8598}
sub GL_OPERAND0_RGB {0x8590}
sub GL_OPERAND0_RGB_ARB {0x8590}
sub GL_OPERAND0_RGB_EXT {0x8590}
sub GL_OPERAND1_ALPHA {0x8599}
sub GL_OPERAND1_ALPHA_ARB {0x8599}
sub GL_OPERAND1_ALPHA_EXT {0x8599}
sub GL_OPERAND1_RGB {0x8591}
sub GL_OPERAND1_RGB_ARB {0x8591}
sub GL_OPERAND1_RGB_EXT {0x8591}
sub GL_OPERAND2_ALPHA {0x859A}
sub GL_OPERAND2_ALPHA_ARB {0x859A}
sub GL_OPERAND2_ALPHA_EXT {0x859A}
sub GL_OPERAND2_RGB {0x8592}
sub GL_OPERAND2_RGB_ARB {0x8592}
sub GL_OPERAND2_RGB_EXT {0x8592}
sub GL_OPERAND3_ALPHA_NV {0x859B}
sub GL_OPERAND3_RGB_NV {0x8593}
sub GL_OR {0x1507}
sub GL_ORDER {0x0A01}
sub GL_OR_INVERTED {0x150D}
sub GL_OR_REVERSE {0x150B}
sub GL_OUT_OF_MEMORY {0x0505}
sub GL_PACK_ALIGNMENT {0x0D05}
sub GL_PACK_IMAGE_HEIGHT {0x806C}
sub GL_PACK_IMAGE_HEIGHT_EXT {0x806C}
sub GL_PACK_LSB_FIRST {0x0D01}
sub GL_PACK_ROW_LENGTH {0x0D02}
sub GL_PACK_SKIP_IMAGES {0x806B}
sub GL_PACK_SKIP_IMAGES_EXT {0x806B}
sub GL_PACK_SKIP_PIXELS {0x0D04}
sub GL_PACK_SKIP_ROWS {0x0D03}
sub GL_PACK_SWAP_BYTES {0x0D00}
sub GL_PASS_THROUGH_NV {0x86E6}
sub GL_PASS_THROUGH_TOKEN {0x0700}
sub GL_PERSPECTIVE_CORRECTION_HINT {0x0C50}
sub GL_PER_STAGE_CONSTANTS_NV {0x8535}
sub GL_PIXEL_COUNTER_BITS_NV {0x8864}
sub GL_PIXEL_COUNT_AVAILABLE_NV {0x8867}
sub GL_PIXEL_COUNT_NV {0x8866}
sub GL_PIXEL_MAP_A_TO_A {0x0C79}
sub GL_PIXEL_MAP_A_TO_A_SIZE {0x0CB9}
sub GL_PIXEL_MAP_B_TO_B {0x0C78}
sub GL_PIXEL_MAP_B_TO_B_SIZE {0x0CB8}
sub GL_PIXEL_MAP_G_TO_G {0x0C77}
sub GL_PIXEL_MAP_G_TO_G_SIZE {0x0CB7}
sub GL_PIXEL_MAP_I_TO_A {0x0C75}
sub GL_PIXEL_MAP_I_TO_A_SIZE {0x0CB5}
sub GL_PIXEL_MAP_I_TO_B {0x0C74}
sub GL_PIXEL_MAP_I_TO_B_SIZE {0x0CB4}
sub GL_PIXEL_MAP_I_TO_G {0x0C73}
sub GL_PIXEL_MAP_I_TO_G_SIZE {0x0CB3}
sub GL_PIXEL_MAP_I_TO_I {0x0C70}
sub GL_PIXEL_MAP_I_TO_I_SIZE {0x0CB0}
sub GL_PIXEL_MAP_I_TO_R {0x0C72}
sub GL_PIXEL_MAP_I_TO_R_SIZE {0x0CB2}
sub GL_PIXEL_MAP_R_TO_R {0x0C76}
sub GL_PIXEL_MAP_R_TO_R_SIZE {0x0CB6}
sub GL_PIXEL_MAP_S_TO_S {0x0C71}
sub GL_PIXEL_MAP_S_TO_S_SIZE {0x0CB1}
sub GL_PIXEL_MODE_BIT {0x00000020}
sub GL_POINT {0x1B00}
sub GL_POINTS {0x0000}
sub GL_POINT_BIT {0x00000002}
sub GL_POINT_DISTANCE_ATTENUATION {0x8129}
sub GL_POINT_DISTANCE_ATTENUATION_ARB {0x8129}
sub GL_POINT_FADE_THRESHOLD_SIZE {0x8128}
sub GL_POINT_FADE_THRESHOLD_SIZE_ARB {0x8128}
sub GL_POINT_FADE_THRESHOLD_SIZE_EXT {0x8128}
sub GL_POINT_SIZE {0x0B11}
sub GL_POINT_SIZE_GRANULARITY {0x0B13}
sub GL_POINT_SIZE_MAX {0x8127}
sub GL_POINT_SIZE_MAX_ARB {0x8127}
sub GL_POINT_SIZE_MAX_EXT {0x8127}
sub GL_POINT_SIZE_MIN {0x8126}
sub GL_POINT_SIZE_MIN_ARB {0x8126}
sub GL_POINT_SIZE_MIN_EXT {0x8126}
sub GL_POINT_SIZE_RANGE {0x0B12}
sub GL_POINT_SMOOTH {0x0B10}
sub GL_POINT_SMOOTH_HINT {0x0C51}
sub GL_POINT_SPRITE_NV {0x8861}
sub GL_POINT_SPRITE_R_MODE_NV {0x8863}
sub GL_POINT_TOKEN {0x0701}
sub GL_POLYGON {0x0009}
sub GL_POLYGON_BIT {0x00000008}
sub GL_POLYGON_MODE {0x0B40}
sub GL_POLYGON_OFFSET_FACTOR {0x8038}
sub GL_POLYGON_OFFSET_FILL {0x8037}
sub GL_POLYGON_OFFSET_LINE {0x2A02}
sub GL_POLYGON_OFFSET_POINT {0x2A01}
sub GL_POLYGON_OFFSET_UNITS {0x2A00}
sub GL_POLYGON_SMOOTH {0x0B41}
sub GL_POLYGON_SMOOTH_HINT {0x0C53}
sub GL_POLYGON_STIPPLE {0x0B42}
sub GL_POLYGON_STIPPLE_BIT {0x00000010}
sub GL_POLYGON_TOKEN {0x0703}
sub GL_POSITION {0x1203}
sub GL_POST_COLOR_MATRIX_ALPHA_BIAS {0x80BB}
sub GL_POST_COLOR_MATRIX_ALPHA_SCALE {0x80B7}
sub GL_POST_COLOR_MATRIX_BLUE_BIAS {0x80BA}
sub GL_POST_COLOR_MATRIX_BLUE_SCALE {0x80B6}
sub GL_POST_COLOR_MATRIX_COLOR_TABLE {0x80D2}
sub GL_POST_COLOR_MATRIX_GREEN_BIAS {0x80B9}
sub GL_POST_COLOR_MATRIX_GREEN_SCALE {0x80B5}
sub GL_POST_COLOR_MATRIX_RED_BIAS {0x80B8}
sub GL_POST_COLOR_MATRIX_RED_SCALE {0x80B4}
sub GL_POST_CONVOLUTION_ALPHA_BIAS {0x8023}
sub GL_POST_CONVOLUTION_ALPHA_SCALE {0x801F}
sub GL_POST_CONVOLUTION_BLUE_BIAS {0x8022}
sub GL_POST_CONVOLUTION_BLUE_SCALE {0x801E}
sub GL_POST_CONVOLUTION_COLOR_TABLE {0x80D1}
sub GL_POST_CONVOLUTION_GREEN_BIAS {0x8021}
sub GL_POST_CONVOLUTION_GREEN_SCALE {0x801D}
sub GL_POST_CONVOLUTION_RED_BIAS {0x8020}
sub GL_POST_CONVOLUTION_RED_SCALE {0x801C}
sub GL_PREVIOUS {0x8578}
sub GL_PREVIOUS_ARB {0x8578}
sub GL_PREVIOUS_EXT {0x8578}
sub GL_PREVIOUS_TEXTURE_INPUT_NV {0x86E4}
sub GL_PRIMARY_COLOR {0x8577}
sub GL_PRIMARY_COLOR_ARB {0x8577}
sub GL_PRIMARY_COLOR_EXT {0x8577}
sub GL_PRIMARY_COLOR_NV {0x852C}
sub GL_PRIMITIVE_RESTART_INDEX_NV {0x8559}
sub GL_PRIMITIVE_RESTART_NV {0x8558}
sub GL_PROGRAM_ADDRESS_REGISTERS_ARB {0x88B0}
sub GL_PROGRAM_ALU_INSTRUCTIONS_ARB {0x8805}
sub GL_PROGRAM_ATTRIBS_ARB {0x88AC}
sub GL_PROGRAM_BINDING_ARB {0x8677}
sub GL_PROGRAM_ERROR_POSITION_ARB {0x864B}
sub GL_PROGRAM_ERROR_POSITION_NV {0x864B}
sub GL_PROGRAM_ERROR_STRING_ARB {0x8874}
sub GL_PROGRAM_ERROR_STRING_NV {0x8874}
sub GL_PROGRAM_FORMAT_ARB {0x8876}
sub GL_PROGRAM_FORMAT_ASCII_ARB {0x8875}
sub GL_PROGRAM_INSTRUCTIONS_ARB {0x88A0}
sub GL_PROGRAM_LENGTH_ARB {0x8627}
sub GL_PROGRAM_LENGTH_NV {0x8627}
sub GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB {0x88B2}
sub GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB {0x8808}
sub GL_PROGRAM_NATIVE_ATTRIBS_ARB {0x88AE}
sub GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB {0x88A2}
sub GL_PROGRAM_NATIVE_PARAMETERS_ARB {0x88AA}
sub GL_PROGRAM_NATIVE_TEMPORARIES_ARB {0x88A6}
sub GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB {0x880A}
sub GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB {0x8809}
sub GL_PROGRAM_PARAMETERS_ARB {0x88A8}
sub GL_PROGRAM_PARAMETER_NV {0x8644}
sub GL_PROGRAM_RESIDENT_NV {0x8647}
sub GL_PROGRAM_STRING_ARB {0x8628}
sub GL_PROGRAM_STRING_NV {0x8628}
sub GL_PROGRAM_TARGET_NV {0x8646}
sub GL_PROGRAM_TEMPORARIES_ARB {0x88A4}
sub GL_PROGRAM_TEX_INDIRECTIONS_ARB {0x8807}
sub GL_PROGRAM_TEX_INSTRUCTIONS_ARB {0x8806}
sub GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB {0x88B6}
sub GL_PROJECTION {0x1701}
sub GL_PROJECTION_MATRIX {0x0BA7}
sub GL_PROJECTION_STACK_DEPTH {0x0BA4}
sub GL_PROXY_COLOR_TABLE {0x80D3}
sub GL_PROXY_HISTOGRAM {0x8025}
sub GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE {0x80D5}
sub GL_PROXY_POST_CONVOLUTION_COLOR_TABLE {0x80D4}
sub GL_PROXY_TEXTURE_1D {0x8063}
sub GL_PROXY_TEXTURE_2D {0x8064}
sub GL_PROXY_TEXTURE_3D {0x8070}
sub GL_PROXY_TEXTURE_3D_EXT {0x8070}
sub GL_PROXY_TEXTURE_CUBE_MAP {0x851B}
sub GL_PROXY_TEXTURE_CUBE_MAP_ARB {0x851B}
sub GL_PROXY_TEXTURE_CUBE_MAP_EXT {0x851B}
sub GL_PROXY_TEXTURE_RECTANGLE_NV {0x84F7}
sub GL_Q {0x2003}
sub GL_QUADRATIC_ATTENUATION {0x1209}
sub GL_QUADS {0x0007}
sub GL_QUAD_STRIP {0x0008}
sub GL_R {0x2002}
sub GL_R3_G3_B2 {0x2A10}
sub GL_READ_BUFFER {0x0C02}
sub GL_READ_ONLY_ARB {0x88B8}
sub GL_READ_PIXEL_DATA_RANGE_LENGTH_NV {0x887B}
sub GL_READ_PIXEL_DATA_RANGE_NV {0x8879}
sub GL_READ_PIXEL_DATA_RANGE_POINTER_NV {0x887D}
sub GL_READ_WRITE_ARB {0x88BA}
sub GL_RED {0x1903}
sub GL_REDUCE {0x8016}
sub GL_RED_BIAS {0x0D15}
sub GL_RED_BITS {0x0D52}
sub GL_RED_SCALE {0x0D14}
sub GL_REFLECTION_MAP {0x8512}
sub GL_REFLECTION_MAP_ARB {0x8512}
sub GL_REFLECTION_MAP_EXT {0x8512}
sub GL_REFLECTION_MAP_NV {0x8512}
sub GL_REGISTER_COMBINERS_NV {0x8522}
sub GL_RENDER {0x1C00}
sub GL_RENDERER {0x1F01}
sub GL_RENDER_MODE {0x0C40}
sub GL_REPEAT {0x2901}
sub GL_REPLACE {0x1E01}
sub GL_REPLICATE_BORDER {0x8153}
sub GL_RESCALE_NORMAL {0x803A}
sub GL_RESCALE_NORMAL_EXT {0x803A}
sub GL_RETURN {0x0102}
sub GL_RGB {0x1907}
sub GL_RGB10 {0x8052}
sub GL_RGB10_A2 {0x8059}
sub GL_RGB12 {0x8053}
sub GL_RGB16 {0x8054}
sub GL_RGB4 {0x804F}
sub GL_RGB4_S3TC {0x83A1}
sub GL_RGB5 {0x8050}
sub GL_RGB5_A1 {0x8057}
sub GL_RGB8 {0x8051}
sub GL_RGBA {0x1908}
sub GL_RGBA12 {0x805A}
sub GL_RGBA16 {0x805B}
sub GL_RGBA2 {0x8055}
sub GL_RGBA4 {0x8056}
sub GL_RGBA4_DXT5_S3TC {0x83A5}
sub GL_RGBA4_S3TC {0x83A3}
sub GL_RGBA8 {0x8058}
sub GL_RGBA_DXT5_S3TC {0x83A4}
sub GL_RGBA_MODE {0x0C31}
sub GL_RGBA_S3TC {0x83A2}
sub GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV {0x86D9}
sub GL_RGB_S3TC {0x83A0}
sub GL_RGB_SCALE {0x8573}
sub GL_RGB_SCALE_ARB {0x8573}
sub GL_RGB_SCALE_EXT {0x8573}
sub GL_RIGHT {0x0407}
sub GL_S {0x2000}
sub GL_SAMPLES {0x80A9}
sub GL_SAMPLES_ARB {0x80A9}
sub GL_SAMPLE_ALPHA_TO_COVERAGE {0x809E}
sub GL_SAMPLE_ALPHA_TO_COVERAGE_ARB {0x809E}
sub GL_SAMPLE_ALPHA_TO_ONE {0x809F}
sub GL_SAMPLE_ALPHA_TO_ONE_ARB {0x809F}
sub GL_SAMPLE_BUFFERS {0x80A8}
sub GL_SAMPLE_BUFFERS_ARB {0x80A8}
sub GL_SAMPLE_COVERAGE {0x80A0}
sub GL_SAMPLE_COVERAGE_ARB {0x80A0}
sub GL_SAMPLE_COVERAGE_INVERT {0x80AB}
sub GL_SAMPLE_COVERAGE_INVERT_ARB {0x80AB}
sub GL_SAMPLE_COVERAGE_VALUE {0x80AA}
sub GL_SAMPLE_COVERAGE_VALUE_ARB {0x80AA}
sub GL_SCALE_BY_FOUR_NV {0x853F}
sub GL_SCALE_BY_ONE_HALF_NV {0x8540}
sub GL_SCALE_BY_TWO_NV {0x853E}
sub GL_SCISSOR_BIT {0x00080000}
sub GL_SCISSOR_BOX {0x0C10}
sub GL_SCISSOR_TEST {0x0C11}
sub GL_SECONDARY_COLOR_ARRAY {0x845E}
sub GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB {0x889C}
sub GL_SECONDARY_COLOR_ARRAY_EXT {0x845E}
sub GL_SECONDARY_COLOR_ARRAY_POINTER {0x845D}
sub GL_SECONDARY_COLOR_ARRAY_POINTER_EXT {0x845D}
sub GL_SECONDARY_COLOR_ARRAY_SIZE {0x845A}
sub GL_SECONDARY_COLOR_ARRAY_SIZE_EXT {0x845A}
sub GL_SECONDARY_COLOR_ARRAY_STRIDE {0x845C}
sub GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT {0x845C}
sub GL_SECONDARY_COLOR_ARRAY_TYPE {0x845B}
sub GL_SECONDARY_COLOR_ARRAY_TYPE_EXT {0x845B}
sub GL_SECONDARY_COLOR_NV {0x852D}
sub GL_SELECT {0x1C02}
sub GL_SELECTED_TEXTURE_SGIS {0x835C}
sub GL_SELECTION_BUFFER_POINTER {0x0DF3}
sub GL_SELECTION_BUFFER_SIZE {0x0DF4}
sub GL_SEPARABLE_2D {0x8012}
sub GL_SEPARATE_SPECULAR_COLOR {0x81FA}
sub GL_SEPARATE_SPECULAR_COLOR_EXT {0x81FA}
sub GL_SET {0x150F}
sub GL_SHADER_CONSISTENT_NV {0x86DD}
sub GL_SHADER_OPERATION_NV {0x86DF}
sub GL_SHADE_MODEL {0x0B54}
sub GL_SHARED_TEXTURE_PALETTE_EXT {0x81FB}
sub GL_SHININESS {0x1601}
sub GL_SHORT {0x1402}
sub GL_SIGNED_ALPHA8_NV {0x8706}
sub GL_SIGNED_ALPHA_NV {0x8705}
sub GL_SIGNED_HILO16_NV {0x86FA}
sub GL_SIGNED_HILO8_NV {0x885F}
sub GL_SIGNED_HILO_NV {0x86F9}
sub GL_SIGNED_IDENTITY_NV {0x853C}
sub GL_SIGNED_INTENSITY8_NV {0x8708}
sub GL_SIGNED_INTENSITY_NV {0x8707}
sub GL_SIGNED_LUMINANCE8_ALPHA8_NV {0x8704}
sub GL_SIGNED_LUMINANCE8_NV {0x8702}
sub GL_SIGNED_LUMINANCE_ALPHA_NV {0x8703}
sub GL_SIGNED_LUMINANCE_NV {0x8701}
sub GL_SIGNED_NEGATE_NV {0x853D}
sub GL_SIGNED_RGB8_NV {0x86FF}
sub GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV {0x870D}
sub GL_SIGNED_RGBA8_NV {0x86FC}
sub GL_SIGNED_RGBA_NV {0x86FB}
sub GL_SIGNED_RGB_NV {0x86FE}
sub GL_SIGNED_RGB_UNSIGNED_ALPHA_NV {0x870C}
sub GL_SINGLE_COLOR {0x81F9}
sub GL_SINGLE_COLOR_EXT {0x81F9}
sub GL_SMOOTH {0x1D01}
sub GL_SMOOTH_LINE_WIDTH_GRANULARITY {0x0B23}
sub GL_SMOOTH_LINE_WIDTH_RANGE {0x0B22}
sub GL_SMOOTH_POINT_SIZE_GRANULARITY {0x0B13}
sub GL_SMOOTH_POINT_SIZE_RANGE {0x0B12}
sub GL_SOURCE0_ALPHA {0x8588}
sub GL_SOURCE0_ALPHA_ARB {0x8588}
sub GL_SOURCE0_ALPHA_EXT {0x8588}
sub GL_SOURCE0_RGB {0x8580}
sub GL_SOURCE0_RGB_ARB {0x8580}
sub GL_SOURCE0_RGB_EXT {0x8580}
sub GL_SOURCE1_ALPHA {0x8589}
sub GL_SOURCE1_ALPHA_ARB {0x8589}
sub GL_SOURCE1_ALPHA_EXT {0x8589}
sub GL_SOURCE1_RGB {0x8581}
sub GL_SOURCE1_RGB_ARB {0x8581}
sub GL_SOURCE1_RGB_EXT {0x8581}
sub GL_SOURCE2_ALPHA {0x858A}
sub GL_SOURCE2_ALPHA_ARB {0x858A}
sub GL_SOURCE2_ALPHA_EXT {0x858A}
sub GL_SOURCE2_RGB {0x8582}
sub GL_SOURCE2_RGB_ARB {0x8582}
sub GL_SOURCE2_RGB_EXT {0x8582}
sub GL_SOURCE3_ALPHA_NV {0x858B}
sub GL_SOURCE3_RGB_NV {0x8583}
sub GL_SPARE0_NV {0x852E}
sub GL_SPARE0_PLUS_SECONDARY_COLOR_NV {0x8532}
sub GL_SPARE1_NV {0x852F}
sub GL_SPECULAR {0x1202}
sub GL_SPHERE_MAP {0x2402}
sub GL_SPOT_CUTOFF {0x1206}
sub GL_SPOT_DIRECTION {0x1204}
sub GL_SPOT_EXPONENT {0x1205}
sub GL_SRC_ALPHA {0x0302}
sub GL_SRC_ALPHA_SATURATE {0x0308}
sub GL_SRC_COLOR {0x0300}
sub GL_STACK_OVERFLOW {0x0503}
sub GL_STACK_UNDERFLOW {0x0504}
sub GL_STATIC_COPY_ARB {0x88E6}
sub GL_STATIC_DRAW_ARB {0x88E4}
sub GL_STATIC_READ_ARB {0x88E5}
sub GL_STENCIL {0x1802}
sub GL_STENCIL_BITS {0x0D57}
sub GL_STENCIL_BUFFER_BIT {0x00000400}
sub GL_STENCIL_CLEAR_VALUE {0x0B91}
sub GL_STENCIL_FAIL {0x0B94}
sub GL_STENCIL_FUNC {0x0B92}
sub GL_STENCIL_INDEX {0x1901}
sub GL_STENCIL_PASS_DEPTH_FAIL {0x0B95}
sub GL_STENCIL_PASS_DEPTH_PASS {0x0B96}
sub GL_STENCIL_REF {0x0B97}
sub GL_STENCIL_TEST {0x0B90}
sub GL_STENCIL_TEST_TWO_SIDE_EXT {0x8910}
sub GL_STENCIL_VALUE_MASK {0x0B93}
sub GL_STENCIL_WRITEMASK {0x0B98}
sub GL_STEREO {0x0C33}
sub GL_STREAM_COPY_ARB {0x88E2}
sub GL_STREAM_DRAW_ARB {0x88E0}
sub GL_STREAM_READ_ARB {0x88E1}
sub GL_SUBPIXEL_BITS {0x0D50}
sub GL_SUBTRACT {0x84E7}
sub GL_SUBTRACT_ARB {0x84E7}
sub GL_T {0x2001}
sub GL_T2F_C3F_V3F {0x2A2A}
sub GL_T2F_C4F_N3F_V3F {0x2A2C}
sub GL_T2F_C4UB_V3F {0x2A29}
sub GL_T2F_N3F_V3F {0x2A2B}
sub GL_T2F_V3F {0x2A27}
sub GL_T4F_C4F_N3F_V4F {0x2A2D}
sub GL_T4F_V4F {0x2A28}
sub GL_TABLE_TOO_LARGE {0x8031}
sub GL_TABLE_TOO_LARGE_EXT {0x8031}
sub GL_TBUFFER_WRITE_MASK_3DFX {0x86D8}
sub GL_TEXTURE {0x1702}
sub GL_TEXTURE0 {0x84C0}
sub GL_TEXTURE0_ARB {0x84C0}
sub GL_TEXTURE0_SGIS {0x835E}
sub GL_TEXTURE1 {0x84C1}
sub GL_TEXTURE10 {0x84CA}
sub GL_TEXTURE10_ARB {0x84CA}
sub GL_TEXTURE11 {0x84CB}
sub GL_TEXTURE11_ARB {0x84CB}
sub GL_TEXTURE12 {0x84CC}
sub GL_TEXTURE12_ARB {0x84CC}
sub GL_TEXTURE13 {0x84CD}
sub GL_TEXTURE13_ARB {0x84CD}
sub GL_TEXTURE14 {0x84CE}
sub GL_TEXTURE14_ARB {0x84CE}
sub GL_TEXTURE15 {0x84CF}
sub GL_TEXTURE15_ARB {0x84CF}
sub GL_TEXTURE16 {0x84D0}
sub GL_TEXTURE16_ARB {0x84D0}
sub GL_TEXTURE17 {0x84D1}
sub GL_TEXTURE17_ARB {0x84D1}
sub GL_TEXTURE18 {0x84D2}
sub GL_TEXTURE18_ARB {0x84D2}
sub GL_TEXTURE19 {0x84D3}
sub GL_TEXTURE19_ARB {0x84D3}
sub GL_TEXTURE1_ARB {0x84C1}
sub GL_TEXTURE1_SGIS {0x835F}
sub GL_TEXTURE2 {0x84C2}
sub GL_TEXTURE20 {0x84D4}
sub GL_TEXTURE20_ARB {0x84D4}
sub GL_TEXTURE21 {0x84D5}
sub GL_TEXTURE21_ARB {0x84D5}
sub GL_TEXTURE22 {0x84D6}
sub GL_TEXTURE22_ARB {0x84D6}
sub GL_TEXTURE23 {0x84D7}
sub GL_TEXTURE23_ARB {0x84D7}
sub GL_TEXTURE24 {0x84D8}
sub GL_TEXTURE24_ARB {0x84D8}
sub GL_TEXTURE25 {0x84D9}
sub GL_TEXTURE25_ARB {0x84D9}
sub GL_TEXTURE26 {0x84DA}
sub GL_TEXTURE26_ARB {0x84DA}
sub GL_TEXTURE27 {0x84DB}
sub GL_TEXTURE27_ARB {0x84DB}
sub GL_TEXTURE28 {0x84DC}
sub GL_TEXTURE28_ARB {0x84DC}
sub GL_TEXTURE29 {0x84DD}
sub GL_TEXTURE29_ARB {0x84DD}
sub GL_TEXTURE2_ARB {0x84C2}
sub GL_TEXTURE2_SGIS {0x8360}
sub GL_TEXTURE3 {0x84C3}
sub GL_TEXTURE30 {0x84DE}
sub GL_TEXTURE30_ARB {0x84DE}
sub GL_TEXTURE31 {0x84DF}
sub GL_TEXTURE31_ARB {0x84DF}
sub GL_TEXTURE3_ARB {0x84C3}
sub GL_TEXTURE3_SGIS {0x8361}
sub GL_TEXTURE4 {0x84C4}
sub GL_TEXTURE4_ARB {0x84C4}
sub GL_TEXTURE5 {0x84C5}
sub GL_TEXTURE5_ARB {0x84C5}
sub GL_TEXTURE6 {0x84C6}
sub GL_TEXTURE6_ARB {0x84C6}
sub GL_TEXTURE7 {0x84C7}
sub GL_TEXTURE7_ARB {0x84C7}
sub GL_TEXTURE8 {0x84C8}
sub GL_TEXTURE8_ARB {0x84C8}
sub GL_TEXTURE9 {0x84C9}
sub GL_TEXTURE9_ARB {0x84C9}
sub GL_TEXTURE_1D {0x0DE0}
sub GL_TEXTURE_2D {0x0DE1}
sub GL_TEXTURE_3D {0x806F}
sub GL_TEXTURE_3D_EXT {0x806F}
sub GL_TEXTURE_ALPHA_SIZE {0x805F}
sub GL_TEXTURE_BASE_LEVEL {0x813C}
sub GL_TEXTURE_BASE_LEVEL_SGIS {0x813C}
sub GL_TEXTURE_BINDING_1D {0x8068}
sub GL_TEXTURE_BINDING_2D {0x8069}
sub GL_TEXTURE_BINDING_3D {0x806A}
sub GL_TEXTURE_BINDING_CUBE_MAP {0x8514}
sub GL_TEXTURE_BINDING_CUBE_MAP_ARB {0x8514}
sub GL_TEXTURE_BINDING_CUBE_MAP_EXT {0x8514}
sub GL_TEXTURE_BINDING_RECTANGLE_NV {0x84F6}
sub GL_TEXTURE_BIT {0x00040000}
sub GL_TEXTURE_BLUE_SIZE {0x805E}
sub GL_TEXTURE_BORDER {0x1005}
sub GL_TEXTURE_BORDER_COLOR {0x1004}
sub GL_TEXTURE_BORDER_VALUES_NV {0x871A}
sub GL_TEXTURE_COLOR_WRITEMASK_SGIS {0x81EF}
sub GL_TEXTURE_COMPARE_FAIL_VALUE_ARB {0x80BF}
sub GL_TEXTURE_COMPARE_FUNC {0x884D}
sub GL_TEXTURE_COMPARE_FUNC_ARB {0x884D}
sub GL_TEXTURE_COMPARE_MODE {0x884C}
sub GL_TEXTURE_COMPARE_MODE_ARB {0x884C}
sub GL_TEXTURE_COMPARE_OPERATOR_SGIX {0x819B}
sub GL_TEXTURE_COMPARE_SGIX {0x819A}
sub GL_TEXTURE_COMPONENTS {0x1003}
sub GL_TEXTURE_COMPRESSED {0x86A1}
sub GL_TEXTURE_COMPRESSED_ARB {0x86A1}
sub GL_TEXTURE_COMPRESSED_IMAGE_SIZE {0x86A0}
sub GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB {0x86A0}
sub GL_TEXTURE_COMPRESSION_HINT {0x84EF}
sub GL_TEXTURE_COMPRESSION_HINT_ARB {0x84EF}
sub GL_TEXTURE_COORD_ARRAY {0x8078}
sub GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB {0x889A}
sub GL_TEXTURE_COORD_ARRAY_COUNT_EXT {0x808B}
sub GL_TEXTURE_COORD_ARRAY_EXT {0x8078}
sub GL_TEXTURE_COORD_ARRAY_POINTER {0x8092}
sub GL_TEXTURE_COORD_ARRAY_POINTER_EXT {0x8092}
sub GL_TEXTURE_COORD_ARRAY_SIZE {0x8088}
sub GL_TEXTURE_COORD_ARRAY_SIZE_EXT {0x8088}
sub GL_TEXTURE_COORD_ARRAY_STRIDE {0x808A}
sub GL_TEXTURE_COORD_ARRAY_STRIDE_EXT {0x808A}
sub GL_TEXTURE_COORD_ARRAY_TYPE {0x8089}
sub GL_TEXTURE_COORD_ARRAY_TYPE_EXT {0x8089}
sub GL_TEXTURE_CUBE_MAP {0x8513}
sub GL_TEXTURE_CUBE_MAP_ARB {0x8513}
sub GL_TEXTURE_CUBE_MAP_EXT {0x8513}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_X {0x8516}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB {0x8516}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT {0x8516}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Y {0x8518}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB {0x8518}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT {0x8518}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Z {0x851A}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB {0x851A}
sub GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT {0x851A}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_X {0x8515}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB {0x8515}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT {0x8515}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Y {0x8517}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB {0x8517}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT {0x8517}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Z {0x8519}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB {0x8519}
sub GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT {0x8519}
sub GL_TEXTURE_DEPTH {0x8071}
sub GL_TEXTURE_DEPTH_EXT {0x8071}
sub GL_TEXTURE_DEPTH_SIZE {0x884A}
sub GL_TEXTURE_DEPTH_SIZE_ARB {0x884A}
sub GL_TEXTURE_DS_SIZE_NV {0x871D}
sub GL_TEXTURE_DT_SIZE_NV {0x871E}
sub GL_TEXTURE_ENV {0x2300}
sub GL_TEXTURE_ENV_COLOR {0x2201}
sub GL_TEXTURE_ENV_MODE {0x2200}
sub GL_TEXTURE_FILTER_CONTROL {0x8500}
sub GL_TEXTURE_FILTER_CONTROL_EXT {0x8500}
sub GL_TEXTURE_FLOAT_COMPONENTS_NV {0x888C}
sub GL_TEXTURE_GEN_MODE {0x2500}
sub GL_TEXTURE_GEN_Q {0x0C63}
sub GL_TEXTURE_GEN_R {0x0C62}
sub GL_TEXTURE_GEN_S {0x0C60}
sub GL_TEXTURE_GEN_T {0x0C61}
sub GL_TEXTURE_GEQUAL_R_SGIX {0x819D}
sub GL_TEXTURE_GREEN_SIZE {0x805D}
sub GL_TEXTURE_HEIGHT {0x1001}
sub GL_TEXTURE_HI_SIZE_NV {0x871B}
sub GL_TEXTURE_INDEX_SIZE_EXT {0x80ED}
sub GL_TEXTURE_INTENSITY_SIZE {0x8061}
sub GL_TEXTURE_INTERNAL_FORMAT {0x1003}
sub GL_TEXTURE_LEQUAL_R_SGIX {0x819C}
sub GL_TEXTURE_LOD_BIAS {0x8501}
sub GL_TEXTURE_LOD_BIAS_EXT {0x8501}
sub GL_TEXTURE_LO_SIZE_NV {0x871C}
sub GL_TEXTURE_LUMINANCE_SIZE {0x8060}
sub GL_TEXTURE_MAG_FILTER {0x2800}
sub GL_TEXTURE_MAG_SIZE_NV {0x871F}
sub GL_TEXTURE_MATRIX {0x0BA8}
sub GL_TEXTURE_MAX_ANISOTROPY_EXT {0x84FE}
sub GL_TEXTURE_MAX_LEVEL {0x813D}
sub GL_TEXTURE_MAX_LEVEL_SGIS {0x813D}
sub GL_TEXTURE_MAX_LOD {0x813B}
sub GL_TEXTURE_MAX_LOD_SGIS {0x813B}
sub GL_TEXTURE_MIN_FILTER {0x2801}
sub GL_TEXTURE_MIN_LOD {0x813A}
sub GL_TEXTURE_MIN_LOD_SGIS {0x813A}
sub GL_TEXTURE_PRIORITY {0x8066}
sub GL_TEXTURE_RECTANGLE_NV {0x84F5}
sub GL_TEXTURE_RED_SIZE {0x805C}
sub GL_TEXTURE_RESIDENT {0x8067}
sub GL_TEXTURE_SHADER_NV {0x86DE}
sub GL_TEXTURE_STACK_DEPTH {0x0BA5}
sub GL_TEXTURE_UNSIGNED_REMAP_MODE_NV {0x888F}
sub GL_TEXTURE_WIDTH {0x1000}
sub GL_TEXTURE_WRAP_R {0x8072}
sub GL_TEXTURE_WRAP_R_EXT {0x8072}
sub GL_TEXTURE_WRAP_S {0x2802}
sub GL_TEXTURE_WRAP_T {0x2803}
sub GL_TRACK_MATRIX_NV {0x8648}
sub GL_TRACK_MATRIX_TRANSFORM_NV {0x8649}
sub GL_TRANSFORM_BIT {0x00001000}
sub GL_TRANSFORM_HINT_APPLE {0x85B1}
sub GL_TRANSPOSE_COLOR_MATRIX {0x84E6}
sub GL_TRANSPOSE_COLOR_MATRIX_ARB {0x84E6}
sub GL_TRANSPOSE_CURRENT_MATRIX_ARB {0x88B7}
sub GL_TRANSPOSE_MODELVIEW_MATRIX {0x84E3}
sub GL_TRANSPOSE_MODELVIEW_MATRIX_ARB {0x84E3}
sub GL_TRANSPOSE_NV {0x862C}
sub GL_TRANSPOSE_PROJECTION_MATRIX {0x84E4}
sub GL_TRANSPOSE_PROJECTION_MATRIX_ARB {0x84E4}
sub GL_TRANSPOSE_TEXTURE_MATRIX {0x84E5}
sub GL_TRANSPOSE_TEXTURE_MATRIX_ARB {0x84E5}
sub GL_TRIANGLES {0x0004}
sub GL_TRIANGLE_FAN {0x0006}
sub GL_TRIANGLE_STRIP {0x0005}
sub GL_TRUE {1}
sub GL_UNPACK_ALIGNMENT {0x0CF5}
sub GL_UNPACK_IMAGE_HEIGHT {0x806E}
sub GL_UNPACK_IMAGE_HEIGHT_EXT {0x806E}
sub GL_UNPACK_LSB_FIRST {0x0CF1}
sub GL_UNPACK_ROW_LENGTH {0x0CF2}
sub GL_UNPACK_SKIP_IMAGES {0x806D}
sub GL_UNPACK_SKIP_IMAGES_EXT {0x806D}
sub GL_UNPACK_SKIP_PIXELS {0x0CF4}
sub GL_UNPACK_SKIP_ROWS {0x0CF3}
sub GL_UNPACK_SWAP_BYTES {0x0CF0}
sub GL_UNSIGNED_BYTE {0x1401}
sub GL_UNSIGNED_BYTE_2_3_3_REV {0x8362}
sub GL_UNSIGNED_BYTE_3_3_2 {0x8032}
sub GL_UNSIGNED_BYTE_3_3_2_EXT {0x8032}
sub GL_UNSIGNED_IDENTITY_NV {0x8536}
sub GL_UNSIGNED_INT {0x1405}
sub GL_UNSIGNED_INT_10_10_10_2 {0x8036}
sub GL_UNSIGNED_INT_10_10_10_2_EXT {0x8036}
sub GL_UNSIGNED_INT_24_8_NV {0x84FA}
sub GL_UNSIGNED_INT_2_10_10_10_REV {0x8368}
sub GL_UNSIGNED_INT_8_8_8_8 {0x8035}
sub GL_UNSIGNED_INT_8_8_8_8_EXT {0x8035}
sub GL_UNSIGNED_INT_8_8_8_8_REV {0x8367}
sub GL_UNSIGNED_INT_8_8_S8_S8_REV_NV {0x86DB}
sub GL_UNSIGNED_INT_S10_S11_S11_REV_NV {0x886B}
sub GL_UNSIGNED_INT_S8_S8_8_8_NV {0x86DA}
sub GL_UNSIGNED_INVERT_NV {0x8537}
sub GL_UNSIGNED_SHORT {0x1403}
sub GL_UNSIGNED_SHORT_1_5_5_5_REV {0x8366}
sub GL_UNSIGNED_SHORT_4_4_4_4 {0x8033}
sub GL_UNSIGNED_SHORT_4_4_4_4_EXT {0x8033}
sub GL_UNSIGNED_SHORT_4_4_4_4_REV {0x8365}
sub GL_UNSIGNED_SHORT_5_5_5_1 {0x8034}
sub GL_UNSIGNED_SHORT_5_5_5_1_EXT {0x8034}
sub GL_UNSIGNED_SHORT_5_6_5 {0x8363}
sub GL_UNSIGNED_SHORT_5_6_5_REV {0x8364}
sub GL_V2F {0x2A20}
sub GL_V3F {0x2A21}
sub GL_VARIABLE_A_NV {0x8523}
sub GL_VARIABLE_B_NV {0x8524}
sub GL_VARIABLE_C_NV {0x8525}
sub GL_VARIABLE_D_NV {0x8526}
sub GL_VARIABLE_E_NV {0x8527}
sub GL_VARIABLE_F_NV {0x8528}
sub GL_VARIABLE_G_NV {0x8529}
sub GL_VENDOR {0x1F00}
sub GL_VERSION {0x1F02}
sub GL_VERTEX_ARRAY {0x8074}
sub GL_VERTEX_ARRAY_BUFFER_BINDING_ARB {0x8896}
sub GL_VERTEX_ARRAY_COUNT_EXT {0x807D}
sub GL_VERTEX_ARRAY_EXT {0x8074}
sub GL_VERTEX_ARRAY_POINTER {0x808E}
sub GL_VERTEX_ARRAY_POINTER_EXT {0x808E}
sub GL_VERTEX_ARRAY_RANGE_LENGTH_NV {0x851E}
sub GL_VERTEX_ARRAY_RANGE_NV {0x851D}
sub GL_VERTEX_ARRAY_RANGE_POINTER_NV {0x8521}
sub GL_VERTEX_ARRAY_RANGE_VALID_NV {0x851F}
sub GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV {0x8533}
sub GL_VERTEX_ARRAY_SIZE {0x807A}
sub GL_VERTEX_ARRAY_SIZE_EXT {0x807A}
sub GL_VERTEX_ARRAY_STRIDE {0x807C}
sub GL_VERTEX_ARRAY_STRIDE_EXT {0x807C}
sub GL_VERTEX_ARRAY_TYPE {0x807B}
sub GL_VERTEX_ARRAY_TYPE_EXT {0x807B}
sub GL_VERTEX_ATTRIB_ARRAY0_NV {0x8650}
sub GL_VERTEX_ATTRIB_ARRAY10_NV {0x865A}
sub GL_VERTEX_ATTRIB_ARRAY11_NV {0x865B}
sub GL_VERTEX_ATTRIB_ARRAY12_NV {0x865C}
sub GL_VERTEX_ATTRIB_ARRAY13_NV {0x865D}
sub GL_VERTEX_ATTRIB_ARRAY14_NV {0x865E}
sub GL_VERTEX_ATTRIB_ARRAY15_NV {0x865F}
sub GL_VERTEX_ATTRIB_ARRAY1_NV {0x8651}
sub GL_VERTEX_ATTRIB_ARRAY2_NV {0x8652}
sub GL_VERTEX_ATTRIB_ARRAY3_NV {0x8653}
sub GL_VERTEX_ATTRIB_ARRAY4_NV {0x8654}
sub GL_VERTEX_ATTRIB_ARRAY5_NV {0x8655}
sub GL_VERTEX_ATTRIB_ARRAY6_NV {0x8656}
sub GL_VERTEX_ATTRIB_ARRAY7_NV {0x8657}
sub GL_VERTEX_ATTRIB_ARRAY8_NV {0x8658}
sub GL_VERTEX_ATTRIB_ARRAY9_NV {0x8659}
sub GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB {0x889F}
sub GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB {0x8622}
sub GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB {0x886A}
sub GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB {0x8645}
sub GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB {0x8623}
sub GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB {0x8624}
sub GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB {0x8625}
sub GL_VERTEX_PROGRAM_ARB {0x8620}
sub GL_VERTEX_PROGRAM_BINDING_NV {0x864A}
sub GL_VERTEX_PROGRAM_NV {0x8620}
sub GL_VERTEX_PROGRAM_POINT_SIZE_ARB {0x8642}
sub GL_VERTEX_PROGRAM_POINT_SIZE_NV {0x8642}
sub GL_VERTEX_PROGRAM_TWO_SIDE_ARB {0x8643}
sub GL_VERTEX_PROGRAM_TWO_SIDE_NV {0x8643}
sub GL_VERTEX_STATE_PROGRAM_NV {0x8621}
sub GL_VERTEX_WEIGHTING_EXT {0x8509}
sub GL_VERTEX_WEIGHT_ARRAY_EXT {0x850C}
sub GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT {0x8510}
sub GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT {0x850D}
sub GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT {0x850F}
sub GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT {0x850E}
sub GL_VIBRANCE_BIAS_NV {0x8719}
sub GL_VIBRANCE_SCALE_NV {0x8713}
sub GL_VIEWPORT {0x0BA2}
sub GL_VIEWPORT_BIT {0x00000800}
sub GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB {0x889E}
sub GL_WRITE_ONLY_ARB {0x88B9}
sub GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV {0x887A}
sub GL_WRITE_PIXEL_DATA_RANGE_NV {0x8878}
sub GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV {0x887C}
sub GL_XOR {0x1506}
sub GL_YCRYCB_422_NVX {0x600B}
sub GL_ZERO {0}
sub GL_ZOOM_X {0x0D16}
sub GL_ZOOM_Y {0x0D17}

1;
