/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;

public class SelectionComponentRepainter
extends FigureAdapter
implements PropertyChangeListener,
FigureSelectionListener,
Disposable {
    private DrawingEditor editor;
    private JComponent component;

    public SelectionComponentRepainter(DrawingEditor drawingEditor, JComponent jComponent) {
        this.editor = drawingEditor;
        this.component = jComponent;
        if (drawingEditor != null) {
            if (drawingEditor.getActiveView() != null) {
                DrawingView drawingView = drawingEditor.getActiveView();
                drawingView.addPropertyChangeListener(this);
                drawingView.addFigureSelectionListener(this);
                if (drawingView.getDrawing() != null) {
                    drawingView.getDrawing().addFigureListener(this);
                }
            }
            drawingEditor.addPropertyChangeListener(this);
        }
    }

    @Override
    public void attributeChanged(FigureEvent figureEvent) {
        this.component.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "activeView") {
            DrawingView drawingView = (DrawingView)propertyChangeEvent.getOldValue();
            if (drawingView != null) {
                drawingView.removePropertyChangeListener(this);
                drawingView.removeFigureSelectionListener(this);
                if (drawingView.getDrawing() != null) {
                    drawingView.getDrawing().removeFigureListener(this);
                }
            }
            if ((drawingView = (DrawingView)propertyChangeEvent.getNewValue()) != null) {
                drawingView.addPropertyChangeListener(this);
                drawingView.addFigureSelectionListener(this);
                if (drawingView.getDrawing() != null) {
                    drawingView.getDrawing().addFigureListener(this);
                }
            }
            this.component.repaint();
        } else if (string == "drawing") {
            Drawing drawing = (Drawing)propertyChangeEvent.getOldValue();
            if (drawing != null) {
                drawing.removeFigureListener(this);
            }
            if ((drawing = (Drawing)propertyChangeEvent.getNewValue()) != null) {
                drawing.addFigureListener(this);
            }
            this.component.repaint();
        } else {
            this.component.repaint();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.component.repaint();
    }

    @Override
    public void dispose() {
        if (this.editor != null) {
            if (this.editor.getActiveView() != null) {
                DrawingView drawingView = this.editor.getActiveView();
                drawingView.removePropertyChangeListener(this);
                drawingView.removeFigureSelectionListener(this);
                if (drawingView.getDrawing() != null) {
                    drawingView.getDrawing().removeFigureListener(this);
                }
            }
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        this.component = null;
    }
}

