/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseResourceCollectionContainer
extends DataType
implements ResourceCollection,
Cloneable {
    private List rc = new ArrayList();
    private Collection coll = null;
    private boolean cache = true;

    public synchronized void setCache(boolean b) {
        this.cache = b;
    }

    public synchronized boolean isCache() {
        return this.cache;
    }

    public synchronized void clear() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.rc.clear();
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void add(ResourceCollection c) throws BuildException {
        Project p;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        if (Project.getProject(c) == null && (p = this.getProject()) != null) {
            p.setProjectReference(c);
        }
        this.rc.add(c);
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void addAll(Collection c) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        try {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.add((ResourceCollection)i.next());
            }
        }
        catch (ClassCastException e) {
            throw new BuildException(e);
        }
    }

    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        return new FailFast(this, this.cacheCollection().iterator());
    }

    public synchronized int size() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.cacheCollection().size();
    }

    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        boolean goEarly = true;
        Iterator i = this.rc.iterator();
        while (goEarly && i.hasNext()) {
            goEarly = ((ResourceCollection)i.next()).isFilesystemOnly();
        }
        if (goEarly) {
            return true;
        }
        i = this.cacheCollection().iterator();
        while (i.hasNext()) {
            if (i.next() instanceof FileResource) continue;
            return false;
        }
        return true;
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            Iterator i = this.rc.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof DataType)) continue;
                stk.push(o);
                BaseResourceCollectionContainer.invokeCircularReferenceCheck((DataType)o, stk, p);
                stk.pop();
            }
            this.setChecked(true);
        }
    }

    protected final synchronized List getResourceCollections() {
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.rc);
    }

    protected abstract Collection getCollection();

    public Object clone() {
        try {
            BaseResourceCollectionContainer c = (BaseResourceCollectionContainer)super.clone();
            c.rc = new ArrayList(this.rc);
            c.coll = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.cacheCollection().size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(i.next());
        }
        return sb.toString();
    }

    private synchronized Collection cacheCollection() {
        if (this.coll == null || !this.isCache()) {
            this.coll = this.getCollection();
        }
        return this.coll;
    }
}

