/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionWidgetLayout
implements Layout {
    private final boolean useStacking = true;
    private final HashMap<Widget, Placement> placements = new HashMap();
    private final HashMap<Placement, ArrayList<Widget>> reverse = new HashMap();

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, float f) {
        assert (widget != null);
        assert (connectionWidgetLayoutAlignment != null);
        this.setConstraint(widget, new Placement(connectionWidgetLayoutAlignment, f));
    }

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, int n) {
        assert (widget != null);
        assert (connectionWidgetLayoutAlignment != null);
        this.setConstraint(widget, new Placement(connectionWidgetLayoutAlignment, n));
    }

    public void removeConstraint(Widget widget) {
        assert (widget != null);
        this.setConstraint(widget, null);
    }

    private void setConstraint(Widget widget, Placement placement) {
        Placement placement2 = placement != null ? this.placements.put(widget, placement) : this.placements.remove(widget);
        if (placement2 != null && !placement2.equals(placement)) {
            this.reverse.get(placement2).remove(widget);
        }
        if (placement != null) {
            ArrayList<Widget> arrayList = this.reverse.get(placement);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.reverse.put(placement, arrayList);
            }
            arrayList.add(widget);
        }
    }

    @Override
    public void layout(Widget widget) {
        ConnectionWidget connectionWidget = (ConnectionWidget)widget;
        connectionWidget.calculateRouting();
        List<Point> list = connectionWidget.getControlPoints();
        boolean bl = list == null || list.size() <= 0;
        double d = 0.0;
        double[] dArray = new double[bl ? 0 : list.size() - 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d += GeomUtil.distanceSq(list.get(i), list.get(i + 1));
        }
        ArrayList<Widget> arrayList = new ArrayList<Widget>(widget.getChildren());
        for (Map.Entry<Placement, ArrayList<Widget>> entry : this.reverse.entrySet()) {
            int n;
            float f;
            Placement placement = entry.getKey();
            ArrayList<Widget> arrayList2 = null;
            for (Widget widget2 : entry.getValue()) {
                if (widget2.getParentWidget() != widget || !widget2.isVisible()) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Widget>();
                }
                arrayList2.add(widget2);
            }
            if (arrayList2 == null) continue;
            Point point = bl ? new Point() : (placement.isPercentage ? ((double)(f = placement.placementInPercentage) <= 0.0 ? connectionWidget.getFirstControlPoint() : ((double)f >= 1.0 ? connectionWidget.getLastControlPoint() : this.getLinePointAtPercentage(dArray, (int)((double)f * d), list))) : ((n = placement.placementAtDistance) < 0 ? this.getLinePointAtPercentage(dArray, n + (int)d, list) : this.getLinePointAtPercentage(dArray, n, list)));
            this.layoutChildrenAt(point, placement.alignment, connectionWidget, arrayList2);
            arrayList.removeAll(arrayList2);
        }
        if (!arrayList.isEmpty()) {
            this.layoutChildrenAt(new Point(), null, connectionWidget, arrayList);
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return false;
    }

    @Override
    public void justify(Widget widget) {
    }

    private Point getLinePointAtPercentage(double[] dArray, int n, List<Point> list) {
        int n2 = dArray.length - 1;
        for (int i = 0; i < dArray.length; ++i) {
            if (!((double)n < dArray[i])) continue;
            n2 = i;
            break;
        }
        double d = n2 > 0 ? dArray[n2 - 1] : 0.0;
        double d2 = dArray[n2] - d;
        double d3 = (double)n - d;
        if (d2 == 0.0) {
            return list.get(n2);
        }
        Point point = list.get(n2);
        Point point2 = list.get(n2 + 1);
        double d4 = d3 / d2;
        return new Point((int)((double)point.x + (double)(point2.x - point.x) * d4), (int)((double)point.y + (double)(point2.y - point.y) * d4));
    }

    private void layoutChildrenAt(Point point, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, ConnectionWidget connectionWidget, ArrayList<Widget> arrayList) {
        if (connectionWidgetLayoutAlignment == null) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        }
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment2 = this.getAdjustedAlignment(connectionWidgetLayoutAlignment, connectionWidget);
        this.layoutStackedChildrenAt(point, connectionWidgetLayoutAlignment2, connectionWidget, arrayList);
    }

    private void layoutStackedChildrenAt(Point point, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, ConnectionWidget connectionWidget, ArrayList<Widget> arrayList) {
        int n = 0;
        int n2 = 0;
        if (connectionWidgetLayoutAlignment != LayoutFactory.ConnectionWidgetLayoutAlignment.NONE) {
            for (Widget widget : arrayList) {
                Rectangle rectangle = widget.getPreferredBounds();
                n = Math.max(n, rectangle.width);
                n2 += rectangle.height;
            }
        }
        Point point2 = this.getReferencePointForAdjustedAlignment(connectionWidgetLayoutAlignment, new Rectangle(n, n2));
        int n3 = point.x - point2.x;
        int n4 = point.y - point2.y;
        int n5 = 0;
        for (Widget widget : arrayList) {
            Rectangle rectangle = widget.getPreferredBounds();
            Point point3 = widget.getPreferredLocation();
            int n6 = n3 - rectangle.x;
            int n7 = n4 + n5 - rectangle.y;
            if (point3 != null) {
                n6 += point3.x;
                n7 += point3.y;
            }
            switch (connectionWidgetLayoutAlignment) {
                case CENTER_LEFT: {
                    break;
                }
                case CENTER_RIGHT: {
                    n6 += n - rectangle.width;
                    break;
                }
                case CENTER: {
                    n6 += (n - rectangle.width) / 2;
                }
            }
            n5 += rectangle.height;
            widget.resolveBounds(new Point(n6, n7), rectangle);
        }
    }

    private void layoutSingleChildAt(Point point, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, ConnectionWidget connectionWidget, Widget widget) {
        Rectangle rectangle = widget.getPreferredBounds();
        Point point2 = this.getReferencePointForAdjustedAlignment(connectionWidgetLayoutAlignment, rectangle);
        Point point3 = widget.getPreferredLocation();
        if (point3 != null) {
            point2.translate(-point3.x, -point3.y);
        }
        widget.resolveBounds(new Point(point.x - point2.x, point.y - point2.y), rectangle);
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment getAdjustedHorizontalAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment) {
        switch (connectionWidgetLayoutAlignment) {
            case CENTER_LEFT: 
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_LEFT;
            }
            case CENTER_RIGHT: 
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT;
            }
            case CENTER: 
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER;
            }
        }
        return LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
    }

    private Point getReferencePointForAdjustedAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, Rectangle rectangle) {
        switch (connectionWidgetLayoutAlignment) {
            case BOTTOM_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y - 1);
            }
            case BOTTOM_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y - 1);
            }
            case BOTTOM_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y - 1);
            }
            case CENTER: {
                return GeomUtil.center(rectangle);
            }
            case CENTER_LEFT: {
                return new Point(rectangle.x + rectangle.width, GeomUtil.centerY(rectangle));
            }
            case CENTER_RIGHT: {
                return new Point(rectangle.x - 1, GeomUtil.centerY(rectangle));
            }
            case NONE: {
                return new Point();
            }
            case TOP_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y + rectangle.height);
            }
            case TOP_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            case TOP_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y + rectangle.height);
            }
        }
        return new Point();
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment getAdjustedAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, ConnectionWidget connectionWidget) {
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment2 = connectionWidgetLayoutAlignment;
        if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_SOURCE) {
            Point point = connectionWidget.getFirstControlPoint();
            Rectangle rectangle = this.getSourceBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestCenterAlignment(point, rectangle);
        } else if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_TARGET) {
            Point point = connectionWidget.getLastControlPoint();
            Rectangle rectangle = this.getTargetBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestCenterAlignment(point, rectangle);
        } else if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_SOURCE) {
            Point point = connectionWidget.getFirstControlPoint();
            Rectangle rectangle = this.getSourceBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestBottomAlignment(point, rectangle);
        } else if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_TARGET) {
            Point point = connectionWidget.getLastControlPoint();
            Rectangle rectangle = this.getTargetBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestBottomAlignment(point, rectangle);
        } else if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_SOURCE) {
            Point point = connectionWidget.getFirstControlPoint();
            Rectangle rectangle = this.getSourceBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestTopAlignment(point, rectangle);
        } else if (connectionWidgetLayoutAlignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_TARGET) {
            Point point = connectionWidget.getLastControlPoint();
            Rectangle rectangle = this.getTargetBounds(connectionWidget);
            connectionWidgetLayoutAlignment2 = this.calculateBestTopAlignment(point, rectangle);
        }
        return connectionWidgetLayoutAlignment2;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestCenterAlignment(Point point, Rectangle rectangle) {
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (rectangle != null) {
            if (point.x <= rectangle.x) {
                connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_LEFT;
            } else if (point.x >= rectangle.x + rectangle.width) {
                connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT;
            } else if (point.y <= rectangle.y) {
                connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_CENTER;
            } else if (point.y >= rectangle.y + rectangle.height) {
                connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_CENTER;
            }
        }
        return connectionWidgetLayoutAlignment;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestBottomAlignment(Point point, Rectangle rectangle) {
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= rectangle.x) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        } else if (point.x >= rectangle.x + rectangle.width) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        } else if (point.y <= rectangle.y) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y >= rectangle.y + rectangle.height) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        }
        return connectionWidgetLayoutAlignment;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestTopAlignment(Point point, Rectangle rectangle) {
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= rectangle.x) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.x >= rectangle.x + rectangle.width) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y <= rectangle.y) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.y >= rectangle.y + rectangle.height) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        }
        return connectionWidgetLayoutAlignment;
    }

    private Rectangle getSourceBounds(ConnectionWidget connectionWidget) {
        Widget widget = connectionWidget.getSourceAnchor().getRelatedWidget();
        if (widget == null) {
            return null;
        }
        Point point = widget.getLocation();
        Rectangle rectangle = widget.getClientArea();
        return new Rectangle(point, rectangle.getSize());
    }

    private Rectangle getTargetBounds(ConnectionWidget connectionWidget) {
        Widget widget = connectionWidget.getTargetAnchor().getRelatedWidget();
        if (widget == null) {
            return null;
        }
        Point point = widget.getLocation();
        Rectangle rectangle = widget.getClientArea();
        return new Rectangle(point, rectangle.getSize());
    }

    private static class Placement {
        private final LayoutFactory.ConnectionWidgetLayoutAlignment alignment;
        private final boolean isPercentage;
        private final float placementInPercentage;
        private final int placementAtDistance;

        public Placement(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, float f) {
            this.alignment = connectionWidgetLayoutAlignment;
            this.isPercentage = true;
            this.placementInPercentage = f;
            this.placementAtDistance = 0;
        }

        public Placement(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, int n) {
            this.alignment = connectionWidgetLayoutAlignment;
            this.isPercentage = false;
            this.placementInPercentage = 0.0f;
            this.placementAtDistance = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Placement placement = (Placement)object;
            if (this.alignment != placement.alignment) {
                return false;
            }
            if (this.isPercentage != placement.isPercentage) {
                return false;
            }
            if (this.placementInPercentage != placement.placementInPercentage) {
                return false;
            }
            return this.placementAtDistance == placement.placementAtDistance;
        }

        public int hashCode() {
            int n = 3;
            n = 17 * n + (this.alignment != null ? this.alignment.hashCode() : 0);
            n = 17 * n + (this.isPercentage ? 1 : 0);
            n = 17 * n + Float.floatToIntBits(this.placementInPercentage);
            n = 17 * n + this.placementAtDistance;
            return n;
        }
    }
}

