/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodYear;
import tr.view.action.MonthsOfYearDialog;

public class PeriodYearlyPanel
extends JPanel {
    private final Dialog parent;
    private final PeriodYear periodYear;
    private JComboBox dayComboBox;
    private JLabel inLabel;
    private JButton monthsButton;
    private JComboBox nthComboBox;
    private JCheckBox onTheCheckBox;

    public PeriodYearlyPanel(Dialog parent, PeriodYear periodYear) {
        this.parent = parent;
        this.periodYear = periodYear;
        this.initView();
        this.onTheCheckBox.setSelected(periodYear.isOnTheSelected());
        this.dayComboBox.setModel(this.getDayComboModel());
        this.dayComboBox.setSelectedItem(periodYear.getOnTheDay());
        this.nthComboBox.setModel(this.getNthComboModel());
        this.nthComboBox.setSelectedItem(periodYear.getOnTheNth());
        this.setEnabled(true);
    }

    private ComboBoxModel getDayComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheDay>(PeriodMonth.OnTheDay.values());
    }

    private ComboBoxModel getNthComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheNth>(PeriodMonth.OnTheNth.values());
    }

    private String getSelectedMonthsText() {
        return this.periodYear.getSelectedMonthsText();
    }

    public void notifyStartDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        if (this.periodYear.getSelectedMonths().size() > 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.periodYear.select(Integer.valueOf(calendar.get(2)));
    }

    private void initView() {
        this.inLabel = new JLabel(this.getMsg("YearsPanel.in"));
        this.monthsButton = new JButton(this.getSelectedMonthsText());
        this.monthsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.monthsButtonAction(evt);
            }
        });
        this.onTheCheckBox = new JCheckBox(this.getMsg("months.on.the"));
        this.onTheCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.onTheCheckBoxAction(evt);
            }
        });
        this.nthComboBox = new JComboBox();
        this.nthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.NthComboAction(evt);
            }
        });
        this.dayComboBox = new JComboBox();
        this.dayComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodYearlyPanel.this.dayComboAction(evt);
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]0"));
        panel.add((Component)this.inLabel, "");
        panel.add((Component)this.monthsButton, "");
        panel.add((Component)this.onTheCheckBox, "");
        panel.add((Component)this.nthComboBox, "");
        panel.add((Component)this.dayComboBox, "wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    private void dayComboAction(ActionEvent evt) {
        this.periodYear.setOnTheDay((PeriodMonth.OnTheDay)this.dayComboBox.getSelectedItem());
    }

    private void NthComboAction(ActionEvent evt) {
        this.periodYear.setOnTheNth((PeriodMonth.OnTheNth)this.nthComboBox.getSelectedItem());
    }

    private void onTheCheckBoxAction(ActionEvent evt) {
        this.periodYear.setOnTheSelected(this.onTheCheckBox.isSelected());
        this.setEnabled(true);
    }

    private void monthsButtonAction(ActionEvent evt) {
        MonthsOfYearDialog dialog = new MonthsOfYearDialog(this.parent, this.monthsButton);
        dialog.setPeriodYear(this.periodYear);
        dialog.setVisible(true);
        if (!dialog.cancelled()) {
            this.periodYear.setSelectedMonths(dialog.getSelectedMonths());
            this.monthsButton.setText(this.periodYear.getSelectedMonthsText());
        }
    }

    public void setEnabled(boolean enabled) {
        this.nthComboBox.setEnabled(enabled && this.onTheCheckBox.isSelected());
        this.dayComboBox.setEnabled(enabled && this.onTheCheckBox.isSelected());
        this.monthsButton.setEnabled(enabled);
        this.onTheCheckBox.setEnabled(enabled);
    }

    public String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private void initComponents() {
    }
}

