/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.util.Diagnostic;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRLogger;
import com.openhtmltopdf.util.XRSimpleLogFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKXRLogger
implements XRLogger {
    private volatile boolean initPending = true;
    private volatile Map<String, Logger> loggers;
    private final boolean useParent;
    private final Level level;
    private final Handler handler;
    private final Formatter formatter;

    public JDKXRLogger() {
        this(false, Level.INFO, new ConsoleHandler(), new XRSimpleLogFormatter());
    }

    public JDKXRLogger(boolean useParent, Level level, Handler handler, Formatter formatter) {
        this.useParent = useParent;
        this.level = level;
        this.handler = handler;
        this.formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitPending() {
        if (!this.initPending) {
            return;
        }
        JDKXRLogger jDKXRLogger = this;
        synchronized (jDKXRLogger) {
            this.init(this.useParent, this.level, this.handler, this.formatter);
        }
    }

    @Override
    public boolean isLogLevelEnabled(Diagnostic diagnostic) {
        return this.getLogger(diagnostic.getLogMessageId().getWhere()).isLoggable(diagnostic.getLevel());
    }

    @Override
    public void log(String where, Level level, String msg) {
        this.getLogger(where).log(level, msg);
    }

    @Override
    public void log(String where, Level level, String msg, Throwable th) {
        this.getLogger(where).log(level, msg, th);
    }

    @Override
    public void setLevel(String logger, Level level) {
        this.getLogger(logger).setLevel(level);
    }

    private Logger getLogger(String log) {
        this.checkInitPending();
        return this.loggers.get(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean useParent, Level level, Handler handler, Formatter formatter) {
        if (!this.initPending) {
            return;
        }
        try {
            this.initializeJDKLogManager(useParent, level, handler, formatter);
        }
        finally {
            this.initPending = false;
        }
    }

    private void initializeJDKLogManager(boolean useParent, Level level, Handler handler, Formatter formatter) {
        this.loggers = this.retrieveLoggers();
        this.configureLoggerHandlerForwarding(useParent);
        this.configureLogLevels(level);
        this.configureLogHandlers(handler, formatter);
    }

    private void configureLoggerHandlerForwarding(boolean useParentHandlers) {
        this.loggers.forEach((name, logger) -> logger.setUseParentHandlers(useParentHandlers));
    }

    private Map<String, Logger> retrieveLoggers() {
        HashMap<String, Logger> loggers = new HashMap<String, Logger>();
        for (String name : XRLog.listRegisteredLoggers()) {
            loggers.put(name, Logger.getLogger(name));
        }
        return loggers;
    }

    private void configureLogHandlers(Handler handler, Formatter formatter) {
        handler.setFormatter(formatter);
        this.loggers.forEach((name, logger) -> Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler));
        this.loggers.forEach((name, logger) -> logger.addHandler(handler));
    }

    private void configureLogLevels(Level level) {
        this.loggers.forEach((name, logger) -> logger.setLevel(level));
    }
}

