/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class UpgradableRandomAccessIntContainer<T extends RandomAccessIntContainer, F extends RandomAccessIntContainer>
implements RandomAccessIntContainer {
    private T myInstanceLow;
    private F myInstanceHigh;
    private final int myThreshold;
    @NotNull
    private final InstanceUpgrader<? extends F> myFactoryHigh;

    public UpgradableRandomAccessIntContainer(int sizeThreshold, @NotNull Supplier<? extends T> factoryLow, @NotNull InstanceUpgrader<? extends F> factoryHigh) {
        if (factoryLow == null) {
            UpgradableRandomAccessIntContainer.$$$reportNull$$$0(0);
        }
        if (factoryHigh == null) {
            UpgradableRandomAccessIntContainer.$$$reportNull$$$0(1);
        }
        this.myInstanceHigh = null;
        this.myThreshold = sizeThreshold;
        this.myInstanceLow = (RandomAccessIntContainer)factoryLow.get();
        this.myFactoryHigh = factoryHigh;
    }

    public void upgrade() {
        if (this.myInstanceLow == null) {
            return;
        }
        this.myInstanceHigh = this.myFactoryHigh.createFrom((RandomAccessIntContainer)this.myInstanceLow);
        assert (this.myInstanceHigh.size() == 0 || this.myInstanceHigh.size() == this.myInstanceLow.size());
        if (this.myInstanceHigh.size() == 0 && this.myInstanceLow.size() > 0) {
            IntIdsIterator it = this.myInstanceLow.intIterator();
            while (it.hasNext()) {
                this.myInstanceHigh.add(it.next());
            }
        }
        this.myInstanceLow = null;
    }

    private void upgradeOnThreshold() {
        if (this.myInstanceLow != null && this.myInstanceLow.size() >= this.myThreshold) {
            this.upgrade();
        }
    }

    @Override
    public Object clone() {
        try {
            UpgradableRandomAccessIntContainer copy = (UpgradableRandomAccessIntContainer)super.clone();
            if (this.myInstanceHigh != null) {
                copy.myInstanceHigh = (RandomAccessIntContainer)this.myInstanceHigh.clone();
            }
            if (this.myInstanceLow != null) {
                copy.myInstanceLow = (RandomAccessIntContainer)this.myInstanceLow.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            Logger.getInstance(this.getClass().getName()).error(e);
            return null;
        }
    }

    @Override
    public boolean add(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.add(value);
        }
        boolean result = this.myInstanceLow.add(value);
        this.upgradeOnThreshold();
        return result;
    }

    @Override
    public boolean remove(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.remove(value);
        }
        return this.myInstanceLow.remove(value);
    }

    @Override
    @NotNull
    public IntIdsIterator intIterator() {
        if (this.myInstanceHigh != null) {
            IntIdsIterator intIdsIterator = this.myInstanceHigh.intIterator();
            if (intIdsIterator == null) {
                UpgradableRandomAccessIntContainer.$$$reportNull$$$0(2);
            }
            return intIdsIterator;
        }
        IntIdsIterator intIdsIterator = this.myInstanceLow.intIterator();
        if (intIdsIterator == null) {
            UpgradableRandomAccessIntContainer.$$$reportNull$$$0(3);
        }
        return intIdsIterator;
    }

    @Override
    public void compact() {
        if (this.myInstanceHigh != null) {
            this.myInstanceHigh.compact();
        } else {
            this.myInstanceLow.compact();
        }
    }

    @Override
    public int size() {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.size();
        }
        return this.myInstanceLow.size();
    }

    @Override
    public boolean contains(int value) {
        if (this.myInstanceHigh != null) {
            return this.myInstanceHigh.contains(value);
        }
        return this.myInstanceLow.contains(value);
    }

    @Override
    @NotNull
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        int expectedSize = this.size() + diff;
        if (expectedSize >= this.myThreshold) {
            this.upgrade();
        }
        if (this.myInstanceHigh != null) {
            RandomAccessIntContainer randomAccessIntContainer = this.myInstanceHigh.ensureContainerCapacity(diff);
            if (randomAccessIntContainer == null) {
                UpgradableRandomAccessIntContainer.$$$reportNull$$$0(4);
            }
            return randomAccessIntContainer;
        }
        RandomAccessIntContainer randomAccessIntContainer = this.myInstanceLow.ensureContainerCapacity(diff);
        if (randomAccessIntContainer == null) {
            UpgradableRandomAccessIntContainer.$$$reportNull$$$0(5);
        }
        return randomAccessIntContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryLow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryHigh";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/containers/UpgradableRandomAccessIntContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/containers/UpgradableRandomAccessIntContainer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "intIterator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureContainerCapacity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface InstanceUpgrader<F extends RandomAccessIntContainer> {
        public F createFrom(@NotNull RandomAccessIntContainer var1);
    }
}

