/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.llm;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesEditorUtils;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nJ\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000eJJ\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/core/impl/llm/NotebookCellLinesActionUtil;", "", "<init>", "()V", "insertMarkdownCellAbove", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "editor", "Lcom/intellij/openapi/editor/Editor;", "insertCodeCellBelow", "text", "", "insertCodeCellAbove", "insertCellBelow", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "changeCellText", "", "newText", "interval", "changeCellType", "cell", "newCellType", "insertCell", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "customHeader", "keepEmptyCell", "", "selectNewCell", "intellij.jupyter.core"})
public final class NotebookCellLinesActionUtil {
    @NotNull
    public static final NotebookCellLinesActionUtil INSTANCE = new NotebookCellLinesActionUtil();

    private NotebookCellLinesActionUtil() {
    }

    @Nullable
    public final NotebookCellLines.Interval insertMarkdownCellAbove(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return NotebookCellLinesActionUtil.insertCell$default(this, editor, "", ActionDestination.UP, NotebookCellLines.CellType.MARKDOWN, null, true, false, 64, null);
    }

    @Nullable
    public final NotebookCellLines.Interval insertCodeCellBelow(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.insertCellBelow(editor, text, NotebookCellLines.CellType.CODE);
    }

    public static /* synthetic */ NotebookCellLines.Interval insertCodeCellBelow$default(NotebookCellLinesActionUtil notebookCellLinesActionUtil, Editor editor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return notebookCellLinesActionUtil.insertCodeCellBelow(editor, string);
    }

    @Nullable
    public final NotebookCellLines.Interval insertCodeCellAbove(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NotebookCellLinesActionUtil.insertCell$default(this, editor, text, ActionDestination.UP, NotebookCellLines.CellType.CODE, null, true, false, 64, null);
    }

    public static /* synthetic */ NotebookCellLines.Interval insertCodeCellAbove$default(NotebookCellLinesActionUtil notebookCellLinesActionUtil, Editor editor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return notebookCellLinesActionUtil.insertCodeCellAbove(editor, string);
    }

    @Nullable
    public final NotebookCellLines.Interval insertCellBelow(@NotNull Editor editor, @NotNull String text, @NotNull NotebookCellLines.CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        return NotebookCellLinesActionUtil.insertCell$default(this, editor, text, ActionDestination.DOWN, cellType, null, true, false, 64, null);
    }

    public static /* synthetic */ NotebookCellLines.Interval insertCellBelow$default(NotebookCellLinesActionUtil notebookCellLinesActionUtil, Editor editor, String string, NotebookCellLines.CellType cellType, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return notebookCellLinesActionUtil.insertCellBelow(editor, string, cellType);
    }

    public final void changeCellText(@NotNull Editor editor, @NotNull String newText, @NotNull NotebookCellLines.Interval interval, @NotNull NotebookCellLines.CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper editHelper = notebookCellLinesEditHelper;
        String string = NotebookCellLinesEditHelper.makeCell$default(editHelper, newText, cellType, null, 4, null);
        if (string == null) {
            return;
        }
        String newCellText = string;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        NotebookCellLinesDocumentUtils.INSTANCE.replaceCell(document, cellLines, interval, newCellText);
    }

    public final void changeCellType(@NotNull Editor editor, @NotNull NotebookCellLines.Interval cell, @NotNull NotebookCellLines.CellType newCellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)newCellType, (String)"newCellType");
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper editHelper = notebookCellLinesEditHelper;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        CharSequence cellText = NotebookCellLinesUtilsKt.getContentText((Document)document2, (NotebookCellLines.Interval)cell);
        String newText = editHelper.makeCell(((Object)cellText).toString(), newCellType, null);
        if (newText != null) {
            editor.getCaretModel().runBatchCaretOperation(() -> NotebookCellLinesActionUtil.changeCellType$lambda$0(document2, cellLines, cell, newText));
        }
    }

    private final NotebookCellLines.Interval insertCell(Editor editor, String text, ActionDestination direction, NotebookCellLines.CellType cellType, String customHeader, boolean keepEmptyCell, boolean selectNewCell) {
        if (!(editor instanceof EditorImpl)) {
            return null;
        }
        if (!NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)editor)) {
            return null;
        }
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor);
        if (notebookCellSelectionModel == null) {
            return null;
        }
        NotebookCellSelectionModel cellSelection = notebookCellSelectionModel;
        int targetOrdinal = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> cellSelection.getPrimarySelectedCell().getOrdinal();
            case 2 -> cellSelection.getPrimarySelectedCell().getOrdinal() + 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (object == null || (object = object.makeCell(text, cellType, customHeader)) == null) {
            return null;
        }
        Object cellText = object;
        DocumentEx documentEx = ((EditorImpl)editor).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        List<NotebookCellLines.Interval> cells = NotebookCellLinesDocumentUtils.INSTANCE.insertCells((Document)documentEx, cellLines, (String)cellText, targetOrdinal, keepEmptyCell);
        NotebookCellLines.Interval cell = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(cells);
        if (cell == null) {
            return null;
        }
        if (selectNewCell) {
            cellSelection.selectSingleCell(cell);
            NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, cell.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
        }
        return cell;
    }

    static /* synthetic */ NotebookCellLines.Interval insertCell$default(NotebookCellLinesActionUtil notebookCellLinesActionUtil, Editor editor, String string, ActionDestination actionDestination, NotebookCellLines.CellType cellType, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        return notebookCellLinesActionUtil.insertCell(editor, string, actionDestination, cellType, string2, bl, bl2);
    }

    private static final void changeCellType$lambda$0(Document $document, NotebookCellLines $cellLines, NotebookCellLines.Interval $cell, String $newText) {
        NotebookCellLinesDocumentUtils.INSTANCE.replaceCell($document, $cellLines, $cell, $newText);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionDestination.values().length];
            try {
                nArray[ActionDestination.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionDestination.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

