/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.hover;

import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewEventListener;
import com.intellij.notebooks.visualization.ui.EditorComponentWrapper;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.NotebookUiUtils;
import com.intellij.notebooks.visualization.ui.providers.hover.NotebookEditorCellHoverDetector;
import com.intellij.notebooks.visualization.ui.providers.hover.NotebookEditorCellHoverDetector$1$onEditorCellViewEvents$;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\r\u0010\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector;", "Lcom/intellij/openapi/Disposable;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "mouseOverCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "scrollChange", "Ljavax/swing/event/ChangeListener;", "editorMouseListener", "com/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector$editorMouseListener$1", "Lcom/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector$editorMouseListener$1;", "editorMouseMotionEvent", "com/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector$editorMouseMotionEvent$1", "Lcom/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector$editorMouseMotionEvent$1;", "dispose", "", "updateMouseOverCell", "e", "Ljava/awt/event/MouseEvent;", "setupScrollPane", "point", "Ljava/awt/Point;", "Companion", "intellij.notebooks.visualization"})
public final class NotebookEditorCellHoverDetector
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookCellInlayManager manager;
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private EditorCell mouseOverCell;
    @NotNull
    private final ChangeListener scrollChange;
    @NotNull
    private final editorMouseListener.1 editorMouseListener;
    @NotNull
    private final editorMouseMotionEvent.1 editorMouseMotionEvent;

    public NotebookEditorCellHoverDetector(@NotNull NotebookCellInlayManager manager) {
        EditorComponentWrapper editorComponentWrapper;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.editor = this.manager.getEditor();
        this.scrollChange = arg_0 -> NotebookEditorCellHoverDetector.scrollChange$lambda$2(this, arg_0);
        this.editorMouseListener = new MouseAdapter(this){
            final /* synthetic */ NotebookEditorCellHoverDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotebookEditorCellHoverDetector.access$updateMouseOverCell(this.this$0, e);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotebookEditorCellHoverDetector.access$updateMouseOverCell(this.this$0, e);
            }
        };
        this.editorMouseMotionEvent = new MouseMotionListener(this){
            final /* synthetic */ NotebookEditorCellHoverDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotebookEditorCellHoverDetector.access$updateMouseOverCell(this.this$0, e);
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotebookEditorCellHoverDetector.access$updateMouseOverCell(this.this$0, e);
            }
        };
        if (!GraphicsEnvironment.isHeadless()) {
            this.setupScrollPane();
        }
        this.manager.addCellViewEventsListener(new EditorCellViewEventListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void onEditorCellViewEvents(List<? extends EditorCellViewEventListener.EditorCellViewEvent> events) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)events);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)1$onEditorCellViewEvents$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence;
                NotebookEditorCellHoverDetector notebookEditorCellHoverDetector = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditorCellViewEventListener.CellViewRemoved it = (EditorCellViewEventListener.CellViewRemoved)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)notebookEditorCellHoverDetector.mouseOverCell)) continue;
                    notebookEditorCellHoverDetector.mouseOverCell = null;
                }
            }
        }, this);
        EditorComponentWrapper $this$_init__u24lambda_u243 = editorComponentWrapper = EditorComponentWrapper.Companion.get((Editor)this.editor);
        boolean bl = false;
        $this$_init__u24lambda_u243.addEditorMouseEventListener(this.editorMouseListener);
        $this$_init__u24lambda_u243.addEditorMouseMotionEvent(this.editorMouseMotionEvent);
    }

    public void dispose() {
        EditorComponentWrapper editorComponentWrapper;
        EditorComponentWrapper $this$dispose_u24lambda_u244 = editorComponentWrapper = EditorComponentWrapper.Companion.get((Editor)this.editor);
        boolean bl = false;
        $this$dispose_u24lambda_u244.removeEditorMouseEventListener(this.editorMouseListener);
        $this$dispose_u24lambda_u244.removeEditorMouseMotionEvent(this.editorMouseMotionEvent);
    }

    private final void updateMouseOverCell(MouseEvent e) {
        block0: {
            Pair<Component, Point> pair = NotebookUiUtils.INSTANCE.getEditorPoint(this.editor, e);
            if (pair == null) break block0;
            Pair<Component, Point> pair2 = pair;
            boolean bl = false;
            Point point = (Point)pair2.component2();
            this.updateMouseOverCell(point);
        }
    }

    private final void setupScrollPane() {
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        this.editor.getScrollPane().getViewport().setOpaque(false);
        scrollPane.getViewport().addChangeListener(this.scrollChange);
        Disposer.register((Disposable)this, () -> NotebookEditorCellHoverDetector.setupScrollPane$lambda$6(scrollPane, this));
    }

    private final void updateMouseOverCell(Point point) {
        EditorCell prevCell = this.mouseOverCell;
        EditorCell newCell = this.manager.getCellByPoint(point);
        if (!Intrinsics.areEqual((Object)prevCell, (Object)newCell)) {
            EditorCell editorCell;
            this.mouseOverCell = newCell;
            EditorCell editorCell2 = newCell;
            if (editorCell2 != null && (editorCell2 = editorCell2.isHovered()) != null) {
                editorCell2.set(true);
            }
            if ((editorCell = prevCell) != null && (editorCell = editorCell.isHovered()) != null) {
                editorCell.set(false);
            }
            NotebookEditorKt.getNotebookEditor((Editor)this.editor).getHoveredCell().set((Object)newCell);
        }
    }

    private static final void scrollChange$lambda$2(NotebookEditorCellHoverDetector this$0, ChangeEvent it) {
        block1: {
            Point it2;
            Point point = this$0.editor.getContentComponent().getMousePosition();
            if (point != null) {
                it2 = point;
                boolean bl = false;
                this$0.updateMouseOverCell(it2);
            }
            Point point2 = this$0.editor.getGutterComponentEx().getMousePosition();
            if (point2 == null) break block1;
            it2 = point2;
            boolean bl = false;
            this$0.updateMouseOverCell(it2);
        }
    }

    private static final void setupScrollPane$lambda$6(JScrollPane $scrollPane, NotebookEditorCellHoverDetector this$0) {
        $scrollPane.getViewport().removeChangeListener(this$0.scrollChange);
    }

    public static final /* synthetic */ void access$updateMouseOverCell(NotebookEditorCellHoverDetector $this, MouseEvent e) {
        $this.updateMouseOverCell(e);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/hover/NotebookEditorCellHoverDetector$Companion;", "", "<init>", "()V", "install", "", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull NotebookCellInlayManager manager) {
            NotebookEditorCellHoverDetector notebookEditorCellHoverDetector;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            NotebookEditorCellHoverDetector it = notebookEditorCellHoverDetector = new NotebookEditorCellHoverDetector(manager);
            boolean bl = false;
            Disposer.register((Disposable)manager, (Disposable)it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

