/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.internal.commands.AbstractCommandProvider;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@NonNullByDefault
public class CommandlineRuleImporter
extends AbstractCommandProvider<Rule> {
    private final RuleRegistry ruleRegistry;

    public CommandlineRuleImporter(BundleContext context, RuleRegistry ruleRegistry) {
        super(context);
        this.ruleRegistry = ruleRegistry;
    }

    @Override
    public @Nullable Object addingService(@Nullable ServiceReference reference) {
        if (reference != null && "parser.rule".equals(reference.getProperty("parser.type"))) {
            return super.addingService(reference);
        }
        return null;
    }

    public String exportRules(String parserType, Set<Rule> set, File file) throws Exception {
        return super.exportData(parserType, set, file);
    }

    public Set<Rule> importRules(String parserType, URL url) throws IOException, ParsingException {
        Parser parser = (Parser)this.parsers.get(parserType);
        if (parser != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(url.openStream()));){
                Set<Rule> set = this.importData(url, parser, inputStreamReader);
                return set;
            }
        }
        throw new ParsingException(new ParsingNestedException(3, null, new IllegalArgumentException("Parser " + parserType + " not available")));
    }

    @Override
    protected Set<Rule> importData(URL url, Parser<Rule> parser, InputStreamReader inputStreamReader) throws ParsingException {
        Set<Rule> providedRules = parser.parse(inputStreamReader);
        if (providedRules != null && !providedRules.isEmpty()) {
            for (Rule rule : providedRules) {
                if (rule == null) continue;
                if (this.ruleRegistry.get(rule.getUID()) != null) {
                    this.ruleRegistry.update(rule);
                    continue;
                }
                this.ruleRegistry.add(rule);
            }
        }
        return providedRules;
    }
}

