/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import org.openstreetmap.josm.tools.I18n;

public class WayConnectionType {
    private final boolean invalid;
    public boolean linkPrev;
    public boolean linkNext;
    public Direction direction;
    public boolean isLoop;
    public boolean isOnewayLoopForwardPart;
    public boolean isOnewayLoopBackwardPart;
    public boolean isOnewayHead;
    public boolean isOnewayTail;

    public WayConnectionType(boolean linkPrev, boolean linkNext, Direction direction) {
        this.linkPrev = linkPrev;
        this.linkNext = linkNext;
        this.isLoop = false;
        this.direction = direction;
        this.invalid = false;
    }

    public WayConnectionType(boolean invalid) {
        this.invalid = invalid;
    }

    public WayConnectionType() {
        this.linkPrev = false;
        this.linkNext = false;
        this.isLoop = false;
        this.direction = Direction.NONE;
        this.invalid = true;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public String toString() {
        return "[P " + this.linkPrev + " ;N " + this.linkNext + " ;D " + (Object)((Object)this.direction) + " ;L " + this.isLoop + " ;FP " + this.isOnewayLoopForwardPart + ";BP " + this.isOnewayLoopBackwardPart + ";OH " + this.isOnewayHead + ";OT " + this.isOnewayTail + ']';
    }

    public String getTooltip() {
        if (!this.isValid()) {
            return "";
        }
        if (this.linkPrev && this.linkNext) {
            return I18n.tr("way is connected", new Object[0]);
        }
        if (this.linkPrev) {
            return I18n.tr("way is connected to previous relation member", new Object[0]);
        }
        if (this.linkNext) {
            return I18n.tr("way is connected to next relation member", new Object[0]);
        }
        return I18n.tr("way is not connected to previous or next relation member", new Object[0]);
    }

    public static enum Direction {
        FORWARD,
        BACKWARD,
        ROUNDABOUT_LEFT,
        ROUNDABOUT_RIGHT,
        NONE;


        public boolean isRoundabout() {
            return this == ROUNDABOUT_RIGHT || this == ROUNDABOUT_LEFT;
        }
    }
}

