/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;

public class Messages {
    private final String m_baseKey;
    private final String m_bundleString;
    private ResourceBundle m_cacheBundle;

    public Messages(String keyBase, String bundleString) {
        this.m_baseKey = keyBase + ".";
        this.m_bundleString = bundleString;
    }

    public String getText(String key) {
        try {
            return this.getResourceBundle().getString(this.m_baseKey + key);
        }
        catch (MissingResourceException e) {
            return "!" + this.m_baseKey + key + "!";
        }
    }

    public void resAction(Action action, String key) {
        String text = this.getText(key);
        StringBuffer labelBuffer = new StringBuffer(text.length());
        Integer mnemonic = null;
        int lastChar = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (lastChar == 38) {
                if (c == '&') {
                    labelBuffer.append(c);
                } else if (mnemonic == null) {
                    mnemonic = new Integer(c);
                    labelBuffer.append(c);
                }
            } else if (c != '&') {
                labelBuffer.append(c);
            }
            lastChar = c;
        }
        if (mnemonic != null) {
            action.putValue("MnemonicKey", mnemonic);
        }
        action.putValue("Name", labelBuffer.toString());
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(this.m_bundleString);
    }
}

