/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CachedResultSetMetaData
implements ResultSetMetaData,
Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(CachedResultSetMetaData.class);
    private boolean upcaseColumnNames;
    private int columnCount;
    private boolean[] autoIncrement;
    private boolean[] caseSensitive;
    private boolean[] searchable;
    private boolean[] currency;
    private int[] nullable;
    private boolean[] signed;
    private int[] columnDisplaySize;
    private String[] columnLabel;
    private String[] columnName;
    private String[] schemaName;
    private int[] precision;
    private int[] scale;
    private String[] tableName;
    private String[] catalogName;
    private int[] columnType;
    private String[] columnTypeName;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definitelyWritable;
    private String[] columnClassName;

    public CachedResultSetMetaData() {
        logger.debug((Object)"Creating new CachedResultSetMetaData");
        this.columnCount = 0;
        this.createArrays(this.columnCount);
    }

    public CachedResultSetMetaData(ResultSetMetaData source) throws SQLException {
        this(source, false);
    }

    public CachedResultSetMetaData(ResultSetMetaData source, boolean upcaseColumnNames) throws SQLException {
        logger.debug((Object)"Creating new CachedResultSetMetaData");
        this.upcaseColumnNames = upcaseColumnNames;
        this.columnCount = source.getColumnCount();
        this.createArrays(this.columnCount);
        this.populate(source);
    }

    protected void createArrays(int columnCount) {
        this.autoIncrement = new boolean[columnCount];
        this.caseSensitive = new boolean[columnCount];
        this.searchable = new boolean[columnCount];
        this.currency = new boolean[columnCount];
        this.nullable = new int[columnCount];
        this.signed = new boolean[columnCount];
        this.columnDisplaySize = new int[columnCount];
        this.columnLabel = new String[columnCount];
        this.columnName = new String[columnCount];
        this.schemaName = new String[columnCount];
        this.precision = new int[columnCount];
        this.scale = new int[columnCount];
        this.tableName = new String[columnCount];
        this.catalogName = new String[columnCount];
        this.columnType = new int[columnCount];
        this.columnTypeName = new String[columnCount];
        this.readOnly = new boolean[columnCount];
        this.writable = new boolean[columnCount];
        this.definitelyWritable = new boolean[columnCount];
        this.columnClassName = new String[columnCount];
    }

    protected void populate(ResultSetMetaData source) throws SQLException {
        for (int i = 0; i < source.getColumnCount(); ++i) {
            this.autoIncrement[i] = source.isAutoIncrement(i + 1);
            this.caseSensitive[i] = source.isCaseSensitive(i + 1);
            this.searchable[i] = source.isSearchable(i + 1);
            this.currency[i] = source.isCurrency(i + 1);
            this.nullable[i] = source.isNullable(i + 1);
            this.signed[i] = source.isSigned(i + 1);
            this.columnDisplaySize[i] = source.getColumnDisplaySize(i + 1);
            this.columnLabel[i] = source.getColumnLabel(i + 1);
            this.columnName[i] = this.upcaseColumnNames && source.getColumnName(i + 1) != null ? source.getColumnName(i + 1).toUpperCase() : source.getColumnName(i + 1);
            this.schemaName[i] = source.getSchemaName(i + 1);
            this.precision[i] = source.getPrecision(i + 1);
            this.scale[i] = source.getScale(i + 1);
            this.tableName[i] = source.getTableName(i + 1);
            this.catalogName[i] = source.getCatalogName(i + 1);
            this.columnType[i] = source.getColumnType(i + 1);
            this.columnTypeName[i] = source.getColumnTypeName(i + 1);
            this.readOnly[i] = source.isReadOnly(i + 1);
            this.writable[i] = source.isWritable(i + 1);
            this.definitelyWritable[i] = source.isDefinitelyWritable(i + 1);
            this.columnClassName[i] = source.getColumnClassName(i + 1);
        }
    }

    public int addColumn(boolean autoIncrementArg, boolean caseSensitiveArg, boolean searchableArg, boolean currencyArg, int nullableArg, boolean signedArg, int columnDisplaySizeArg, String columnLabelArg, String columnNameArg, String schemaNameArg, int precisionArg, int scaleArg, String tableNameArg, String catalogNameArg, int columnTypeArg, String columnTypeNameArg, boolean readOnlyArg, boolean writableArg, boolean definitelyWritableArg, String columnClassNameArg) throws SQLException {
        ResultSetMetaData copy = null;
        try {
            copy = (ResultSetMetaData)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Couldn't clone this instance");
        }
        this.createArrays(this.columnCount + 1);
        this.populate(copy);
        this.autoIncrement[this.columnCount] = autoIncrementArg;
        this.caseSensitive[this.columnCount] = caseSensitiveArg;
        this.searchable[this.columnCount] = searchableArg;
        this.currency[this.columnCount] = currencyArg;
        this.nullable[this.columnCount] = nullableArg;
        this.signed[this.columnCount] = signedArg;
        this.columnDisplaySize[this.columnCount] = columnDisplaySizeArg;
        this.columnLabel[this.columnCount] = columnLabelArg;
        this.columnName[this.columnCount] = this.upcaseColumnNames && columnNameArg != null ? columnNameArg.toUpperCase() : columnNameArg;
        this.schemaName[this.columnCount] = schemaNameArg;
        this.precision[this.columnCount] = precisionArg;
        this.scale[this.columnCount] = scaleArg;
        this.tableName[this.columnCount] = tableNameArg;
        this.catalogName[this.columnCount] = catalogNameArg;
        this.columnType[this.columnCount] = columnTypeArg;
        this.columnTypeName[this.columnCount] = columnTypeNameArg;
        this.readOnly[this.columnCount] = readOnlyArg;
        this.writable[this.columnCount] = writableArg;
        this.definitelyWritable[this.columnCount] = definitelyWritableArg;
        this.columnClassName[this.columnCount] = columnClassNameArg;
        ++this.columnCount;
        return this.columnCount;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.autoIncrement[column - 1];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.caseSensitive[column - 1];
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.searchable[column - 1];
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.currency[column - 1];
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.nullable[column - 1];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.signed[column - 1];
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnDisplaySize[column - 1];
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnLabel[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnName[column - 1];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.schemaName[column - 1];
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.precision[column - 1];
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.scale[column - 1];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName[column - 1];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.catalogName[column - 1];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnType[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnTypeName[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.readOnly[column - 1];
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.writable[column - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.definitelyWritable[column - 1];
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnClassName[column - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }
}

