/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.parser.AbstractRecordParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlobRecordParser
extends AbstractRecordParser<BlobRecord> {
    private static final Logger LOGGER = LogManager.getLogger();

    public BlobRecordParser(int startposition, byte[] array, ProtocolVersion version) {
        super(startposition, array, version);
    }

    @Override
    public BlobRecord parse() {
        LOGGER.debug("Parsing BlobRecord");
        BlobRecord record = new BlobRecord();
        record.setContentMessageType(ProtocolMessageType.UNKNOWN);
        this.parseProtocolMessageBytes(record);
        record.setCompleteRecordBytes(this.getAlreadyParsed());
        return record;
    }

    private void parseProtocolMessageBytes(BlobRecord record) {
        record.setProtocolMessageBytes(this.parseByteArrayField(this.getBytesLeft()));
        LOGGER.debug("ProtocolMessageBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolMessageBytes().getValue())));
    }
}

