/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new SimpleScriptContext();

    public AbstractScriptEngine() {
    }

    public AbstractScriptEngine(Bindings n) {
        this();
        if (n == null) {
            throw new NullPointerException("n is null");
        }
        this.context.setBindings(n, 100);
    }

    public void setContext(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("null context");
        }
        this.context = ctxt;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public Bindings getBindings(int scope) {
        if (scope == 200) {
            return this.context.getBindings(200);
        }
        if (scope == 100) {
            return this.context.getBindings(100);
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    public void setBindings(Bindings bindings, int scope) {
        if (scope == 200) {
            this.context.setBindings(bindings, 200);
        } else if (scope == 100) {
            this.context.setBindings(bindings, 100);
        } else {
            throw new IllegalArgumentException("Invalid scope value.");
        }
    }

    public void put(String key, Object value) {
        Bindings nn = this.getBindings(100);
        if (nn != null) {
            nn.put(key, value);
        }
    }

    public Object get(String key) {
        Bindings nn = this.getBindings(100);
        if (nn != null) {
            return nn.get(key);
        }
        return null;
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext ctxt = this.getScriptContext(bindings);
        return this.eval(reader, ctxt);
    }

    public Object eval(String script, Bindings bindings) throws ScriptException {
        ScriptContext ctxt = this.getScriptContext(bindings);
        return this.eval(script, ctxt);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    protected ScriptContext getScriptContext(Bindings nn) {
        SimpleScriptContext ctxt = new SimpleScriptContext();
        Bindings gs = this.getBindings(200);
        if (gs != null) {
            ctxt.setBindings(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        ctxt.setBindings(nn, 100);
        ctxt.setReader(this.context.getReader());
        ctxt.setWriter(this.context.getWriter());
        ctxt.setErrorWriter(this.context.getErrorWriter());
        return ctxt;
    }
}

