/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.AnnotatedActions;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.internal.module.handler.AnnotationActionHandler;
import org.openhab.core.automation.module.provider.AnnotationActionModuleTypeHelper;
import org.openhab.core.automation.module.provider.ModuleInformation;
import org.openhab.core.automation.module.provider.i18n.ModuleTypeI18nService;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(service={ModuleTypeProvider.class, ModuleHandlerFactory.class})
public class AnnotatedActionModuleTypeProvider
extends BaseModuleHandlerFactory
implements ModuleTypeProvider {
    private final Collection<ProviderChangeListener<ModuleType>> changeListeners = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<ModuleInformation>> moduleInformation = new ConcurrentHashMap<String, Set<ModuleInformation>>();
    private final AnnotationActionModuleTypeHelper helper;
    private final ModuleTypeI18nService moduleTypeI18nService;
    private final ActionInputsHelper actionInputsHelper;

    @Activate
    public AnnotatedActionModuleTypeProvider(@Reference ModuleTypeI18nService moduleTypeI18nService, @Reference AnnotationActionModuleTypeHelper helper, @Reference ActionInputsHelper actionInputsHelper) {
        this.moduleTypeI18nService = moduleTypeI18nService;
        this.helper = helper;
        this.actionInputsHelper = actionInputsHelper;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this.moduleInformation.clear();
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        this.changeListeners.remove(listener);
    }

    public Collection<ModuleType> getAll() {
        ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
        for (String moduleUID : this.moduleInformation.keySet()) {
            ActionType mt = this.helper.buildModuleType(moduleUID, this.moduleInformation);
            if (mt == null) continue;
            moduleTypes.add(mt);
        }
        return moduleTypes;
    }

    @Override
    public <T extends ModuleType> T getModuleType(String uid, @Nullable Locale locale) {
        return (T)this.localizeModuleType(uid, locale);
    }

    @Override
    public <T extends ModuleType> Collection<T> getModuleTypes(@Nullable Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>();
        for (Map.Entry<String, Set<ModuleInformation>> entry : this.moduleInformation.entrySet()) {
            ModuleType localizedModuleType = this.localizeModuleType(entry.getKey(), locale);
            if (localizedModuleType == null) continue;
            result.add(localizedModuleType);
        }
        return result;
    }

    private @Nullable ModuleType localizeModuleType(String uid, @Nullable Locale locale) {
        Set<ModuleInformation> mis = this.moduleInformation.get(uid);
        if (mis != null && !mis.isEmpty()) {
            ModuleInformation mi = mis.iterator().next();
            Bundle bundle = FrameworkUtil.getBundle(mi.getActionProvider().getClass());
            ActionType mt = this.helper.buildModuleType(uid, this.moduleInformation);
            return this.moduleTypeI18nService.getModuleTypePerLocale(mt, locale, bundle);
        }
        return null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addActionProvider(AnnotatedActions actionProvider, Map<String, Object> properties) {
        Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(actionProvider);
        String configName = this.getConfigNameFromService(properties);
        for (ModuleInformation mi : moduleInformations) {
            mi.setConfigName(configName);
            ActionType oldType = null;
            if (this.moduleInformation.containsKey(mi.getUID())) {
                oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
                availableModuleConfigs.add(mi);
            } else {
                ConcurrentHashMap.KeySetView configs = ConcurrentHashMap.newKeySet();
                configs.add(mi);
                this.moduleInformation.put(mi.getUID(), configs);
            }
            ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
            if (mt == null) continue;
            for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                if (oldType != null) {
                    l.updated((Provider)this, (Object)oldType, (Object)mt);
                    continue;
                }
                l.added((Provider)this, (Object)mt);
            }
        }
    }

    public void removeActionProvider(AnnotatedActions actionProvider, Map<String, Object> properties) {
        Collection<ModuleInformation> moduleInformations = this.helper.parseAnnotations(actionProvider);
        String configName = this.getConfigNameFromService(properties);
        for (ModuleInformation mi : moduleInformations) {
            mi.setConfigName(configName);
            ActionType oldType = null;
            Set<ModuleInformation> availableModuleConfigs = this.moduleInformation.get(mi.getUID());
            if (availableModuleConfigs == null) continue;
            if (availableModuleConfigs.size() > 1) {
                oldType = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
                availableModuleConfigs.remove(mi);
            } else {
                this.moduleInformation.remove(mi.getUID());
            }
            ActionType mt = this.helper.buildModuleType(mi.getUID(), this.moduleInformation);
            if (mt == null) continue;
            for (ProviderChangeListener<ModuleType> l : this.changeListeners) {
                if (oldType != null) {
                    l.updated((Provider)this, (Object)oldType, (Object)mt);
                    continue;
                }
                l.removed((Provider)this, (Object)mt);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable String getConfigNameFromService(Map<String, Object> properties) {
        Object o = properties.get("openhab.servicecontext");
        String configName = null;
        Object object = o;
        if (object instanceof String) {
            void string;
            String string2 = (String)object;
            String cfr_ignored_0 = (String)object;
            configName = string;
        }
        return configName;
    }

    @Override
    public Collection<String> getTypes() {
        return this.moduleInformation.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        Module module2 = module;
        if (module2 instanceof Action) {
            ModuleInformation finalMI;
            void actionModule;
            Action action = (Action)module2;
            Action cfr_ignored_0 = (Action)module2;
            if (this.moduleInformation.containsKey(actionModule.getTypeUID()) && (finalMI = this.helper.getModuleInformationForIdentifier((Action)actionModule, this.moduleInformation, false)) != null) {
                ActionType moduleType = this.helper.buildModuleType(module.getTypeUID(), this.moduleInformation);
                if (moduleType == null) {
                    return null;
                }
                return new AnnotationActionHandler((Action)actionModule, moduleType, finalMI.getMethod(), finalMI.getActionProvider(), this.actionInputsHelper);
            }
        }
        return null;
    }
}

