/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp;

import com.igormaznitsa.jbbp.JBBPExternalValueProvider;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.exceptions.JBBPEvalException;
import com.igormaznitsa.jbbp.exceptions.JBBPTooManyFieldsFoundException;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.model.finder.JBBPFieldFinder;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JBBPNamedNumericFieldMap
implements JBBPFieldFinder {
    private final Map<JBBPNamedFieldInfo, JBBPNumericField> fieldMap = new LinkedHashMap<JBBPNamedFieldInfo, JBBPNumericField>();
    private final JBBPExternalValueProvider externalValueProvider;

    public JBBPNamedNumericFieldMap() {
        this(null);
    }

    public JBBPNamedNumericFieldMap(JBBPExternalValueProvider externalValueProvider) {
        this.externalValueProvider = externalValueProvider;
    }

    public JBBPExternalValueProvider getExternalValueProvider() {
        return this.externalValueProvider;
    }

    public JBBPNumericField get(JBBPNamedFieldInfo namedField) {
        return this.fieldMap.get(namedField);
    }

    public void putField(JBBPNumericField field) {
        JBBPUtils.assertNotNull(field, "Field must not be null");
        JBBPNamedFieldInfo fieldName = field.getNameInfo();
        JBBPUtils.assertNotNull(fieldName, "Field name info must not be null");
        this.fieldMap.put(fieldName, field);
    }

    public JBBPNumericField remove(JBBPNamedFieldInfo nameInfo) {
        JBBPUtils.assertNotNull(nameInfo, "Name info must not be null");
        return this.fieldMap.remove(nameInfo);
    }

    public JBBPNumericField findForFieldOffset(int offset) {
        JBBPNumericField result = null;
        for (Map.Entry<JBBPNamedFieldInfo, JBBPNumericField> f : this.fieldMap.entrySet()) {
            if (f.getKey().getFieldOffsetInCompiledBlock() != offset) continue;
            result = f.getValue();
            break;
        }
        return result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFirstFieldForType(Class<T> fieldType) {
        JBBPUtils.assertNotNull(fieldType, "Type must not be null");
        JBBPAbstractField result = null;
        for (JBBPNumericField f : this.fieldMap.values()) {
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findLastFieldForType(Class<T> fieldType) {
        JBBPUtils.assertNotNull(fieldType, "Type must not be null");
        JBBPAbstractField result = null;
        for (JBBPNumericField f : this.fieldMap.values()) {
            if (fieldType != f.getClass()) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForType(Class<T> fieldType) {
        JBBPUtils.assertNotNull(fieldType, "Type must not be null");
        int count = 0;
        JBBPAbstractField result = null;
        for (JBBPNumericField f : this.fieldMap.values()) {
            if (fieldType != f.getClass()) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            ++count;
        }
        if (count > 1) {
            throw new JBBPTooManyFieldsFoundException(count, "Too many fields detected", null, fieldType);
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForNameAndType(String fieldName, Class<T> fieldType) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        JBBPUtils.assertNotNull(fieldType, "Field type must not be null");
        JBBPAbstractField result = null;
        for (Map.Entry<JBBPNamedFieldInfo, JBBPNumericField> f : this.fieldMap.entrySet()) {
            if (!normalizedName.equals(f.getKey().getFieldName()) || !fieldType.isAssignableFrom(f.getValue().getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f.getValue());
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForPathAndType(String fieldPath, Class<T> fieldType) {
        String normalizedPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        JBBPUtils.assertNotNull(fieldType, "Field type must not be null");
        JBBPAbstractField result = null;
        for (Map.Entry<JBBPNamedFieldInfo, JBBPNumericField> f : this.fieldMap.entrySet()) {
            if (!normalizedPath.equals(f.getKey().getFieldPath()) || !fieldType.isAssignableFrom(f.getValue().getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f.getValue());
            break;
        }
        return (T)result;
    }

    @Override
    public JBBPAbstractField findFieldForName(String fieldName) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        JBBPAbstractField result = null;
        for (Map.Entry<JBBPNamedFieldInfo, JBBPNumericField> f : this.fieldMap.entrySet()) {
            if (!normalizedName.equals(f.getKey().getFieldName())) continue;
            result = (JBBPAbstractField)((Object)f.getValue());
            break;
        }
        return result;
    }

    @Override
    public JBBPAbstractField findFieldForPath(String fieldPath) {
        String normalizedPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        JBBPAbstractField result = null;
        for (Map.Entry<JBBPNamedFieldInfo, JBBPNumericField> f : this.fieldMap.entrySet()) {
            if (!normalizedPath.equals(f.getKey().getFieldPath())) continue;
            result = (JBBPAbstractField)((Object)f.getValue());
            break;
        }
        return result;
    }

    @Override
    public boolean nameExists(String fieldName) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        boolean result = false;
        for (JBBPNamedFieldInfo f : this.fieldMap.keySet()) {
            if (!normalizedName.equals(f.getFieldName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean pathExists(String fieldPath) {
        String normalizedPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        boolean result = false;
        for (JBBPNamedFieldInfo f : this.fieldMap.keySet()) {
            if (!normalizedPath.equals(f.getFieldPath())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void clear() {
        this.fieldMap.clear();
    }

    public boolean isEmpty() {
        return this.fieldMap.isEmpty();
    }

    public int size() {
        return this.fieldMap.size();
    }

    public int getExternalFieldValue(String externalFieldName, JBBPCompiledBlock compiledBlock, JBBPIntegerValueEvaluator evaluator) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(externalFieldName);
        if (this.externalValueProvider == null) {
            throw new JBBPEvalException("Request for '" + externalFieldName + "' but there is not any value provider", evaluator);
        }
        return this.externalValueProvider.provideArraySize(normalizedName, this, compiledBlock);
    }
}

