/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress.swing;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ProgressMonitorExecutor
extends ThreadPoolExecutor {
    public ProgressMonitorExecutor(String nameFormat, int threadPriority) {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Utils.newThreadFactory(nameFormat, threadPriority));
    }

    @Override
    public void execute(Runnable command) {
        if (PleaseWaitProgressMonitor.currentProgressMonitor != null) {
            PleaseWaitProgressMonitor.currentProgressMonitor.showForegroundDialog();
        }
        super.execute(command);
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (CancellationException cancellationException) {
                t = cancellationException;
            }
            catch (ExecutionException executionException) {
                Logging.trace(executionException);
                t = executionException.getCause();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            Logging.error("Thread {0} raised {1}", Thread.currentThread().getName(), t);
        }
    }
}

