/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public final class Utility {
    public static final Border BEVEL_BORDER = BorderFactory.createBevelBorder(1);
    public static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    public static final Border PROGRESS_BORDER = BorderFactory.createLineBorder(new Color(122, 109, 82));
    private static Border COLOR_CELL_BORDER = null;
    private static Border DIALOG_BORDER = null;
    private static Border SIMPLE_LINE_BORDER = null;
    private static Border TOPCELLBORDER = null;
    private static Border CELLBORDER = null;
    private static Border LEFTCELLBORDER = null;
    private static Border TOPLEFTCELLBORDER = null;
    private static final int DEFAULT_TEXT_COLUMNS = 20;
    public static final Insets EMPTY_MARGIN = new Insets(0, 0, 0, 0);
    private static StyleContext STYLE_CONTEXT = null;
    public static String FONTSPEC_TITLE = "header-plain-max";
    public static String FONTSPEC_SUBTITLE = "header-plain-large";

    public static void initStyleContext(Font font) {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        STYLE_CONTEXT = new StyleContext();
        Style regular = STYLE_CONTEXT.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(regular, font.getFamily());
        StyleConstants.setFontSize(regular, font.getSize());
        Style buttonStyle = STYLE_CONTEXT.addStyle("button", regular);
        StyleConstants.setForeground(buttonStyle, Utility.getLinkColor());
        Style right = STYLE_CONTEXT.addStyle("right", regular);
        StyleConstants.setAlignment(right, 2);
    }

    public static Color getBorderColor() {
        return ImageLibrary.getColor("color.border.LookAndFeel", Color.BLACK);
    }

    public static Color getLinkColor() {
        return ImageLibrary.getColor("color.link.LookAndFeel", Color.BLUE);
    }

    public static Color getWarningColor() {
        return ImageLibrary.getColor("color.warning.LookAndFeel", Color.RED);
    }

    public static synchronized Border getColorCellBorder() {
        if (COLOR_CELL_BORDER == null) {
            ImageIcon icon = new ImageIcon(ImageLibrary.getColorCellRendererBackground());
            COLOR_CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 10, 5, 10, icon), BorderFactory.createLineBorder(Utility.getBorderColor()));
        }
        return COLOR_CELL_BORDER;
    }

    public static synchronized Border getDialogBorder() {
        if (DIALOG_BORDER == null) {
            DIALOG_BORDER = BorderFactory.createCompoundBorder(Utility.getTrivialLineBorder(), Utility.blankBorder(10, 20, 10, 20));
        }
        return DIALOG_BORDER;
    }

    public static synchronized Border getProductionBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Utility.getBorderColor()), Utility.blankBorder(2, 2, 2, 2));
    }

    public static synchronized Border getSimpleLineBorder() {
        if (SIMPLE_LINE_BORDER == null) {
            SIMPLE_LINE_BORDER = BorderFactory.createCompoundBorder(Utility.getTrivialLineBorder(), Utility.blankBorder(5, 5, 5, 5));
        }
        return SIMPLE_LINE_BORDER;
    }

    public static synchronized Border getTrivialLineBorder() {
        return BorderFactory.createLineBorder(Utility.getBorderColor());
    }

    public static synchronized Border getTopCellBorder() {
        if (TOPCELLBORDER == null) {
            TOPCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Utility.getBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return TOPCELLBORDER;
    }

    public static synchronized Border getCellBorder() {
        if (CELLBORDER == null) {
            CELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Utility.getBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return CELLBORDER;
    }

    public static synchronized Border getLeftCellBorder() {
        if (LEFTCELLBORDER == null) {
            LEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Utility.getBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return LEFTCELLBORDER;
    }

    public static synchronized Border getTopLeftCellBorder() {
        if (TOPLEFTCELLBORDER == null) {
            TOPLEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Utility.getBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return TOPLEFTCELLBORDER;
    }

    public static JButton getLinkButton(String text, Icon icon, String action) {
        FreeColButton button = new FreeColButton(text, icon).withButtonStyle(FreeColButton.ButtonStyle.TRANSPARENT);
        button.setMargin(EMPTY_MARGIN);
        button.setOpaque(false);
        button.setForeground(Utility.getLinkColor());
        button.setAlignmentY(0.8f);
        button.setBorder(Utility.blankBorder(0, 0, 0, 0));
        button.setActionCommand(action);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    public static JButton getMessageButton(String key, String val, Player player, FreeColGameObject source) {
        FreeColGameObject link = null;
        if ("%colony%".equals(key) || key.endsWith("Colony%") || "%settlement%".equals(key)) {
            Settlement settlement = player.getGame().getSettlementByName(val);
            link = settlement == null ? null : (player.owns(settlement) ? settlement : settlement.getTile());
        } else if ("%europe%".equals(key) || "%market%".equals(key)) {
            link = player.getEurope();
        } else if ("%location%".equals(key) || "%repairLocation%".equals(key)) {
            if (source instanceof Location) {
                link = source.getLinkTarget(player);
            }
        } else if ("%unit%".equals(key)) {
            if (source instanceof Unit && player.owns((Unit)source)) {
                link = source.getLinkTarget(player);
            }
        } else if ("%enemyUnit%".equals(key) && source instanceof Unit && !player.owns((Unit)source)) {
            link = source.getLinkTarget(player);
        }
        return link == null ? null : Utility.getLinkButton(val, null, link.getId());
    }

    private static JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        return textArea;
    }

    public static JTextArea getDefaultTextArea(String text) {
        return Utility.getDefaultTextArea(text, 20);
    }

    public static JTextArea getDefaultTextArea(String text, int columns) {
        JTextArea textArea = Utility.createTextArea(text);
        textArea.setColumns(columns);
        textArea.setSize(textArea.getPreferredSize());
        return textArea;
    }

    public static JTextArea getDefaultTextArea(String text, Dimension size) {
        JTextArea textArea = Utility.createTextArea(text);
        textArea.setPreferredSize(size);
        return textArea;
    }

    public static JTextPane getDefaultTextPane() {
        DefaultStyledDocument document = new DefaultStyledDocument(STYLE_CONTEXT);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setLogicalStyle(STYLE_CONTEXT.getStyle("regular"));
        return textPane;
    }

    public static JTextPane getDefaultTextPane(String text) {
        JTextPane textPane = Utility.getDefaultTextPane();
        textPane.setText(text);
        return textPane;
    }

    public static Border blankBorder(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(top, left, bottom, right);
    }

    public static void padBorder(JComponent component, int top, int left, int bottom, int right) {
        component.setBorder(BorderFactory.createCompoundBorder(Utility.blankBorder(top, left, bottom, right), component.getBorder()));
    }

    public static JComboBox<InetAddress> createServerInetAddressBox() {
        List<InetAddress> serverAddresses = Utility.getPossibleServerAddresses();
        JComboBox<InetAddress> serverAddressBox = new JComboBox<InetAddress>(serverAddresses.toArray(new InetAddress[0]));
        serverAddressBox.setRenderer(new FreeColComboBoxRenderer());
        return serverAddressBox;
    }

    private static List<InetAddress> getPossibleServerAddresses() {
        List<InetAddress> serverAddresses;
        try {
            serverAddresses = NetworkInterface.networkInterfaces().flatMap(NetworkInterface::inetAddresses).filter(ia -> ia instanceof Inet4Address).collect(Collectors.toList());
        }
        catch (SocketException e) {
            serverAddresses = List.of(Inet4Address.getLoopbackAddress());
        }
        return serverAddresses;
    }

    public static void localizeBorder(JComponent component, StringTemplate template) {
        TitledBorder tb = (TitledBorder)component.getBorder();
        tb.setTitle(Messages.message(template));
    }

    public static TitledBorder localizedBorder(Named named) {
        return Utility.localizedBorder(named.getNameKey());
    }

    public static TitledBorder localizedBorder(Named named, Color color) {
        return Utility.localizedBorder(named.getNameKey(), color);
    }

    public static TitledBorder localizedBorder(String key) {
        return BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message(key));
    }

    public static TitledBorder localizedBorder(String key, Color color) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color, 1), Messages.message(key));
    }

    public static FreeColButton localizedButton(String key) {
        return new FreeColButton(Messages.message(key));
    }

    public static JButton localizedButton(StringTemplate template) {
        return new JButton(Messages.message(template));
    }

    public static JCheckBoxMenuItem localizedCheckBoxMenuItem(String key, boolean value) {
        return new JCheckBoxMenuItem(Messages.message(key), value);
    }

    public static JLabel localizedHeader(String key, String fontSpec) {
        JLabel header = Utility.localizedHeaderLabel(key, 0, fontSpec);
        header.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        return header;
    }

    public static JLabel localizedHeaderLabel(String key, int alignment, String fontSpec) {
        String text = Messages.message(key);
        JLabel header = new JLabel(text, alignment);
        header.setFont(FontLibrary.getScaledFont(fontSpec, text));
        header.setOpaque(false);
        return header;
    }

    public static JLabel localizedHeaderLabel(StringTemplate template, int alignment, String fontSpec) {
        String text = Messages.message(template);
        JLabel header = new JLabel(text, alignment);
        header.setFont(FontLibrary.getScaledFont(fontSpec, text));
        header.setOpaque(false);
        return header;
    }

    public static JLabel localizedHeaderLabel(Named named, String fontSpec) {
        return Utility.localizedHeaderLabel(named.getNameKey(), 10, fontSpec);
    }

    public static JLabel localizedLabel(FreeColSpecObjectType fcgot) {
        return Utility.localizedLabel(fcgot.getNameKey());
    }

    public static JLabel localizedLabel(String key) {
        return Utility.localizedLabel(StringTemplate.key(key));
    }

    public static JLabel localizedLabel(StringTemplate template) {
        JLabel label = new JLabel(Messages.message(template));
        label.setOpaque(false);
        return label;
    }

    public static JLabel localizedLabel(StringTemplate template, Icon icon, int alignment) {
        JLabel label = new JLabel(Messages.message(template), icon, alignment);
        label.setOpaque(false);
        return label;
    }

    public static JMenu localizedMenu(String key) {
        return new JMenu(Messages.message(key));
    }

    public static JMenu localizedMenu(StringTemplate template) {
        return new JMenu(Messages.message(template));
    }

    public static JMenuItem localizedMenuItem(String key) {
        return Utility.localizedMenuItem(key, null);
    }

    public static JMenuItem localizedMenuItem(String key, Icon icon) {
        return new JMenuItem(Messages.message(key), icon);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template) {
        return Utility.localizedMenuItem(template, null);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template, Icon icon) {
        return new JMenuItem(Messages.message(template), icon);
    }

    public static JRadioButtonMenuItem localizedRadioButtonMenuItem(StringTemplate template, boolean value) {
        return new JRadioButtonMenuItem(Messages.message(template), value);
    }

    public static JTextArea localizedTextArea(String key) {
        return Utility.localizedTextArea(StringTemplate.key(key));
    }

    public static JTextArea localizedTextArea(String key, int columns) {
        return Utility.localizedTextArea(StringTemplate.key(key), columns);
    }

    public static JTextArea localizedTextArea(StringTemplate template) {
        return Utility.localizedTextArea(template, 20);
    }

    public static JTextArea localizedTextArea(StringTemplate template, int columns) {
        return Utility.getDefaultTextArea(Messages.message(template), columns);
    }

    public static JPanel localizedTextPanel(StringTemplate template, ImageIcon icon) {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel(icon));
        panel.add(Utility.localizedTextArea(template));
        panel.setBorder(Utility.getDialogBorder());
        return panel;
    }

    public static void localizeToolTip(JComponent comp, String key) {
        comp.setToolTipText(Messages.message(key));
    }

    public static void localizeToolTip(JComponent comp, StringTemplate template) {
        comp.setToolTipText(Messages.message(template));
    }
}

