/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.idpf.epubcheck.util.css.CssInputStream;

public class CssSource {
    private final String systemID;
    private final CssInputStream stream;

    public CssSource(String systemID, InputStream input) throws IOException {
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
        this.stream = Preconditions.checkNotNull((Object)input) instanceof CssInputStream ? (CssInputStream)input : new CssInputStream(input);
    }

    public CssSource(String systemID, CharSequence input) throws IOException {
        this.systemID = (String)Preconditions.checkNotNull((Object)systemID);
        this.stream = new CssInputStream(new ByteArrayInputStream(input.toString().getBytes()));
    }

    public String getSystemID() {
        return this.systemID;
    }

    public CssInputStream getInputStream() {
        return this.stream;
    }

    public Reader newReader() {
        String enc = "utf-8";
        if (this.stream.bom.isPresent()) {
            enc = (String)this.stream.bom.get();
        } else if (this.stream.charset.isPresent()) {
            enc = (String)this.stream.charset.get();
        }
        try {
            return new BufferedReader(new InputStreamReader((InputStream)this.stream, enc));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedReader(new InputStreamReader(this.stream));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.systemID).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssSource) {
            CssSource cs = (CssSource)obj;
            return cs.systemID.equals(this.systemID);
        }
        return false;
    }
}

