/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.test;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.test.EchoImpl;

public class ServiceEndpoints {
    private ServiceEndpoints() {
    }

    public static Service getEchoService() {
        Class echoClass = EchoImpl.class;
        Method echoMethod = null;
        try {
            echoMethod = echoClass.getMethod("echo", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new XFireRuntimeException("Could not find echo method on Echo class", e);
        }
        ServiceInfo serviceInfo = new ServiceInfo(new QName("http://test.xfire.codehaus.org", "EchoPortType"), echoClass);
        OperationInfo operation = serviceInfo.addOperation("echo", echoMethod);
        MessageInfo inputMessage = operation.createMessage(new QName("echoRequest"));
        operation.setInputMessage(inputMessage);
        MessageInfo outputMessage = operation.createMessage(new QName("echoResponse"));
        operation.setOutputMessage(outputMessage);
        inputMessage.addMessagePart(new QName("echoRequestin0"), String.class);
        outputMessage.addMessagePart(new QName("echoResponseout"), String.class);
        Service service = new Service(serviceInfo);
        service.setName(new QName("http://test.xfire.codehaus.org", "Echo"));
        return service;
    }

    public static Service getEchoFaultService() {
        Service endpoint = ServiceEndpoints.getEchoService();
        OperationInfo operation = endpoint.getServiceInfo().getOperation("echo");
        FaultInfo fault = operation.addFault("echoFault");
        fault.addMessagePart(new QName("echoFault0"), String.class);
        return endpoint;
    }
}

