/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.future.Future;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.filters.FilterComboAbstract;
import tr.view.filters.MultiChoiceDialog;
import tr.view.filters.TopicAll;
import tr.view.filters.TopicMultiple;
import tr.view.filters.TopicMultipleEdit;
import tr.view.future.filters.MatcherEditorBase;

public class MatcherEditorTopic
extends MatcherEditorBase
implements PropertyChangeListener {
    private final TopicsComboBoxModel comboModel = new TopicsComboBoxModel();
    private final TopicsComboBox comboBox = new TopicsComboBox(this.comboModel);

    public MatcherEditorTopic() {
        this.comboBox.addValueChangeListener(this);
    }

    public Component getComponent() {
        return this.comboBox;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Topic topic = (Topic)this.comboBox.getSelectedItem();
        if (topic == null) {
            this.fireMatchAll();
        } else if (topic instanceof TopicAll) {
            this.fireMatchAll();
        } else if (topic instanceof TopicMultiple) {
            TopicMultiple multiple = (TopicMultiple)topic;
            this.fireChanged(new TopicMatcher(multiple.getChosen()));
        } else {
            this.fireChanged(new TopicMatcher(topic));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-topic");
    }

    public Serializable getSerializable() {
        return (Serializable)this.comboBox.getSelectedItem();
    }

    public void setSerializable(Serializable serializable) {
        this.comboBox.stopChangeEvents();
        if (serializable instanceof TopicAll) {
            this.comboBox.setSelectedItem((TopicAll)serializable);
            this.fireMatchAll();
        } else if (serializable instanceof TopicMultiple) {
            TopicMultiple tm = (TopicMultiple)serializable;
            this.comboModel.multiple.setChosen(tm.getChosen());
            this.comboBox.setSelectedItem(this.comboModel.multiple);
            this.fireChanged(new TopicMatcher(this.comboModel.multiple.getChosen()));
        } else if (serializable instanceof Topic) {
            Topic topic = (Topic)serializable;
            this.comboBox.setSelectedItem(topic);
            this.fireChanged(new TopicMatcher(topic));
        }
        this.comboBox.startChangeEvents();
    }

    public class TopicsComboBox
    extends FilterComboAbstract {
        private final ActionListener listener;
        private Object lastSelectedItem;

        public TopicsComboBox(TopicsComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = Utilities.isWindows() ? new WindowsActionListener() : new RealActionListener();
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
            this.lastSelectedItem = this.getSelectedItem();
        }

        private final class WindowsActionListener
        implements ActionListener {
            private WindowsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = TopicsComboBox.this.getSelectedItem();
                if (object instanceof TopicMultipleEdit) {
                    TopicMultiple tm = MatcherEditorTopic.this.comboModel.multiple;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getTopicManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)TopicsComboBox.this), all, tm.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-topic"));
                    d.setLocationRelativeTo((Component)((Object)TopicsComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        tm.setChosen(d.getChosen());
                        TopicsComboBox.this.setSelectedItem(tm);
                        TopicsComboBox.this.lastSelectedItem = tm;
                    } else {
                        TopicsComboBox.this.setSelectedItem(TopicsComboBox.this.lastSelectedItem);
                    }
                } else {
                    TopicsComboBox.this.lastSelectedItem = object;
                }
                TopicsComboBox.this.fireValueChange();
            }
        }

        private final class RealActionListener
        implements ActionListener {
            private RealActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = TopicsComboBox.this.getSelectedItem();
                if (object instanceof TopicMultiple) {
                    TopicMultiple tm = (TopicMultiple)object;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getTopicManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)TopicsComboBox.this), all, tm.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-topic"));
                    d.setLocationRelativeTo((Component)((Object)TopicsComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        tm.setChosen(d.getChosen());
                    }
                }
                TopicsComboBox.this.fireValueChange();
            }
        }
    }

    private class TopicsComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final TopicAll all = new TopicAll();
        private final TopicMultiple multiple = new TopicMultiple();
        private final TopicMultipleEdit multipleEdit = new TopicMultipleEdit();
        private Manager<Topic> topicManager;
        private List<Topic> topics;
        private Lookup.Result result;

        public TopicsComboBoxModel() {
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.topicManager != null) {
                this.topicManager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.topicManager = null;
                this.topics = new Vector<Topic>();
            } else {
                this.topicManager = data.getTopicManager();
                this.topicManager.addObserver((Observer)this);
                this.topics = this.topicManager.list();
                Collections.sort(this.topics);
            }
            this.topics.add(0, (Topic)this.all);
            this.topics.add(1, (Topic)this.multiple);
            if (Utilities.isWindows()) {
                this.topics.add(2, (Topic)this.multipleEdit);
            }
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        TopicsComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.topics.get(index);
        }

        public int getSize() {
            return this.topics.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopicMatcher
    implements Matcher<Future> {
        private final boolean all;
        private final List<Topic> topics;

        public TopicMatcher() {
            this.all = true;
            this.topics = null;
        }

        public TopicMatcher(Topic topic) {
            this.all = false;
            this.topics = new Vector<Topic>();
            this.topics.add(topic);
        }

        public TopicMatcher(List<Topic> topics) {
            this.all = false;
            this.topics = topics;
        }

        public boolean matches(Future future) {
            if (this.all) {
                return true;
            }
            for (Topic topic : this.topics) {
                if (!topic.equals((Object)future.getTopic())) continue;
                return true;
            }
            return false;
        }
    }
}

